/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.core.convert.ConversionService;
import org.springframework.integration.handler.AbstractMessageProcessor;
import org.springframework.integration.handler.support.MessagingMethodInvokerHelper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;

public class MethodInvokingMessageProcessor<T>
extends AbstractMessageProcessor<T>
implements Lifecycle {
    private final MessagingMethodInvokerHelper<T> delegate;

    public MethodInvokingMessageProcessor(Object targetObject, Method method) {
        this.delegate = new MessagingMethodInvokerHelper(targetObject, method, false);
    }

    public MethodInvokingMessageProcessor(Object targetObject, String methodName) {
        this.delegate = new MessagingMethodInvokerHelper(targetObject, methodName, false);
    }

    public MethodInvokingMessageProcessor(Object targetObject, String methodName, boolean canProcessMessageList) {
        this.delegate = new MessagingMethodInvokerHelper(targetObject, methodName, canProcessMessageList);
    }

    public MethodInvokingMessageProcessor(Object targetObject, Class<? extends Annotation> annotationType) {
        this.delegate = new MessagingMethodInvokerHelper(targetObject, annotationType, false);
    }

    @Override
    public void setConversionService(ConversionService conversionService) {
        super.setConversionService(conversionService);
        this.delegate.setConversionService(conversionService);
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        this.delegate.setBeanFactory(beanFactory);
    }

    public void setUseSpelInvoker(boolean useSpelInvoker) {
        this.delegate.setUseSpelInvoker(useSpelInvoker);
    }

    public void start() {
        this.delegate.start();
    }

    public void stop() {
        this.delegate.stop();
    }

    public boolean isRunning() {
        return this.delegate.isRunning();
    }

    @Override
    public T processMessage(Message<?> message) {
        try {
            return this.delegate.process(message);
        }
        catch (Exception e) {
            throw new MessageHandlingException(message, (Throwable)e);
        }
    }
}

