/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.gateway;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.MethodParameter;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.support.TaskExecutorAdapter;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.annotation.Gateway;
import org.springframework.integration.annotation.GatewayHeader;
import org.springframework.integration.endpoint.AbstractEndpoint;
import org.springframework.integration.expression.ExpressionUtils;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.gateway.GatewayMethodInboundMessageMapper;
import org.springframework.integration.gateway.GatewayMethodMetadata;
import org.springframework.integration.gateway.MessagingGatewaySupport;
import org.springframework.integration.gateway.MethodArgsMessageMapper;
import org.springframework.integration.gateway.RequestReplyExchanger;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.support.management.TrackableComponent;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class GatewayProxyFactoryBean
extends AbstractEndpoint
implements TrackableComponent,
FactoryBean<Object>,
MethodInterceptor,
BeanClassLoaderAware {
    private volatile Class<?> serviceInterface;
    private volatile MessageChannel defaultRequestChannel;
    private volatile String defaultRequestChannelName;
    private volatile MessageChannel defaultReplyChannel;
    private volatile String defaultReplyChannelName;
    private volatile MessageChannel errorChannel;
    private volatile String errorChannelName;
    private volatile Expression defaultRequestTimeout;
    private volatile Expression defaultReplyTimeout;
    private volatile DestinationResolver<MessageChannel> channelResolver;
    private volatile boolean shouldTrack = false;
    private volatile TypeConverter typeConverter = new SimpleTypeConverter();
    private volatile ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private volatile Object serviceProxy;
    private final Map<Method, MethodInvocationGateway> gatewayMap = new HashMap<Method, MethodInvocationGateway>();
    private volatile AsyncTaskExecutor asyncExecutor = new SimpleAsyncTaskExecutor();
    private volatile Class<?> asyncSubmitType;
    private volatile Class<?> asyncSubmitListenableType;
    private volatile boolean initialized;
    private final Object initializationMonitor = new Object();
    private volatile Map<String, GatewayMethodMetadata> methodMetadataMap;
    private volatile GatewayMethodMetadata globalMethodMetadata;
    private volatile MethodArgsMessageMapper argsMapper;
    private EvaluationContext evaluationContext = new StandardEvaluationContext();

    public GatewayProxyFactoryBean() {
    }

    public GatewayProxyFactoryBean(Class<?> serviceInterface) {
        Assert.notNull(serviceInterface, (String)"'serviceInterface' must not be null");
        Assert.isTrue((boolean)serviceInterface.isInterface(), (String)"'serviceInterface' must be an interface");
        this.serviceInterface = serviceInterface;
    }

    public void setServiceInterface(Class<?> serviceInterface) {
        Assert.notNull(serviceInterface, (String)"'serviceInterface' must not be null");
        Assert.isTrue((boolean)serviceInterface.isInterface(), (String)"'serviceInterface' must be an interface");
        this.serviceInterface = serviceInterface;
    }

    public void setDefaultRequestChannel(MessageChannel defaultRequestChannel) {
        this.defaultRequestChannel = defaultRequestChannel;
    }

    public void setDefaultRequestChannelName(String defaultRequestChannelName) {
        this.defaultRequestChannelName = defaultRequestChannelName;
    }

    public void setDefaultReplyChannel(MessageChannel defaultReplyChannel) {
        this.defaultReplyChannel = defaultReplyChannel;
    }

    public void setDefaultReplyChannelName(String defaultReplyChannelName) {
        this.defaultReplyChannelName = defaultReplyChannelName;
    }

    public void setErrorChannel(MessageChannel errorChannel) {
        this.errorChannel = errorChannel;
    }

    public void setErrorChannelName(String errorChannelName) {
        this.errorChannelName = errorChannelName;
    }

    public void setDefaultRequestTimeout(Long defaultRequestTimeout) {
        this.defaultRequestTimeout = new ValueExpression<Long>(defaultRequestTimeout);
    }

    public void setDefaultRequestTimeoutExpression(Expression defaultRequestTimeout) {
        this.defaultRequestTimeout = defaultRequestTimeout;
    }

    public void setDefaultRequestTimeoutExpressionString(String defaultRequestTimeout) {
        if (StringUtils.hasText((String)defaultRequestTimeout)) {
            this.defaultRequestTimeout = ExpressionUtils.longExpression(defaultRequestTimeout);
        }
    }

    public void setDefaultReplyTimeout(Long defaultReplyTimeout) {
        this.defaultReplyTimeout = new ValueExpression<Long>(defaultReplyTimeout);
    }

    public void setDefaultReplyTimeoutExpression(Expression defaultReplyTimeout) {
        this.defaultReplyTimeout = defaultReplyTimeout;
    }

    public void setDefaultReplyTimeoutExpressionString(String defaultReplyTimeout) {
        if (StringUtils.hasText((String)defaultReplyTimeout)) {
            this.defaultReplyTimeout = ExpressionUtils.longExpression(defaultReplyTimeout);
        }
    }

    @Override
    public void setShouldTrack(boolean shouldTrack) {
        this.shouldTrack = shouldTrack;
        if (!CollectionUtils.isEmpty(this.gatewayMap)) {
            for (MethodInvocationGateway gateway : this.gatewayMap.values()) {
                gateway.setShouldTrack(shouldTrack);
            }
        }
    }

    public void setAsyncExecutor(@Nullable Executor executor) {
        if (executor == null && this.logger.isInfoEnabled()) {
            this.logger.info((Object)"A null executor disables the async gateway; methods returning Future<?> will run on the calling thread");
        }
        this.asyncExecutor = executor instanceof AsyncTaskExecutor || executor == null ? (AsyncTaskExecutor)executor : new TaskExecutorAdapter(executor);
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        Assert.notNull((Object)typeConverter, (String)"typeConverter must not be null");
        this.typeConverter = typeConverter;
    }

    public void setMethodMetadataMap(Map<String, GatewayMethodMetadata> methodMetadataMap) {
        this.methodMetadataMap = methodMetadataMap;
    }

    public void setGlobalMethodMetadata(GatewayMethodMetadata globalMethodMetadata) {
        this.globalMethodMetadata = globalMethodMetadata;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public final void setMapper(MethodArgsMessageMapper mapper) {
        this.argsMapper = mapper;
    }

    protected AsyncTaskExecutor getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public Map<Method, MessagingGatewaySupport> getGateways() {
        return Collections.unmodifiableMap(this.gatewayMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onInit() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            Method[] methods;
            if (this.initialized) {
                return;
            }
            BeanFactory beanFactory = this.getBeanFactory();
            if (this.channelResolver == null && beanFactory != null) {
                this.channelResolver = new BeanFactoryChannelResolver(beanFactory);
            }
            Class<?> proxyInterface = this.determineServiceInterface();
            for (Method method : methods = ReflectionUtils.getUniqueDeclaredMethods(proxyInterface)) {
                MethodInvocationGateway gateway = this.createGatewayForMethod(method);
                this.gatewayMap.put(method, gateway);
            }
            this.serviceProxy = new ProxyFactory(proxyInterface, (Interceptor)this).getProxy(this.beanClassLoader);
            if (this.asyncExecutor != null) {
                Callable<String> task = () -> null;
                Future submitType = this.asyncExecutor.submit(task);
                this.asyncSubmitType = submitType.getClass();
                if (this.asyncExecutor instanceof AsyncListenableTaskExecutor) {
                    submitType = ((AsyncListenableTaskExecutor)this.asyncExecutor).submitListenable(task);
                    this.asyncSubmitListenableType = submitType.getClass();
                }
            }
            this.evaluationContext = ExpressionUtils.createStandardEvaluationContext(this.getBeanFactory());
            this.initialized = true;
        }
    }

    private Class<?> determineServiceInterface() {
        if (this.serviceInterface == null) {
            this.serviceInterface = RequestReplyExchanger.class;
        }
        return this.serviceInterface;
    }

    public Class<?> getObjectType() {
        return this.serviceInterface != null ? this.serviceInterface : null;
    }

    public Object getObject() throws Exception {
        if (this.serviceProxy == null) {
            this.onInit();
            Assert.notNull((Object)this.serviceProxy, (String)"failed to initialize proxy");
        }
        return this.serviceProxy;
    }

    public boolean isSingleton() {
        return true;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class<?> returnType = invocation.getMethod().getReturnType();
        if (this.asyncExecutor != null && !Object.class.equals(returnType)) {
            Invoker invoker = new Invoker(invocation);
            if (returnType.isAssignableFrom(this.asyncSubmitType)) {
                return this.asyncExecutor.submit(invoker::get);
            }
            if (returnType.isAssignableFrom(this.asyncSubmitListenableType)) {
                return ((AsyncListenableTaskExecutor)this.asyncExecutor).submitListenable(invoker::get);
            }
            if (CompletableFuture.class.equals(returnType)) {
                return CompletableFuture.supplyAsync(invoker, (Executor)this.asyncExecutor);
            }
            if (Future.class.isAssignableFrom(returnType) && this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("AsyncTaskExecutor submit*() return types are incompatible with the method return type; running on calling thread; the downstream flow must return the required Future: " + returnType.getSimpleName()));
            }
        }
        if (Mono.class.isAssignableFrom(returnType)) {
            return Mono.fromSupplier((Supplier)new Invoker(invocation));
        }
        return this.doInvoke(invocation, true);
    }

    protected Object doInvoke(MethodInvocation invocation, boolean runningOnCallerThread) throws Throwable {
        Method method = invocation.getMethod();
        if (AopUtils.isToStringMethod((Method)method)) {
            return "gateway proxy for service interface [" + this.serviceInterface + "]";
        }
        try {
            return this.invokeGatewayMethod(invocation, runningOnCallerThread);
        }
        catch (Throwable e) {
            this.rethrowExceptionCauseIfPossible(e, invocation.getMethod());
            return null;
        }
    }

    @Nullable
    private Object invokeGatewayMethod(MethodInvocation invocation, boolean runningOnCallerThread) throws Exception {
        if (!this.initialized) {
            this.afterPropertiesSet();
        }
        Method method = invocation.getMethod();
        MethodInvocationGateway gateway = this.gatewayMap.get(method);
        Class<?> returnType = method.getReturnType();
        boolean shouldReturnMessage = Message.class.isAssignableFrom(returnType) || GatewayProxyFactoryBean.hasReturnParameterizedWithMessage(method, runningOnCallerThread);
        boolean shouldReply = returnType != Void.TYPE;
        int paramCount = method.getParameterTypes().length;
        Object response = null;
        boolean hasPayloadExpression = method.isAnnotationPresent(Payload.class);
        if (!hasPayloadExpression) {
            if (this.methodMetadataMap != null) {
                GatewayMethodMetadata metadata = this.methodMetadataMap.get(method.getName());
                hasPayloadExpression = metadata != null && StringUtils.hasText((String)metadata.getPayloadExpression());
            } else if (this.globalMethodMetadata != null) {
                hasPayloadExpression = StringUtils.hasText((String)this.globalMethodMetadata.getPayloadExpression());
            }
        }
        if (paramCount == 0 && !hasPayloadExpression) {
            Long receiveTimeout = null;
            if (gateway.getReceiveTimeoutExpression() != null) {
                receiveTimeout = (Long)gateway.getReceiveTimeoutExpression().getValue(this.evaluationContext, Long.class);
            }
            if (shouldReply) {
                if (shouldReturnMessage) {
                    if (receiveTimeout != null) {
                        return gateway.receiveMessage(receiveTimeout);
                    }
                    return gateway.receiveMessage();
                }
                response = receiveTimeout != null ? gateway.receive(receiveTimeout) : gateway.receive();
            }
        } else {
            Object[] args = invocation.getArguments();
            if (shouldReply) {
                response = shouldReturnMessage ? gateway.sendAndReceiveMessage(args) : gateway.sendAndReceive(args);
            } else {
                gateway.send(args);
                response = null;
            }
        }
        return response != null ? this.convert(response, returnType) : null;
    }

    private void rethrowExceptionCauseIfPossible(Throwable originalException, Method method) throws Throwable {
        Class<?>[] exceptionTypes = method.getExceptionTypes();
        for (Throwable t = originalException; t != null; t = t.getCause()) {
            for (Class<?> exceptionType : exceptionTypes) {
                if (!exceptionType.isAssignableFrom(t.getClass())) continue;
                throw t;
            }
            if (!(t instanceof RuntimeException) || t instanceof MessagingException || t instanceof UndeclaredThrowableException || t instanceof IllegalStateException && "Unexpected exception thrown".equals(t.getMessage())) continue;
            throw t;
        }
        throw originalException;
    }

    private MethodInvocationGateway createGatewayForMethod(Method method) {
        String errorChannel;
        GatewayMethodMetadata methodMetadata;
        Gateway gatewayAnnotation = method.getAnnotation(Gateway.class);
        String requestChannelName = null;
        String replyChannelName = null;
        Expression requestTimeout = this.defaultRequestTimeout;
        Expression replyTimeout = this.defaultReplyTimeout;
        String payloadExpression = this.globalMethodMetadata != null ? this.globalMethodMetadata.getPayloadExpression() : null;
        HashMap<String, Expression> headerExpressions = new HashMap<String, Expression>();
        if (gatewayAnnotation != null) {
            requestChannelName = gatewayAnnotation.requestChannel();
            replyChannelName = gatewayAnnotation.replyChannel();
            if (requestTimeout == null || gatewayAnnotation.requestTimeout() != Long.MIN_VALUE) {
                requestTimeout = new ValueExpression(gatewayAnnotation.requestTimeout());
            }
            if (StringUtils.hasText((String)gatewayAnnotation.requestTimeoutExpression())) {
                requestTimeout = ExpressionUtils.longExpression(gatewayAnnotation.requestTimeoutExpression());
            }
            if (replyTimeout == null || gatewayAnnotation.replyTimeout() != Long.MIN_VALUE) {
                replyTimeout = new ValueExpression(gatewayAnnotation.replyTimeout());
            }
            if (StringUtils.hasText((String)gatewayAnnotation.replyTimeoutExpression())) {
                replyTimeout = ExpressionUtils.longExpression(gatewayAnnotation.replyTimeoutExpression());
            }
            if (payloadExpression == null || StringUtils.hasText((String)gatewayAnnotation.payloadExpression())) {
                payloadExpression = gatewayAnnotation.payloadExpression();
            }
            if (!ObjectUtils.isEmpty((Object[])gatewayAnnotation.headers())) {
                for (GatewayHeader gatewayHeader : gatewayAnnotation.headers()) {
                    String value = gatewayHeader.value();
                    String expression = gatewayHeader.expression();
                    String name = gatewayHeader.name();
                    boolean hasValue = StringUtils.hasText((String)value);
                    if (hasValue == StringUtils.hasText((String)expression)) {
                        throw new BeanDefinitionStoreException("exactly one of 'value' or 'expression' is required on a gateway's header.");
                    }
                    headerExpressions.put(name, (Expression)(hasValue ? new LiteralExpression(value) : EXPRESSION_PARSER.parseExpression(expression)));
                }
            }
        } else if (this.methodMetadataMap != null && this.methodMetadataMap.size() > 0 && (methodMetadata = this.methodMetadataMap.get(method.getName())) != null) {
            String repTimeout;
            if (StringUtils.hasText((String)methodMetadata.getPayloadExpression())) {
                payloadExpression = methodMetadata.getPayloadExpression();
            }
            if (!CollectionUtils.isEmpty(methodMetadata.getHeaderExpressions())) {
                headerExpressions.putAll(methodMetadata.getHeaderExpressions());
            }
            requestChannelName = methodMetadata.getRequestChannelName();
            replyChannelName = methodMetadata.getReplyChannelName();
            String reqTimeout = methodMetadata.getRequestTimeout();
            if (StringUtils.hasText((String)reqTimeout)) {
                requestTimeout = ExpressionUtils.longExpression(reqTimeout);
            }
            if (StringUtils.hasText((String)(repTimeout = methodMetadata.getReplyTimeout()))) {
                replyTimeout = ExpressionUtils.longExpression(repTimeout);
            }
        }
        HashMap<String, Object> headers = null;
        String string = errorChannel = this.errorChannel == null ? this.errorChannelName : this.errorChannel;
        if (errorChannel != null && method.getReturnType().equals(Void.TYPE)) {
            headers = new HashMap<String, Object>();
            headers.put("errorChannel", errorChannel);
        }
        if (this.getMessageBuilderFactory() instanceof DefaultMessageBuilderFactory) {
            HashSet headerNames = new HashSet(headerExpressions.keySet());
            if (this.globalMethodMetadata != null) {
                headerNames.addAll(this.globalMethodMetadata.getHeaderExpressions().keySet());
            }
            List<MethodParameter> methodParameters = GatewayMethodInboundMessageMapper.getMethodParameterList(method);
            for (MethodParameter methodParameter : methodParameters) {
                Header header = (Header)methodParameter.getParameterAnnotation(Header.class);
                if (header == null) continue;
                String headerName = GatewayMethodInboundMessageMapper.determineHeaderName((Annotation)header, methodParameter);
                headerNames.add(headerName);
            }
            for (String header : headerNames) {
                if (!"id".equals(header) && !"timestamp".equals(header)) continue;
                throw new BeanInitializationException("Messaging Gateway cannot override 'id' and 'timestamp' read-only headers.\nWrong headers configuration for " + this.getComponentName());
            }
        }
        GatewayMethodInboundMessageMapper messageMapper = new GatewayMethodInboundMessageMapper(method, headerExpressions, this.globalMethodMetadata != null ? this.globalMethodMetadata.getHeaderExpressions() : null, headers, this.argsMapper, this.getMessageBuilderFactory());
        if (StringUtils.hasText((String)payloadExpression)) {
            messageMapper.setPayloadExpression(payloadExpression);
        }
        messageMapper.setBeanFactory(this.getBeanFactory());
        MethodInvocationGateway gateway = new MethodInvocationGateway(messageMapper);
        if (this.errorChannel != null) {
            gateway.setErrorChannel(this.errorChannel);
        } else if (StringUtils.hasText((String)this.errorChannelName)) {
            gateway.setErrorChannelName(this.errorChannelName);
        }
        if (this.getTaskScheduler() != null) {
            gateway.setTaskScheduler(this.getTaskScheduler());
        }
        gateway.setBeanName(this.getComponentName());
        if (StringUtils.hasText((String)requestChannelName)) {
            gateway.setRequestChannelName(requestChannelName);
        } else if (StringUtils.hasText((String)this.defaultRequestChannelName)) {
            gateway.setRequestChannelName(this.defaultRequestChannelName);
        } else {
            gateway.setRequestChannel(this.defaultRequestChannel);
        }
        if (StringUtils.hasText((String)replyChannelName)) {
            gateway.setReplyChannelName(replyChannelName);
        } else if (StringUtils.hasText((String)this.defaultReplyChannelName)) {
            gateway.setReplyChannelName(this.defaultReplyChannelName);
        } else {
            gateway.setReplyChannel(this.defaultReplyChannel);
        }
        if (requestTimeout == null) {
            gateway.setRequestTimeout(-1L);
        } else if (requestTimeout instanceof ValueExpression) {
            gateway.setRequestTimeout((Long)requestTimeout.getValue(Long.class));
        } else {
            messageMapper.setSendTimeoutExpression(requestTimeout);
        }
        if (replyTimeout == null) {
            gateway.setReplyTimeout(-1L);
        } else if (replyTimeout instanceof ValueExpression) {
            gateway.setReplyTimeout((Long)replyTimeout.getValue(Long.class));
        } else {
            messageMapper.setReplyTimeoutExpression(replyTimeout);
        }
        if (this.getBeanFactory() != null) {
            gateway.setBeanFactory(this.getBeanFactory());
        }
        if (replyTimeout != null) {
            gateway.setReceiveTimeoutExpression(replyTimeout);
        }
        gateway.setShouldTrack(this.shouldTrack);
        gateway.afterPropertiesSet();
        return gateway;
    }

    @Override
    protected void doStart() {
        for (MethodInvocationGateway gateway : this.gatewayMap.values()) {
            gateway.start();
        }
    }

    @Override
    protected void doStop() {
        for (MethodInvocationGateway gateway : this.gatewayMap.values()) {
            gateway.stop();
        }
    }

    private <T> T convert(Object source, Class<T> expectedReturnType) {
        if (Future.class.isAssignableFrom(expectedReturnType)) {
            return (T)source;
        }
        if (Mono.class.isAssignableFrom(expectedReturnType)) {
            return (T)source;
        }
        if (this.getConversionService() != null) {
            return (T)this.getConversionService().convert(source, expectedReturnType);
        }
        return (T)this.typeConverter.convertIfNecessary(source, expectedReturnType);
    }

    private static boolean hasReturnParameterizedWithMessage(Method method, boolean runningOnCallerThread) {
        Type rawType;
        Type parameterizedType;
        Type[] typeArgs;
        Type returnType;
        if (!runningOnCallerThread && (Future.class.isAssignableFrom(method.getReturnType()) || Mono.class.isAssignableFrom(method.getReturnType())) && (returnType = method.getGenericReturnType()) instanceof ParameterizedType && (typeArgs = ((ParameterizedType)returnType).getActualTypeArguments()) != null && typeArgs.length == 1 && (parameterizedType = typeArgs[0]) instanceof ParameterizedType && (rawType = ((ParameterizedType)parameterizedType).getRawType()) instanceof Class) {
            return Message.class.isAssignableFrom((Class)rawType);
        }
        return false;
    }

    private final class Invoker
    implements Supplier<Object> {
        private final MethodInvocation invocation;

        Invoker(MethodInvocation methodInvocation) {
            this.invocation = methodInvocation;
        }

        @Override
        public Object get() {
            try {
                return GatewayProxyFactoryBean.this.doInvoke(this.invocation, false);
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new MessagingException("Asynchronous gateway invocation failed", t);
            }
        }
    }

    private static final class MethodInvocationGateway
    extends MessagingGatewaySupport {
        Expression receiveTimeoutExpression;

        MethodInvocationGateway(GatewayMethodInboundMessageMapper messageMapper) {
            this.setRequestMapper(messageMapper);
        }

        Expression getReceiveTimeoutExpression() {
            return this.receiveTimeoutExpression;
        }

        void setReceiveTimeoutExpression(Expression receiveTimeoutExpression) {
            this.receiveTimeoutExpression = receiveTimeoutExpression;
        }
    }
}

