/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.integration.config.ChannelInitializer;
import org.springframework.integration.config.DefaultConfiguringBeanFactoryPostProcessor;
import org.springframework.integration.config.EnablePublisher;
import org.springframework.integration.config.IntegrationConfigurationBeanFactoryPostProcessor;
import org.springframework.integration.config.PublisherRegistrar;
import org.springframework.integration.config.annotation.MessagingAnnotationPostProcessor;
import org.springframework.integration.context.IntegrationProperties;
import org.springframework.lang.Nullable;

public class IntegrationRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(@Nullable AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        this.registerImplicitChannelCreator(registry);
        this.registerDefaultConfiguringBeanFactoryPostProcessor(registry);
        this.registerIntegrationConfigurationBeanFactoryPostProcessor(registry);
        if (importingClassMetadata != null) {
            this.registerMessagingAnnotationPostProcessors(importingClassMetadata, registry);
        }
    }

    private void registerImplicitChannelCreator(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("channelInitializer")) {
            String channelsAutoCreateExpression = IntegrationProperties.getExpressionFor("spring.integration.channels.autoCreate");
            BeanDefinitionBuilder channelDef = BeanDefinitionBuilder.genericBeanDefinition(ChannelInitializer.class).addPropertyValue("autoCreate", (Object)channelsAutoCreateExpression);
            BeanDefinitionHolder channelCreatorHolder = new BeanDefinitionHolder((BeanDefinition)channelDef.getBeanDefinition(), "channelInitializer");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)channelCreatorHolder, (BeanDefinitionRegistry)registry);
        }
        if (!registry.containsBeanDefinition("$autoCreateChannelCandidates")) {
            BeanDefinitionBuilder channelRegistryBuilder = BeanDefinitionBuilder.genericBeanDefinition(ChannelInitializer.AutoCreateCandidatesCollector.class);
            channelRegistryBuilder.addConstructorArgValue((Object)new ManagedSet());
            channelRegistryBuilder.setRole(2);
            BeanDefinitionHolder channelRegistryHolder = new BeanDefinitionHolder((BeanDefinition)channelRegistryBuilder.getBeanDefinition(), "$autoCreateChannelCandidates");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)channelRegistryHolder, (BeanDefinitionRegistry)registry);
        }
    }

    private void registerDefaultConfiguringBeanFactoryPostProcessor(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("DefaultConfiguringBeanFactoryPostProcessor")) {
            BeanDefinitionBuilder postProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultConfiguringBeanFactoryPostProcessor.class);
            BeanDefinitionHolder postProcessorHolder = new BeanDefinitionHolder((BeanDefinition)postProcessorBuilder.getBeanDefinition(), "DefaultConfiguringBeanFactoryPostProcessor");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)postProcessorHolder, (BeanDefinitionRegistry)registry);
        }
    }

    private void registerIntegrationConfigurationBeanFactoryPostProcessor(BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("IntegrationConfigurationBeanFactoryPostProcessor")) {
            BeanDefinitionBuilder postProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition(IntegrationConfigurationBeanFactoryPostProcessor.class).setRole(2);
            registry.registerBeanDefinition("IntegrationConfigurationBeanFactoryPostProcessor", (BeanDefinition)postProcessorBuilder.getBeanDefinition());
        }
    }

    private void registerMessagingAnnotationPostProcessors(AnnotationMetadata meta, BeanDefinitionRegistry registry) {
        if (!registry.containsBeanDefinition("org.springframework.integration.internalMessagingAnnotationPostProcessor")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MessagingAnnotationPostProcessor.class).setRole(2);
            registry.registerBeanDefinition("org.springframework.integration.internalMessagingAnnotationPostProcessor", (BeanDefinition)builder.getBeanDefinition());
        }
        if (meta.getAnnotationAttributes(EnablePublisher.class.getName()) != null) {
            new PublisherRegistrar().registerBeanDefinitions(meta, registry);
        }
    }
}

