/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.integration.channel.DefaultHeaderChannelRegistry;
import org.springframework.integration.channel.MessagePublishingErrorHandler;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.config.GlobalChannelInterceptorProcessor;
import org.springframework.integration.config.IdGeneratorConfigurer;
import org.springframework.integration.config.IntegrationConfigUtils;
import org.springframework.integration.config.IntegrationConverterInitializer;
import org.springframework.integration.config.IntegrationEvaluationContextFactoryBean;
import org.springframework.integration.config.IntegrationSimpleEvaluationContextFactoryBean;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.context.IntegrationProperties;
import org.springframework.integration.handler.LoggingHandler;
import org.springframework.integration.handler.support.CollectionArgumentResolver;
import org.springframework.integration.handler.support.HandlerMethodArgumentResolversHolder;
import org.springframework.integration.handler.support.MapArgumentResolver;
import org.springframework.integration.handler.support.PayloadExpressionArgumentResolver;
import org.springframework.integration.handler.support.PayloadsArgumentResolver;
import org.springframework.integration.support.DefaultMessageBuilderFactory;
import org.springframework.integration.support.NullAwarePayloadArgumentResolver;
import org.springframework.integration.support.SmartLifecycleRoleController;
import org.springframework.integration.support.converter.ConfigurableCompositeMessageConverter;
import org.springframework.integration.support.converter.DefaultDatatypeChannelMessageConverter;
import org.springframework.integration.support.json.JacksonPresent;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.ClassUtils;

class DefaultConfiguringBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
BeanClassLoaderAware,
SmartInitializingSingleton {
    private static final Log logger = LogFactory.getLog(DefaultConfiguringBeanFactoryPostProcessor.class);
    private static final IntegrationConverterInitializer INTEGRATION_CONVERTER_INITIALIZER = new IntegrationConverterInitializer();
    private static final Set<Integer> registriesProcessed = new HashSet<Integer>();
    private ClassLoader classLoader;
    private ConfigurableListableBeanFactory beanFactory;
    private BeanDefinitionRegistry registry;

    DefaultConfiguringBeanFactoryPostProcessor() {
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            this.beanFactory = beanFactory;
            this.registry = (BeanDefinitionRegistry)beanFactory;
            this.registerNullChannel();
            this.registerErrorChannel();
            this.registerIntegrationEvaluationContext();
            this.registerTaskScheduler();
            this.registerIdGeneratorConfigurer();
            this.registerIntegrationProperties();
            this.registerBuiltInBeans();
            this.registerRoleController();
            this.registerMessageBuilderFactory();
            this.registerHeaderChannelRegistry();
            this.registerGlobalChannelInterceptorProcessor();
            this.registerDefaultDatatypeChannelMessageConverter();
            this.registerArgumentResolverMessageConverter();
            this.registerArgumentResolvers();
            this.registerListCapableArgumentResolvers();
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"BeanFactory is not a BeanDefinitionRegistry. The default Spring Integration infrastructure beans are not going to be registered");
        }
    }

    public void afterSingletonsInstantiated() {
        if (logger.isDebugEnabled()) {
            Properties integrationProperties = IntegrationContextUtils.getIntegrationProperties((BeanFactory)this.beanFactory);
            StringWriter writer = new StringWriter();
            integrationProperties.list(new PrintWriter(writer));
            StringBuffer propertiesBuffer = writer.getBuffer().delete(0, "-- listing properties --".length());
            logger.debug((Object)("\nSpring Integration global properties:\n" + propertiesBuffer));
        }
    }

    private void registerNullChannel() {
        if (this.beanFactory.containsBean("nullChannel")) {
            BeanDefinition nullChannelDefinition = this.beanFactory.containsBeanDefinition("nullChannel") ? this.beanFactory.getBeanDefinition("nullChannel") : ((BeanDefinitionRegistry)this.beanFactory.getParentBeanFactory()).getBeanDefinition("nullChannel");
            if (!NullChannel.class.getName().equals(nullChannelDefinition.getBeanClassName())) {
                throw new IllegalStateException("The bean name 'nullChannel' is reserved.");
            }
        } else {
            this.registry.registerBeanDefinition("nullChannel", (BeanDefinition)new RootBeanDefinition(NullChannel.class));
        }
    }

    private void registerErrorChannel() {
        if (!this.beanFactory.containsBean("errorChannel")) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"No bean named 'errorChannel' has been explicitly defined. Therefore, a default PublishSubscribeChannel will be created.");
            }
            this.registry.registerBeanDefinition("errorChannel", (BeanDefinition)new RootBeanDefinition(PublishSubscribeChannel.class));
            AbstractBeanDefinition loggingHandler = BeanDefinitionBuilder.genericBeanDefinition(LoggingHandler.class).addConstructorArgValue((Object)"ERROR").getBeanDefinition();
            String errorLoggerBeanName = "_org.springframework.integration.errorLogger.handler";
            this.registry.registerBeanDefinition(errorLoggerBeanName, (BeanDefinition)loggingHandler);
            BeanDefinitionBuilder loggingEndpointBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConsumerEndpointFactoryBean.class).addPropertyReference("handler", errorLoggerBeanName).addPropertyValue("inputChannelName", (Object)"errorChannel");
            BeanComponentDefinition componentDefinition = new BeanComponentDefinition((BeanDefinition)loggingEndpointBuilder.getBeanDefinition(), "_org.springframework.integration.errorLogger");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)componentDefinition, (BeanDefinitionRegistry)this.registry);
        }
    }

    private void registerIntegrationEvaluationContext() {
        BeanDefinitionHolder integrationEvaluationContextHolder;
        BeanDefinitionBuilder integrationEvaluationContextBuilder;
        if (!this.registry.containsBeanDefinition("integrationEvaluationContext")) {
            integrationEvaluationContextBuilder = BeanDefinitionBuilder.genericBeanDefinition(IntegrationEvaluationContextFactoryBean.class);
            integrationEvaluationContextBuilder.setRole(2);
            integrationEvaluationContextHolder = new BeanDefinitionHolder((BeanDefinition)integrationEvaluationContextBuilder.getBeanDefinition(), "integrationEvaluationContext");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)integrationEvaluationContextHolder, (BeanDefinitionRegistry)this.registry);
        }
        if (!this.registry.containsBeanDefinition("integrationSimpleEvaluationContext")) {
            integrationEvaluationContextBuilder = BeanDefinitionBuilder.genericBeanDefinition(IntegrationSimpleEvaluationContextFactoryBean.class);
            integrationEvaluationContextBuilder.setRole(2);
            integrationEvaluationContextHolder = new BeanDefinitionHolder((BeanDefinition)integrationEvaluationContextBuilder.getBeanDefinition(), "integrationSimpleEvaluationContext");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)integrationEvaluationContextHolder, (BeanDefinitionRegistry)this.registry);
        }
    }

    private void registerIdGeneratorConfigurer() {
        String[] definitionNames;
        Class<IdGeneratorConfigurer> clazz = IdGeneratorConfigurer.class;
        String className = clazz.getName();
        for (String definitionName : definitionNames = this.registry.getBeanDefinitionNames()) {
            BeanDefinition definition = this.registry.getBeanDefinition(definitionName);
            if (!className.equals(definition.getBeanClassName())) continue;
            if (logger.isInfoEnabled()) {
                logger.info((Object)(className + " is already registered and will be used"));
            }
            return;
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition(clazz);
        beanDefinition.setRole(2);
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)this.registry);
    }

    private void registerTaskScheduler() {
        if (!this.beanFactory.containsBean("taskScheduler")) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"No bean named 'taskScheduler' has been explicitly defined. Therefore, a default ThreadPoolTaskScheduler will be created.");
            }
            AbstractBeanDefinition scheduler = BeanDefinitionBuilder.genericBeanDefinition(ThreadPoolTaskScheduler.class).addPropertyValue("poolSize", (Object)IntegrationProperties.getExpressionFor("spring.integration.taskScheduler.poolSize")).addPropertyValue("threadNamePrefix", (Object)"task-scheduler-").addPropertyValue("rejectedExecutionHandler", (Object)new ThreadPoolExecutor.CallerRunsPolicy()).addPropertyValue("errorHandler", (Object)new RootBeanDefinition(MessagePublishingErrorHandler.class)).getBeanDefinition();
            this.registry.registerBeanDefinition("taskScheduler", (BeanDefinition)scheduler);
        }
    }

    private void registerIntegrationProperties() {
        if (!this.beanFactory.containsBean("integrationGlobalProperties")) {
            PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver(this.classLoader);
            try {
                Resource[] defaultResources = resourceResolver.getResources("classpath*:META-INF/spring.integration.default.properties");
                Resource[] userResources = resourceResolver.getResources("classpath*:META-INF/spring.integration.properties");
                LinkedList<Resource> resources = new LinkedList<Resource>(Arrays.asList(defaultResources));
                resources.addAll(Arrays.asList(userResources));
                BeanDefinitionBuilder integrationPropertiesBuilder = BeanDefinitionBuilder.genericBeanDefinition(PropertiesFactoryBean.class).addPropertyValue("locations", resources);
                this.registry.registerBeanDefinition("integrationGlobalProperties", (BeanDefinition)integrationPropertiesBuilder.getBeanDefinition());
            }
            catch (IOException e) {
                logger.warn((Object)"Cannot load 'spring.integration.properties' Resources.", (Throwable)e);
            }
        }
    }

    private void registerBuiltInBeans() {
        String xpathBeanName;
        int registryId = System.identityHashCode(this.registry);
        String jsonPathBeanName = "jsonPath";
        if (!this.beanFactory.containsBean(jsonPathBeanName) && !registriesProcessed.contains(registryId)) {
            Class jsonPathClass = null;
            try {
                jsonPathClass = ClassUtils.forName((String)"com.jayway.jsonpath.JsonPath", (ClassLoader)this.classLoader);
            }
            catch (ClassNotFoundException e) {
                logger.debug((Object)"The '#jsonPath' SpEL function cannot be registered: there is no jayway json-path.jar on the classpath.");
            }
            if (jsonPathClass != null) {
                try {
                    ClassUtils.forName((String)"com.jayway.jsonpath.Predicate", (ClassLoader)this.classLoader);
                }
                catch (ClassNotFoundException e) {
                    jsonPathClass = null;
                    logger.warn((Object)"The '#jsonPath' SpEL function cannot be registered. An old json-path.jar version is detected in the classpath.At least 2.4.0 is required; see version information at: https://github.com/jayway/JsonPath/releases", (Throwable)e);
                }
            }
            if (jsonPathClass != null) {
                IntegrationConfigUtils.registerSpelFunctionBean(this.registry, jsonPathBeanName, "org.springframework.integration.json.JsonPathUtils", "evaluate");
            }
        }
        if (!this.beanFactory.containsBean(xpathBeanName = "xpath") && !registriesProcessed.contains(registryId)) {
            Class xpathClass = null;
            try {
                xpathClass = ClassUtils.forName((String)"org.springframework.integration.xml.xpath.XPathUtils", (ClassLoader)this.classLoader);
            }
            catch (ClassNotFoundException e) {
                logger.debug((Object)"SpEL function '#xpath' isn't registered: there is no spring-integration-xml.jar on the classpath.");
            }
            if (xpathClass != null) {
                IntegrationConfigUtils.registerSpelFunctionBean(this.registry, xpathBeanName, "org.springframework.integration.xml.xpath.XPathUtils", "evaluate");
            }
        }
        if (!this.beanFactory.containsBean("toStringFriendlyJsonNodeToStringConverter") && !registriesProcessed.contains(registryId) && JacksonPresent.isJackson2Present()) {
            this.registry.registerBeanDefinition("toStringFriendlyJsonNodeToStringConverter", (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.json.ToStringFriendlyJsonNodeToStringConverter").getBeanDefinition());
            INTEGRATION_CONVERTER_INITIALIZER.registerConverter(this.registry, (BeanMetadataElement)new RuntimeBeanReference("toStringFriendlyJsonNodeToStringConverter"));
        }
        registriesProcessed.add(registryId);
    }

    private void registerRoleController() {
        if (!this.beanFactory.containsBean("integrationLifecycleRoleController")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(SmartLifecycleRoleController.class);
            builder.addConstructorArgValue((Object)new ManagedList());
            builder.addConstructorArgValue((Object)new ManagedList());
            this.registry.registerBeanDefinition("integrationLifecycleRoleController", (BeanDefinition)builder.getBeanDefinition());
        }
    }

    private void registerMessageBuilderFactory() {
        if (!this.beanFactory.containsBean("messageBuilderFactory")) {
            BeanDefinitionBuilder mbfBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultMessageBuilderFactory.class).addPropertyValue("readOnlyHeaders", (Object)IntegrationProperties.getExpressionFor("spring.integration.readOnly.headers"));
            this.registry.registerBeanDefinition("messageBuilderFactory", (BeanDefinition)mbfBuilder.getBeanDefinition());
        }
    }

    private void registerHeaderChannelRegistry() {
        if (!this.beanFactory.containsBean("integrationHeaderChannelRegistry")) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"No bean named 'integrationHeaderChannelRegistry' has been explicitly defined. Therefore, a default DefaultHeaderChannelRegistry will be created.");
            }
            BeanDefinitionBuilder schedulerBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultHeaderChannelRegistry.class);
            BeanDefinitionHolder replyChannelRegistryComponent = new BeanDefinitionHolder((BeanDefinition)schedulerBuilder.getBeanDefinition(), "integrationHeaderChannelRegistry");
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)replyChannelRegistryComponent, (BeanDefinitionRegistry)this.registry);
        }
    }

    private void registerGlobalChannelInterceptorProcessor() {
        if (!this.registry.containsBeanDefinition("globalChannelInterceptorProcessor")) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GlobalChannelInterceptorProcessor.class).setRole(2);
            this.registry.registerBeanDefinition("globalChannelInterceptorProcessor", (BeanDefinition)builder.getBeanDefinition());
        }
    }

    private void registerDefaultDatatypeChannelMessageConverter() {
        if (!this.beanFactory.containsBean("datatypeChannelMessageConverter")) {
            BeanDefinitionBuilder converterBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultDatatypeChannelMessageConverter.class);
            this.registry.registerBeanDefinition("datatypeChannelMessageConverter", (BeanDefinition)converterBuilder.getBeanDefinition());
        }
    }

    private void registerArgumentResolverMessageConverter() {
        if (!this.beanFactory.containsBean("integrationArgumentResolverMessageConverter")) {
            BeanDefinitionBuilder converterBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConfigurableCompositeMessageConverter.class);
            this.registry.registerBeanDefinition("integrationArgumentResolverMessageConverter", (BeanDefinition)converterBuilder.getBeanDefinition());
        }
    }

    private void registerArgumentResolvers() {
        if (!this.beanFactory.containsBean("integrationArgumentResolvers")) {
            this.registry.registerBeanDefinition("integrationArgumentResolvers", this.internalArgumentResolversBuilder(false));
        }
    }

    private void registerListCapableArgumentResolvers() {
        if (!this.beanFactory.containsBean("integrationListArgumentResolvers")) {
            this.registry.registerBeanDefinition("integrationListArgumentResolvers", this.internalArgumentResolversBuilder(true));
        }
    }

    private BeanDefinition internalArgumentResolversBuilder(boolean listCapable) {
        ManagedList resolvers = new ManagedList();
        resolvers.add((Object)new RootBeanDefinition(PayloadExpressionArgumentResolver.class));
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(NullAwarePayloadArgumentResolver.class);
        builder.addConstructorArgReference("integrationArgumentResolverMessageConverter");
        resolvers.add((Object)builder.getBeanDefinition());
        resolvers.add((Object)new RootBeanDefinition(PayloadsArgumentResolver.class));
        resolvers.add((Object)new RootBeanDefinition(MapArgumentResolver.class));
        if (listCapable) {
            resolvers.add((Object)BeanDefinitionBuilder.genericBeanDefinition(CollectionArgumentResolver.class).addConstructorArgValue((Object)true).getBeanDefinition());
        }
        return BeanDefinitionBuilder.genericBeanDefinition(HandlerMethodArgumentResolversHolder.class).addConstructorArgValue((Object)resolvers).getBeanDefinition();
    }
}

