/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import org.springframework.integration.core.ErrorMessagePublisher;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.integration.support.MessagingExceptionWrapper;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public class MessagePublishingErrorHandler
extends ErrorMessagePublisher
implements ErrorHandler {
    private static final int DEFAULT_SEND_TIMEOUT = 1000;
    private static final ErrorMessageStrategy DEFAULT_ERROR_MESSAGE_STRATEGY = (t, a) -> {
        if (t instanceof MessagingExceptionWrapper) {
            return new ErrorMessage(t.getCause(), ((MessagingExceptionWrapper)((Object)((Object)t))).getFailedMessage());
        }
        return new ErrorMessage(t);
    };

    public MessagePublishingErrorHandler() {
        this.setErrorMessageStrategy(DEFAULT_ERROR_MESSAGE_STRATEGY);
        this.setSendTimeout(1000L);
    }

    public MessagePublishingErrorHandler(DestinationResolver<MessageChannel> channelResolver) {
        this();
        this.setChannelResolver(channelResolver);
    }

    public void setDefaultErrorChannel(MessageChannel defaultErrorChannel) {
        this.setChannel(defaultErrorChannel);
    }

    public MessageChannel getDefaultErrorChannel() {
        return this.getChannel();
    }

    public void setDefaultErrorChannelName(String defaultErrorChannelName) {
        this.setChannelName(defaultErrorChannelName);
    }

    public final void handleError(Throwable t) {
        boolean sent;
        block7: {
            MessageChannel errorChannel = this.resolveErrorChannel(t);
            sent = false;
            if (errorChannel != null) {
                try {
                    this.getMessagingTemplate().send(errorChannel, (Message)this.getErrorMessageStrategy().buildErrorMessage(t, null));
                    sent = true;
                }
                catch (Throwable errorDeliveryError) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)"Error message was not delivered.", errorDeliveryError);
                    }
                    if (!(errorDeliveryError instanceof Error)) break block7;
                    throw (Error)errorDeliveryError;
                }
            }
        }
        if (!sent && this.logger.isErrorEnabled()) {
            Message failedMessage;
            Message message = failedMessage = t instanceof MessagingException ? ((MessagingException)t).getFailedMessage() : null;
            if (failedMessage != null) {
                this.logger.error((Object)("failure occurred in messaging task with message: " + failedMessage), t);
            } else {
                this.logger.error((Object)"failure occurred in messaging task", t);
            }
        }
    }

    private MessageChannel resolveErrorChannel(Throwable t) {
        Message failedMessage;
        Throwable actualThrowable = t;
        if (t instanceof MessagingExceptionWrapper) {
            actualThrowable = t.getCause();
        }
        Message message = failedMessage = actualThrowable instanceof MessagingException ? ((MessagingException)actualThrowable).getFailedMessage() : null;
        if (this.getDefaultErrorChannel() == null && this.getChannelResolver() != null) {
            this.setChannel((MessageChannel)this.getChannelResolver().resolveDestination("errorChannel"));
        }
        if (failedMessage == null || failedMessage.getHeaders().getErrorChannel() == null) {
            return this.getDefaultErrorChannel();
        }
        Object errorChannelHeader = failedMessage.getHeaders().getErrorChannel();
        if (errorChannelHeader instanceof MessageChannel) {
            return (MessageChannel)errorChannelHeader;
        }
        Assert.isInstanceOf(String.class, (Object)errorChannelHeader, (String)("Unsupported error channel header type. Expected MessageChannel or String, but actual type is [" + errorChannelHeader.getClass() + "]"));
        return (MessageChannel)this.getChannelResolver().resolveDestination((String)errorChannelHeader);
    }
}

