/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aop;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.integration.aop.PublisherAnnotationAdvisor;
import org.springframework.util.ClassUtils;

public class PublisherAnnotationBeanPostProcessor
extends ProxyConfig
implements BeanPostProcessor,
BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean,
Ordered {
    private volatile String defaultChannelName;
    private volatile PublisherAnnotationAdvisor advisor;
    private volatile int order = Integer.MAX_VALUE;
    private volatile BeanFactory beanFactory;
    private volatile ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private final Set<Class<?>> nonApplicableCache = Collections.newSetFromMap(new ConcurrentHashMap(256));

    public void setDefaultChannelName(String defaultChannelName) {
        this.defaultChannelName = defaultChannelName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void afterPropertiesSet() {
        this.advisor = new PublisherAnnotationAdvisor();
        this.advisor.setBeanFactory(this.beanFactory);
        this.advisor.setDefaultChannelName(this.defaultChannelName);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (this.nonApplicableCache.contains(targetClass)) {
            return bean;
        }
        if (AopUtils.canApply((Advisor)this.advisor, (Class)targetClass)) {
            if (bean instanceof Advised) {
                ((Advised)bean).addAdvisor((Advisor)this.advisor);
                return bean;
            }
            ProxyFactory proxyFactory = new ProxyFactory(bean);
            proxyFactory.copyFrom((ProxyConfig)this);
            proxyFactory.addAdvisor((Advisor)this.advisor);
            return proxyFactory.getProxy(this.beanClassLoader);
        }
        this.nonApplicableCache.add(targetClass);
        return bean;
    }
}

