/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.Lifecycle;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.MethodFilter;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.annotation.Payloads;
import org.springframework.integration.annotation.ServiceActivator;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.integration.util.AnnotatedMethodFilter;
import org.springframework.integration.util.ClassUtils;
import org.springframework.integration.util.FixedMethodFilter;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.integration.util.UniqueMethodFilter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class MessagingMethodInvokerHelper<T>
extends AbstractExpressionEvaluator
implements Lifecycle {
    private static final String CANDIDATE_METHODS = "CANDIDATE_METHODS";
    private static final String CANDIDATE_MESSAGE_METHODS = "CANDIDATE_MESSAGE_METHODS";
    private static final Log logger = LogFactory.getLog(MessagingMethodInvokerHelper.class);
    private final Object targetObject;
    private volatile String displayString;
    private volatile boolean requiresReply;
    private final Map<Class<?>, HandlerMethod> handlerMethods;
    private final Map<Class<?>, HandlerMethod> handlerMessageMethods;
    private final LinkedList<Map<Class<?>, HandlerMethod>> handlerMethodsList;
    private final HandlerMethod handlerMethod;
    private final Class<?> expectedType;
    private final boolean canProcessMessageList;
    private Class<? extends Annotation> annotationType;
    private volatile boolean initialized;
    private String methodName;
    private Method method;

    public MessagingMethodInvokerHelper(Object targetObject, Method method, Class<?> expectedType, boolean canProcessMessageList) {
        this(targetObject, null, method, expectedType, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, Method method, boolean canProcessMessageList) {
        this(targetObject, method, null, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, String methodName, Class<?> expectedType, boolean canProcessMessageList) {
        this(targetObject, null, methodName, expectedType, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, String methodName, boolean canProcessMessageList) {
        this(targetObject, methodName, null, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, boolean canProcessMessageList) {
        this(targetObject, annotationType, null, canProcessMessageList);
    }

    public MessagingMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, Class<?> expectedType, boolean canProcessMessageList) {
        this(targetObject, annotationType, (String)null, expectedType, canProcessMessageList);
    }

    public T process(Message<?> message) throws Exception {
        ParametersWrapper parameters = new ParametersWrapper(message);
        return this.processInternal(parameters);
    }

    public T process(Collection<Message<?>> messages, Map<String, ?> headers) throws Exception {
        ParametersWrapper parameters = new ParametersWrapper(messages, headers);
        return this.processInternal(parameters);
    }

    public String toString() {
        return this.displayString;
    }

    public void start() {
        if (this.targetObject instanceof Lifecycle) {
            ((Lifecycle)this.targetObject).start();
        }
    }

    public void stop() {
        if (this.targetObject instanceof Lifecycle) {
            ((Lifecycle)this.targetObject).stop();
        }
    }

    public boolean isRunning() {
        return !(this.targetObject instanceof Lifecycle) || ((Lifecycle)this.targetObject).isRunning();
    }

    private MessagingMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, Method method, Class<?> expectedType, boolean canProcessMessageList) {
        this.canProcessMessageList = canProcessMessageList;
        Assert.notNull((Object)method, (String)"method must not be null");
        this.method = method;
        this.expectedType = expectedType;
        boolean bl = this.requiresReply = expectedType != null;
        if (expectedType != null) {
            Assert.isTrue((method.getReturnType() != Void.class && method.getReturnType() != Void.TYPE ? 1 : 0) != 0, (String)"method must have a return type");
        }
        Assert.notNull((Object)targetObject, (String)"targetObject must not be null");
        this.targetObject = targetObject;
        try {
            this.handlerMethod = new HandlerMethod(method, canProcessMessageList);
        }
        catch (IneligibleMethodException e) {
            throw new IllegalArgumentException(e);
        }
        this.handlerMethods = null;
        this.handlerMessageMethods = null;
        this.handlerMethodsList = null;
        this.setDisplayString(targetObject, method);
    }

    private MessagingMethodInvokerHelper(Object targetObject, Class<? extends Annotation> annotationType, String methodName, Class<?> expectedType, boolean canProcessMessageList) {
        this.annotationType = annotationType;
        this.methodName = methodName;
        this.canProcessMessageList = canProcessMessageList;
        Assert.notNull((Object)targetObject, (String)"targetObject must not be null");
        this.expectedType = expectedType;
        this.targetObject = targetObject;
        this.requiresReply = expectedType != null;
        Map<String, Map<Class<?>, HandlerMethod>> handlerMethodsForTarget = this.findHandlerMethodsForTarget(targetObject, annotationType, methodName, this.requiresReply);
        Map<Class<?>, HandlerMethod> handlerMethods = handlerMethodsForTarget.get(CANDIDATE_METHODS);
        Map<Class<?>, HandlerMethod> handlerMessageMethods = handlerMethodsForTarget.get(CANDIDATE_MESSAGE_METHODS);
        if (handlerMethods.size() == 1 && handlerMessageMethods.isEmpty() || handlerMessageMethods.size() == 1 && handlerMethods.isEmpty()) {
            this.handlerMethod = handlerMethods.size() == 1 ? handlerMethods.values().iterator().next() : handlerMessageMethods.values().iterator().next();
            this.handlerMethods = null;
            this.handlerMessageMethods = null;
            this.handlerMethodsList = null;
        } else {
            this.handlerMethod = null;
            this.handlerMethods = handlerMethods;
            this.handlerMessageMethods = handlerMessageMethods;
            this.handlerMethodsList = new LinkedList();
            this.handlerMethodsList.add(this.handlerMethods);
            this.handlerMethodsList.add(this.handlerMessageMethods);
        }
        this.setDisplayString(targetObject, methodName);
    }

    private void setDisplayString(Object targetObject, Object targetMethod) {
        StringBuilder sb = new StringBuilder(targetObject.getClass().getName());
        if (targetMethod instanceof Method) {
            sb.append("." + ((Method)targetMethod).getName());
        } else if (targetMethod instanceof String) {
            sb.append("." + targetMethod);
        }
        this.displayString = sb.toString() + "]";
    }

    private void prepareEvaluationContext() throws Exception {
        StandardEvaluationContext context = this.getEvaluationContext(false);
        Class targetType = AopUtils.getTargetClass((Object)this.targetObject);
        if (this.method != null) {
            context.registerMethodFilter(targetType, (MethodFilter)new FixedMethodFilter(this.method));
            if (this.expectedType != null) {
                Assert.state((boolean)context.getTypeConverter().canConvert(TypeDescriptor.valueOf(this.method.getReturnType()), TypeDescriptor.valueOf(this.expectedType)), (String)("Cannot convert to expected type (" + this.expectedType + ") from " + this.method));
            }
        } else {
            AnnotatedMethodFilter filter = new AnnotatedMethodFilter(this.annotationType, this.methodName, this.requiresReply);
            Assert.state((boolean)this.canReturnExpectedType(filter, targetType, context.getTypeConverter()), (String)("Cannot convert to expected type (" + this.expectedType + ") from " + this.method));
            context.registerMethodFilter(targetType, (MethodFilter)filter);
        }
        context.setVariable("target", this.targetObject);
        context.registerFunction("requiredHeader", ParametersWrapper.class.getDeclaredMethod("getHeader", Map.class, String.class));
    }

    private boolean canReturnExpectedType(AnnotatedMethodFilter filter, Class<?> targetType, TypeConverter typeConverter) {
        if (this.expectedType == null) {
            return true;
        }
        List<Method> methods = filter.filter(Arrays.asList(ReflectionUtils.getAllDeclaredMethods(targetType)));
        for (Method method : methods) {
            if (!typeConverter.canConvert(TypeDescriptor.valueOf(method.getReturnType()), TypeDescriptor.valueOf(this.expectedType))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T processInternal(ParametersWrapper parameters) throws Exception {
        if (!this.initialized) {
            MessagingMethodInvokerHelper messagingMethodInvokerHelper = this;
            synchronized (messagingMethodInvokerHelper) {
                if (!this.initialized) {
                    this.prepareEvaluationContext();
                    this.initialized = true;
                }
            }
        }
        HandlerMethod candidate = this.findHandlerMethodForParameters(parameters);
        Assert.notNull((Object)candidate, (String)"No candidate methods found for messages.");
        Expression expression = candidate.getExpression();
        Class<?> expectedType = this.expectedType != null ? this.expectedType : candidate.method.getReturnType();
        try {
            Object result = this.evaluateExpression(expression, (Object)parameters, expectedType);
            if (this.requiresReply) {
                Assert.notNull(result, (String)"Expression evaluation result was null, but this processor requires a reply.");
            }
            return (T)result;
        }
        catch (Exception e) {
            Throwable evaluationException = e;
            if ((e instanceof EvaluationException || e instanceof MessageHandlingException) && e.getCause() != null) {
                evaluationException = e.getCause();
            }
            if (evaluationException instanceof Exception) {
                throw evaluationException;
            }
            throw new IllegalStateException("Cannot process message", evaluationException);
        }
    }

    private Map<String, Map<Class<?>, HandlerMethod>> findHandlerMethodsForTarget(Object targetObject, final Class<? extends Annotation> annotationType, final String methodName, final boolean requiresReply) {
        HashMap handlerMethods = new HashMap();
        final HashMap candidateMethods = new HashMap();
        final HashMap candidateMessageMethods = new HashMap();
        final HashMap fallbackMethods = new HashMap();
        final HashMap fallbackMessageMethods = new HashMap();
        final AtomicReference ambiguousFallbackType = new AtomicReference();
        final AtomicReference ambiguousFallbackMessageGenericType = new AtomicReference();
        Class<?> targetClass = this.getTargetClass(targetObject);
        UniqueMethodFilter methodFilter = new UniqueMethodFilter(targetClass);
        ReflectionUtils.doWithMethods(targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                boolean matchesAnnotation = false;
                if (method.isBridge()) {
                    return;
                }
                if (MessagingMethodInvokerHelper.isMethodDefinedOnObjectClass(method)) {
                    return;
                }
                if (method.getDeclaringClass().equals(Proxy.class)) {
                    return;
                }
                if (!Modifier.isPublic(method.getModifiers())) {
                    return;
                }
                if (requiresReply && Void.TYPE.equals(method.getReturnType())) {
                    return;
                }
                if (methodName != null && !methodName.equals(method.getName())) {
                    return;
                }
                if (methodName == null && ObjectUtils.containsElement((Object[])new String[]{"start", "stop", "isRunning"}, (Object)method.getName())) {
                    return;
                }
                if (annotationType != null && AnnotationUtils.findAnnotation((Method)method, (Class)annotationType) != null) {
                    matchesAnnotation = true;
                }
                HandlerMethod handlerMethod = null;
                try {
                    handlerMethod = new HandlerMethod(method, MessagingMethodInvokerHelper.this.canProcessMessageList);
                }
                catch (IneligibleMethodException e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Method [" + method + "] is not eligible for Message handling " + e.getMessage() + "."));
                    }
                    return;
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Method [" + method + "] is not eligible for Message handling."), (Throwable)e);
                    }
                    return;
                }
                Class<?> targetParameterType = handlerMethod.getTargetParameterType();
                if (matchesAnnotation || annotationType == null) {
                    if (handlerMethod.isMessageMethod()) {
                        if (candidateMessageMethods.containsKey(targetParameterType)) {
                            throw new IllegalArgumentException("Found more than one method match for type [Message<" + targetParameterType + ">]");
                        }
                        candidateMessageMethods.put(targetParameterType, handlerMethod);
                    } else {
                        if (candidateMethods.containsKey(targetParameterType)) {
                            String exceptionMessage = "Found more than one method match for ";
                            exceptionMessage = Void.class.equals(targetParameterType) ? exceptionMessage + "empty parameter for 'payload'" : exceptionMessage + "type [" + targetParameterType + "]";
                            throw new IllegalArgumentException(exceptionMessage);
                        }
                        candidateMethods.put(targetParameterType, handlerMethod);
                    }
                } else if (handlerMethod.isMessageMethod()) {
                    if (fallbackMessageMethods.containsKey(targetParameterType)) {
                        ambiguousFallbackMessageGenericType.compareAndSet(null, targetParameterType);
                    }
                    fallbackMessageMethods.put(targetParameterType, handlerMethod);
                } else {
                    if (fallbackMethods.containsKey(targetParameterType)) {
                        ambiguousFallbackType.compareAndSet(null, targetParameterType);
                    }
                    fallbackMethods.put(targetParameterType, handlerMethod);
                }
            }
        }, (ReflectionUtils.MethodFilter)methodFilter);
        if (candidateMethods.isEmpty() && candidateMessageMethods.isEmpty() && fallbackMethods.isEmpty() && fallbackMessageMethods.isEmpty()) {
            this.findSingleSpecifMethodOnInterfacesIfProxy(targetObject, methodName, candidateMessageMethods, candidateMethods);
        }
        if (!candidateMethods.isEmpty() || !candidateMessageMethods.isEmpty()) {
            handlerMethods.put(CANDIDATE_METHODS, candidateMethods);
            handlerMethods.put(CANDIDATE_MESSAGE_METHODS, candidateMessageMethods);
            return handlerMethods;
        }
        if ((ambiguousFallbackType.get() != null || ambiguousFallbackMessageGenericType.get() != null) && ServiceActivator.class.equals(annotationType)) {
            Class[] allInterfaces;
            ArrayList<Method> frameworkMethods = new ArrayList<Method>();
            for (Class iface : allInterfaces = org.springframework.util.ClassUtils.getAllInterfacesForClass(targetClass)) {
                try {
                    if (!"org.springframework.integration.gateway.RequestReplyExchanger".equals(iface.getName())) continue;
                    frameworkMethods.add(targetClass.getMethod("exchange", Message.class));
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)(targetObject.getClass() + ": Ambiguous fallback methods; using RequestReplyExchanger.exchange()"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (frameworkMethods.size() == 1) {
                HandlerMethod handlerMethod = new HandlerMethod((Method)frameworkMethods.get(0), this.canProcessMessageList);
                handlerMethods.put(CANDIDATE_METHODS, Collections.singletonMap(Object.class, handlerMethod));
                handlerMethods.put(CANDIDATE_MESSAGE_METHODS, candidateMessageMethods);
                return handlerMethods;
            }
        }
        try {
            Assert.state((!fallbackMethods.isEmpty() || !fallbackMessageMethods.isEmpty() ? 1 : 0) != 0, (String)("Target object of type [" + this.targetObject.getClass() + "] has no eligible methods for handling Messages."));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        Assert.isNull(ambiguousFallbackType.get(), (String)("Found ambiguous parameter type [" + ambiguousFallbackType + "] for method match: " + fallbackMethods.values()));
        Assert.isNull(ambiguousFallbackMessageGenericType.get(), (String)("Found ambiguous parameter type [" + ambiguousFallbackMessageGenericType + "] for method match: " + fallbackMethods.values()));
        handlerMethods.put(CANDIDATE_METHODS, fallbackMethods);
        handlerMethods.put(CANDIDATE_MESSAGE_METHODS, fallbackMessageMethods);
        return handlerMethods;
    }

    private void findSingleSpecifMethodOnInterfacesIfProxy(final Object targetObject, final String methodName, Map<Class<?>, HandlerMethod> candidateMessageMethods, Map<Class<?>, HandlerMethod> candidateMethods) {
        if (AopUtils.isAopProxy((Object)targetObject)) {
            Class[] interfaces;
            final AtomicReference targetMethod = new AtomicReference();
            for (Class clazz : interfaces = ((Advised)targetObject).getProxiedInterfaces()) {
                ReflectionUtils.doWithMethods((Class)clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                    public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                        if (targetMethod.get() != null) {
                            throw new IllegalStateException("Ambiguous method " + methodName + " on " + targetObject);
                        }
                        targetMethod.set(method);
                    }
                }, (ReflectionUtils.MethodFilter)new ReflectionUtils.MethodFilter(){

                    public boolean matches(Method method) {
                        return method.getName().equals(methodName);
                    }
                });
            }
            Method method = (Method)targetMethod.get();
            if (method != null) {
                HandlerMethod handlerMethod = new HandlerMethod(method, this.canProcessMessageList);
                Class<?> targetParameterType = handlerMethod.getTargetParameterType();
                if (handlerMethod.isMessageMethod()) {
                    if (candidateMessageMethods.containsKey(targetParameterType)) {
                        throw new IllegalArgumentException("Found more than one method match for type [Message<" + targetParameterType + ">]");
                    }
                    candidateMessageMethods.put(targetParameterType, handlerMethod);
                } else {
                    if (candidateMethods.containsKey(targetParameterType)) {
                        String exceptionMessage = "Found more than one method match for ";
                        exceptionMessage = Void.class.equals(targetParameterType) ? exceptionMessage + "empty parameter for 'payload'" : exceptionMessage + "type [" + targetParameterType + "]";
                        throw new IllegalArgumentException(exceptionMessage);
                    }
                    candidateMethods.put(targetParameterType, handlerMethod);
                }
            }
        }
    }

    private Class<?> getTargetClass(Object targetObject) {
        Class superClass;
        Class targetClass = targetObject.getClass();
        if (AopUtils.isAopProxy((Object)targetObject)) {
            targetClass = AopUtils.getTargetClass((Object)targetObject);
            if (targetClass == targetObject.getClass()) {
                try {
                    Class[] interfaces = ((Advised)targetObject).getProxiedInterfaces();
                    if (interfaces != null && interfaces.length == 1) {
                        targetClass = interfaces[0];
                    }
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Exception trying to extract interface", (Throwable)e);
                    }
                }
            }
        } else if (org.springframework.util.ClassUtils.isCglibProxyClass(targetClass) && !Object.class.equals(superClass = targetObject.getClass().getSuperclass())) {
            targetClass = superClass;
        }
        return targetClass;
    }

    private HandlerMethod findHandlerMethodForParameters(ParametersWrapper parameters) {
        if (this.handlerMethod != null) {
            return this.handlerMethod;
        }
        Class<?> payloadType = parameters.getFirstParameterType();
        HandlerMethod closestMatch = this.findClosestMatch(payloadType);
        if (closestMatch != null) {
            return closestMatch;
        }
        if (Iterable.class.isAssignableFrom(payloadType) && this.handlerMethods.containsKey(Iterator.class)) {
            return this.handlerMethods.get(Iterator.class);
        }
        return this.handlerMethods.get(Void.class);
    }

    private HandlerMethod findClosestMatch(Class<?> payloadType) {
        for (Map map : this.handlerMethodsList) {
            Set<Class<?>> candidates = map.keySet();
            Class<?> match = null;
            if (!CollectionUtils.isEmpty(candidates)) {
                match = ClassUtils.findClosestMatch(payloadType, candidates, true);
            }
            if (match == null) continue;
            return (HandlerMethod)map.get(match);
        }
        return null;
    }

    private static boolean isMethodDefinedOnObjectClass(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            return true;
        }
        if (ReflectionUtils.isEqualsMethod((Method)method) || ReflectionUtils.isHashCodeMethod((Method)method) || ReflectionUtils.isToStringMethod((Method)method) || AopUtils.isFinalizeMethod((Method)method)) {
            return true;
        }
        return method.getName().equals("clone") && method.getParameterTypes().length == 0;
    }

    private static final class IneligibleMethodException
    extends RuntimeException {
        private IneligibleMethodException(String message) {
            super(message);
        }
    }

    public static class ParametersWrapper {
        private final Object payload;
        private final Collection<Message<?>> messages;
        private final Map<String, ?> headers;
        private final Message<?> message;

        public ParametersWrapper(Message<?> message) {
            this.message = message;
            this.payload = message.getPayload();
            this.headers = message.getHeaders();
            this.messages = null;
        }

        public ParametersWrapper(Collection<Message<?>> messages, Map<String, ?> headers) {
            this.payload = null;
            this.messages = messages;
            this.headers = headers;
            this.message = null;
        }

        public static Object getHeader(Map<?, ?> headers, String header) {
            Object object = headers.get(header);
            if (object == null) {
                throw new IllegalArgumentException("required header not available: " + header);
            }
            return object;
        }

        public Object getPayload() {
            Assert.state((this.payload != null ? 1 : 0) != 0, (String)"Invalid method parameter for payload: was expecting collection.");
            return this.payload;
        }

        public Collection<Message<?>> getMessages() {
            Assert.state((this.messages != null ? 1 : 0) != 0, (String)"Invalid method parameter for messages: was expecting a single payload.");
            return this.messages;
        }

        public Map<String, ?> getHeaders() {
            return this.headers;
        }

        public Message<?> getMessage() {
            return this.message;
        }

        public Class<?> getFirstParameterType() {
            if (this.payload != null) {
                return this.payload.getClass();
            }
            return this.messages.getClass();
        }
    }

    private static class HandlerMethod {
        private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
        private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new LocalVariableTableParameterNameDiscoverer();
        private static final TypeDescriptor messageTypeDescriptor = TypeDescriptor.valueOf(Message.class);
        private static final TypeDescriptor messageListTypeDescriptor = new TypeDescriptor(ReflectionUtils.findField(HandlerMethod.class, (String)"dummyMessages"));
        private static final TypeDescriptor messageArrayTypeDescriptor = TypeDescriptor.valueOf(Message[].class);
        private static final Collection<Message<?>> dummyMessages = Collections.emptyList();
        private final Method method;
        private final Expression expression;
        private final boolean canProcessMessageList;
        private volatile TypeDescriptor targetParameterTypeDescriptor;
        private volatile Class<?> targetParameterType = Void.class;
        private volatile boolean messageMethod;

        HandlerMethod(Method method, boolean canProcessMessageList) {
            this.method = method;
            this.canProcessMessageList = canProcessMessageList;
            this.expression = this.generateExpression(method);
        }

        Expression getExpression() {
            return this.expression;
        }

        Class<?> getTargetParameterType() {
            return this.targetParameterType;
        }

        private boolean isMessageMethod() {
            return this.messageMethod;
        }

        public String toString() {
            return this.method.toString();
        }

        private Expression generateExpression(Method method) {
            StringBuilder sb = new StringBuilder("#target." + method.getName() + "(");
            Class<?>[] parameterTypes = method.getParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            boolean hasUnqualifiedMapParameter = false;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                MethodParameter methodParameter = new MethodParameter(method, i);
                TypeDescriptor parameterTypeDescriptor = new TypeDescriptor(methodParameter);
                Class parameterType = parameterTypeDescriptor.getObjectType();
                Annotation mappingAnnotation = MessagingAnnotationUtils.findMessagePartAnnotation(parameterAnnotations[i], true);
                if (mappingAnnotation != null) {
                    String qualifierExpression;
                    Class<? extends Annotation> annotationType = mappingAnnotation.annotationType();
                    if (annotationType.equals(org.springframework.integration.annotation.Payload.class) || annotationType.equals(Payload.class)) {
                        sb.append("payload");
                        qualifierExpression = (String)AnnotationUtils.getValue((Annotation)mappingAnnotation);
                        if (StringUtils.hasText((String)qualifierExpression)) {
                            sb.append("." + qualifierExpression);
                        }
                        if (!StringUtils.hasText((String)qualifierExpression)) {
                            this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                        }
                    }
                    if (annotationType.equals(Payloads.class)) {
                        sb.append("messages.![payload");
                        qualifierExpression = ((Payloads)mappingAnnotation).value();
                        if (StringUtils.hasText((String)qualifierExpression)) {
                            sb.append("." + qualifierExpression);
                        }
                        sb.append("]");
                        if (StringUtils.hasText((String)qualifierExpression)) continue;
                        this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                        continue;
                    }
                    if (annotationType.equals(org.springframework.integration.annotation.Headers.class) || annotationType.equals(Headers.class)) {
                        Assert.isTrue((boolean)Map.class.isAssignableFrom(parameterType), (String)"The @Headers annotation can only be applied to a Map-typed parameter.");
                        sb.append("headers");
                        continue;
                    }
                    if (!annotationType.equals(org.springframework.integration.annotation.Header.class) && !annotationType.equals(Header.class)) continue;
                    sb.append(this.determineHeaderExpression(mappingAnnotation, methodParameter));
                    continue;
                }
                if (parameterTypeDescriptor.isAssignableTo(messageTypeDescriptor)) {
                    this.messageMethod = true;
                    sb.append("message");
                    this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                    continue;
                }
                if (this.canProcessMessageList && (parameterTypeDescriptor.isAssignableTo(messageListTypeDescriptor) || parameterTypeDescriptor.isAssignableTo(messageArrayTypeDescriptor))) {
                    sb.append("messages");
                    this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                    continue;
                }
                if (Collection.class.isAssignableFrom(parameterType) || parameterType.isArray()) {
                    if (this.canProcessMessageList) {
                        sb.append("messages.![payload]");
                    } else {
                        sb.append("payload");
                    }
                    this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                    continue;
                }
                if (Iterator.class.isAssignableFrom(parameterType)) {
                    if (this.canProcessMessageList) {
                        Type type = method.getGenericParameterTypes()[i];
                        Type parameterizedType = null;
                        if (type instanceof ParameterizedType && (parameterizedType = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof ParameterizedType) {
                            parameterizedType = ((ParameterizedType)parameterizedType).getRawType();
                        }
                        if (parameterizedType != null && Message.class.isAssignableFrom((Class)parameterizedType)) {
                            sb.append("messages.iterator()");
                        } else {
                            sb.append("messages.![payload].iterator()");
                        }
                    } else {
                        sb.append("payload.iterator()");
                    }
                    this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
                    continue;
                }
                if (Map.class.isAssignableFrom(parameterType)) {
                    if (Properties.class.isAssignableFrom(parameterType)) {
                        sb.append("payload instanceof T(java.util.Map) or (payload instanceof T(String) and payload.contains('=')) ? payload : headers");
                    } else {
                        sb.append("(payload instanceof T(java.util.Map) ? payload : headers)");
                    }
                    Assert.isTrue((!hasUnqualifiedMapParameter ? 1 : 0) != 0, (String)"Found more than one Map typed parameter without any qualification. Consider using @Payload or @Headers on at least one of the parameters.");
                    hasUnqualifiedMapParameter = true;
                    continue;
                }
                sb.append("payload");
                this.setExclusiveTargetParameterType(parameterTypeDescriptor, methodParameter);
            }
            if (hasUnqualifiedMapParameter && this.targetParameterType != null && Map.class.isAssignableFrom(this.targetParameterType)) {
                throw new IllegalArgumentException("Unable to determine payload matching parameter due to ambiguous Map typed parameters. Consider adding the @Payload and or @Headers annotations as appropriate.");
            }
            sb.append(")");
            if (this.targetParameterTypeDescriptor == null) {
                this.targetParameterTypeDescriptor = TypeDescriptor.valueOf(Void.class);
            }
            return EXPRESSION_PARSER.parseExpression(sb.toString());
        }

        private String determineHeaderExpression(Annotation headerAnnotation, MethodParameter methodParameter) {
            methodParameter.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
            String headerName = null;
            String relativeExpression = "";
            AnnotationAttributes annotationAttributes = (AnnotationAttributes)AnnotationUtils.getAnnotationAttributes((Annotation)headerAnnotation);
            String valueAttribute = annotationAttributes.getString("value");
            if (!StringUtils.hasText((String)valueAttribute)) {
                headerName = methodParameter.getParameterName();
            } else if (valueAttribute.indexOf(46) != -1) {
                String[] tokens = valueAttribute.split("\\.", 2);
                headerName = tokens[0];
                if (StringUtils.hasText((String)tokens[1])) {
                    relativeExpression = "." + tokens[1];
                }
            } else {
                headerName = valueAttribute;
            }
            Assert.notNull((Object)headerName, (String)"Cannot determine header name. Possible reasons: -debug is disabled or header name is not explicitly provided via @Header annotation.");
            String headerRetrievalExpression = "headers['" + headerName + "']";
            String fullHeaderExpression = headerRetrievalExpression + relativeExpression;
            if (annotationAttributes.getBoolean("required") && !methodParameter.getParameterType().getName().equals("java.util.Optional")) {
                return "#requiredHeader(headers, '" + headerName + "')" + relativeExpression;
            }
            if (!StringUtils.hasLength((String)relativeExpression)) {
                return headerRetrievalExpression + " ?: null";
            }
            return headerRetrievalExpression + " != null ? " + fullHeaderExpression + " : null";
        }

        private synchronized void setExclusiveTargetParameterType(TypeDescriptor targetParameterType, MethodParameter methodParameter) {
            if (this.targetParameterTypeDescriptor != null) {
                throw new IneligibleMethodException("Found more than one parameter type candidate: [" + this.targetParameterTypeDescriptor + "] and [" + targetParameterType + "]");
            }
            this.targetParameterTypeDescriptor = targetParameterType;
            if (Message.class.isAssignableFrom(targetParameterType.getObjectType())) {
                methodParameter.increaseNestingLevel();
                this.targetParameterType = methodParameter.getNestedParameterType();
                methodParameter.decreaseNestingLevel();
            } else {
                this.targetParameterType = targetParameterType.getObjectType();
            }
        }
    }
}

