/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import org.springframework.integration.context.IntegrationObjectSupport;
import org.springframework.integration.support.AbstractIntegrationMessageBuilder;
import org.springframework.integration.transformer.Transformer;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class HeaderFilter
extends IntegrationObjectSupport
implements Transformer {
    private final String[] headersToRemove;
    private volatile boolean patternMatch = true;

    public HeaderFilter(String ... headersToRemove) {
        Assert.notEmpty((Object[])headersToRemove, (String)"At least one header name to remove is required.");
        this.headersToRemove = headersToRemove;
    }

    public void setPatternMatch(boolean patternMatch) {
        this.patternMatch = patternMatch;
    }

    @Override
    public String getComponentType() {
        return "header-filter";
    }

    @Override
    public Message<?> transform(Message<?> message) {
        AbstractIntegrationMessageBuilder<?> builder = this.getMessageBuilderFactory().fromMessage(message);
        if (this.patternMatch) {
            builder.removeHeaders(this.headersToRemove);
        } else {
            for (String headerToRemove : this.headersToRemove) {
                builder.removeHeader(headerToRemove);
            }
        }
        return builder.build();
    }
}

