/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management.graph;

import org.springframework.integration.support.management.MessageHandlerMetrics;
import org.springframework.integration.support.management.Statistics;
import org.springframework.integration.support.management.graph.EndpointNode;
import org.springframework.integration.support.management.graph.IntegrationNode;
import org.springframework.messaging.MessageHandler;

public class MessageHandlerNode
extends EndpointNode {
    private final String input;

    public MessageHandlerNode(int nodeId, String name, MessageHandler handler, String input, String output) {
        super(nodeId, name, handler, output, handler instanceof MessageHandlerMetrics ? new Stats((MessageHandlerMetrics)handler) : new IntegrationNode.Stats());
        this.input = input;
    }

    public String getInput() {
        return this.input;
    }

    public static final class Stats
    extends IntegrationNode.Stats {
        private final MessageHandlerMetrics handler;

        private Stats(MessageHandlerMetrics handler) {
            this.handler = handler;
        }

        @Override
        protected boolean isAvailable() {
            return this.handler.isCountsEnabled();
        }

        public boolean isLoggingEnabled() {
            return this.handler.isLoggingEnabled();
        }

        public long getHandleCount() {
            return this.handler.getHandleCountLong();
        }

        public long getErrorCount() {
            return this.handler.getErrorCountLong();
        }

        public double getMeanDuration() {
            return this.handler.getMeanDuration();
        }

        public double getMinDuration() {
            return this.handler.getMinDuration();
        }

        public double getMaxDuration() {
            return this.handler.getMaxDuration();
        }

        public double getStandardDeviationDuration() {
            return this.handler.getStandardDeviationDuration();
        }

        public long getActiveCount() {
            return this.handler.getActiveCountLong();
        }

        public Statistics getDuration() {
            return this.handler.getDuration();
        }

        public boolean isStatsEnabled() {
            return this.handler.isStatsEnabled();
        }

        public boolean isCountsEnabled() {
            return this.handler.isCountsEnabled();
        }
    }
}

