/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.support.management.AbstractMessageChannelMetrics;
import org.springframework.integration.support.management.AbstractMessageHandlerMetrics;
import org.springframework.integration.support.management.ConfigurableMetricsAware;
import org.springframework.integration.support.management.DefaultMetricsFactory;
import org.springframework.integration.support.management.IntegrationManagement;
import org.springframework.integration.support.management.MessageChannelMetrics;
import org.springframework.integration.support.management.MessageHandlerMetrics;
import org.springframework.integration.support.management.MessageSourceMetrics;
import org.springframework.integration.support.management.MetricsFactory;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public class IntegrationManagementConfigurer
implements SmartInitializingSingleton,
ApplicationContextAware,
BeanNameAware {
    private static final Log logger = LogFactory.getLog(IntegrationManagementConfigurer.class);
    public static final String MANAGEMENT_CONFIGURER_NAME = "integrationManagementConfigurer";
    private final Map<String, MessageChannelMetrics> channelsByName = new HashMap<String, MessageChannelMetrics>();
    private final Map<String, MessageHandlerMetrics> handlersByName = new HashMap<String, MessageHandlerMetrics>();
    private final Map<String, MessageSourceMetrics> sourcesByName = new HashMap<String, MessageSourceMetrics>();
    private ApplicationContext applicationContext;
    private String beanName;
    private boolean defaultLoggingEnabled = true;
    private Boolean defaultCountsEnabled = false;
    private Boolean defaultStatsEnabled = false;
    private MetricsFactory metricsFactory;
    private String metricsFactoryBeanName;
    private String[] enabledCountsPatterns = new String[0];
    private String[] enabledStatsPatterns = new String[0];

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setMetricsFactory(MetricsFactory metricsFactory) {
        this.metricsFactory = metricsFactory;
    }

    public void setMetricsFactoryBeanName(String metricsFactory) {
        this.metricsFactoryBeanName = metricsFactory;
    }

    public void setEnabledCountsPatterns(String[] enabledCountsPatterns) {
        Assert.notEmpty((Object[])enabledCountsPatterns, (String)"enabledCountsPatterns must not be empty");
        this.enabledCountsPatterns = Arrays.copyOf(enabledCountsPatterns, enabledCountsPatterns.length);
    }

    public void setEnabledStatsPatterns(String[] enabledStatsPatterns) {
        Assert.notEmpty((Object[])enabledStatsPatterns, (String)"enabledStatsPatterns must not be empty");
        this.enabledStatsPatterns = Arrays.copyOf(enabledStatsPatterns, enabledStatsPatterns.length);
    }

    public void setDefaultCountsEnabled(Boolean defaultCountsEnabled) {
        this.defaultCountsEnabled = defaultCountsEnabled;
    }

    public Boolean getDefaultCountsEnabled() {
        return this.defaultCountsEnabled;
    }

    public void setDefaultStatsEnabled(Boolean defaultStatsEnabled) {
        this.defaultStatsEnabled = defaultStatsEnabled;
    }

    public Boolean getDefaultStatsEnabled() {
        return this.defaultStatsEnabled;
    }

    public void setDefaultLoggingEnabled(boolean defaultLoggingEnabled) {
        this.defaultLoggingEnabled = defaultLoggingEnabled;
    }

    public void afterSingletonsInstantiated() {
        Assert.state((this.applicationContext != null ? 1 : 0) != 0, (String)"'applicationContext' must not be null");
        Assert.state((boolean)MANAGEMENT_CONFIGURER_NAME.equals(this.beanName), (String)(this.getClass().getSimpleName() + " bean name must be " + MANAGEMENT_CONFIGURER_NAME));
        if (this.metricsFactory == null && StringUtils.hasText((String)this.metricsFactoryBeanName)) {
            this.metricsFactory = (MetricsFactory)this.applicationContext.getBean(this.metricsFactoryBeanName, MetricsFactory.class);
        }
        if (this.metricsFactory == null) {
            this.metricsFactory = new DefaultMetricsFactory();
        }
        Map managed = this.applicationContext.getBeansOfType(IntegrationManagement.class);
        for (Map.Entry entry : managed.entrySet()) {
            IntegrationManagement bean = (IntegrationManagement)entry.getValue();
            bean.setLoggingEnabled(this.defaultLoggingEnabled);
            if (bean instanceof MessageChannelMetrics) {
                this.configureChannelMetrics((String)entry.getKey(), (MessageChannelMetrics)bean);
                continue;
            }
            if (bean instanceof MessageHandlerMetrics) {
                this.configureHandlerMetrics((String)entry.getKey(), (MessageHandlerMetrics)bean);
                continue;
            }
            if (!(bean instanceof MessageSourceMetrics)) continue;
            this.configureSourceMetrics((String)entry.getKey(), (MessageSourceMetrics)bean);
        }
    }

    private void configureChannelMetrics(String name, MessageChannelMetrics bean) {
        AbstractMessageChannelMetrics metrics = this.metricsFactory.createChannelMetrics(name);
        Assert.state((metrics != null ? 1 : 0) != 0, (String)"'metrics' must not be null");
        Boolean enabled = this.smartMatch(this.enabledCountsPatterns, name);
        if (enabled != null) {
            bean.setCountsEnabled(enabled);
        } else {
            bean.setCountsEnabled(this.defaultCountsEnabled);
        }
        enabled = this.smartMatch(this.enabledStatsPatterns, name);
        if (enabled != null) {
            bean.setStatsEnabled(enabled);
            metrics.setFullStatsEnabled(enabled);
        } else {
            bean.setStatsEnabled(this.defaultStatsEnabled);
            metrics.setFullStatsEnabled(this.defaultStatsEnabled);
        }
        if (bean instanceof ConfigurableMetricsAware) {
            ((ConfigurableMetricsAware)((Object)bean)).configureMetrics(metrics);
        }
        this.channelsByName.put(name, bean);
    }

    private void configureHandlerMetrics(String name, MessageHandlerMetrics bean) {
        AbstractMessageHandlerMetrics metrics = this.metricsFactory.createHandlerMetrics(name);
        Assert.state((metrics != null ? 1 : 0) != 0, (String)"'metrics' must not be null");
        Boolean enabled = this.smartMatch(this.enabledCountsPatterns, name);
        if (enabled != null) {
            bean.setCountsEnabled(enabled);
        } else {
            bean.setCountsEnabled(this.defaultCountsEnabled);
        }
        enabled = this.smartMatch(this.enabledStatsPatterns, name);
        if (enabled != null) {
            bean.setStatsEnabled(enabled);
            metrics.setFullStatsEnabled(enabled);
        } else {
            bean.setStatsEnabled(this.defaultStatsEnabled);
            metrics.setFullStatsEnabled(this.defaultStatsEnabled);
        }
        if (bean instanceof ConfigurableMetricsAware) {
            ((ConfigurableMetricsAware)((Object)bean)).configureMetrics(metrics);
        }
        this.handlersByName.put(bean.getManagedName() != null ? bean.getManagedName() : name, bean);
    }

    private void configureSourceMetrics(String name, MessageSourceMetrics bean) {
        Boolean enabled = this.smartMatch(this.enabledCountsPatterns, name);
        if (enabled != null) {
            bean.setCountsEnabled(enabled);
        } else {
            bean.setCountsEnabled(this.defaultCountsEnabled);
        }
        this.sourcesByName.put(bean.getManagedName() != null ? bean.getManagedName() : name, bean);
    }

    private Boolean smartMatch(String[] patterns, String name) {
        if (patterns != null) {
            for (String pattern : patterns) {
                boolean reverse = false;
                String patternToUse = pattern;
                if (pattern.startsWith("!")) {
                    reverse = true;
                    patternToUse = pattern.substring(1);
                } else if (pattern.startsWith("\\")) {
                    patternToUse = pattern.substring(1);
                }
                if (!PatternMatchUtils.simpleMatch((String)patternToUse, (String)name)) continue;
                return !reverse;
            }
        }
        return null;
    }

    public String[] getChannelNames() {
        return this.channelsByName.keySet().toArray(new String[this.channelsByName.size()]);
    }

    public String[] getHandlerNames() {
        return this.handlersByName.keySet().toArray(new String[this.handlersByName.size()]);
    }

    public String[] getSourceNames() {
        return this.sourcesByName.keySet().toArray(new String[this.sourcesByName.size()]);
    }

    public MessageChannelMetrics getChannelMetrics(String name) {
        if (this.channelsByName.containsKey(name)) {
            return this.channelsByName.get(name);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No channel found for (" + name + ")"));
        }
        return null;
    }

    public MessageHandlerMetrics getHandlerMetrics(String name) {
        if (this.handlersByName.containsKey(name)) {
            return this.handlersByName.get(name);
        }
        if (this.handlersByName.containsKey(name + ".handler")) {
            return this.handlersByName.get(name + ".handler");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No handler found for (" + name + ")"));
        }
        return null;
    }

    public MessageSourceMetrics getSourceMetrics(String name) {
        if (this.sourcesByName.containsKey(name)) {
            return this.sourcesByName.get(name);
        }
        if (this.sourcesByName.containsKey(name + ".source")) {
            return this.sourcesByName.get(name + ".source");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No source found for (" + name + ")"));
        }
        return null;
    }
}

