/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.management;

import org.springframework.integration.support.management.DefaultMessageHandlerMetrics;
import org.springframework.integration.support.management.ExponentialMovingAverage;
import org.springframework.integration.support.management.MetricsContext;

public class AggregatingMessageHandlerMetrics
extends DefaultMessageHandlerMetrics {
    private static final int DEFAULT_SAMPLE_SIZE = 1000;
    private final int sampleSize;
    private long start;

    public AggregatingMessageHandlerMetrics() {
        this(null, 1000);
    }

    public AggregatingMessageHandlerMetrics(String name, int sampleSize) {
        super(name);
        this.sampleSize = sampleSize;
    }

    public AggregatingMessageHandlerMetrics(String name, ExponentialMovingAverage duration, int sampleSize) {
        super(name, duration);
        this.sampleSize = sampleSize;
    }

    @Override
    public synchronized MetricsContext beforeHandle() {
        long count = this.handleCount.getAndIncrement();
        if (this.isFullStatsEnabled() && count % (long)this.sampleSize == 0L) {
            this.start = System.nanoTime();
        }
        this.activeCount.incrementAndGet();
        return new AggregatingHandlerMetricsContext(this.start, count + 1L);
    }

    @Override
    public void afterHandle(MetricsContext context, boolean success) {
        this.activeCount.decrementAndGet();
        AggregatingHandlerMetricsContext aggregatingContext = (AggregatingHandlerMetricsContext)context;
        if (success) {
            if (this.isFullStatsEnabled() && aggregatingContext.newCount % (long)this.sampleSize == 0L) {
                this.duration.append(System.nanoTime() - aggregatingContext.start);
            }
        } else {
            this.errorCount.incrementAndGet();
        }
    }

    protected static class AggregatingHandlerMetricsContext
    extends DefaultMessageHandlerMetrics.DefaultHandlerMetricsContext {
        protected long newCount;

        public AggregatingHandlerMetricsContext(long start, long newCount) {
            super(start);
            this.newCount = newCount;
        }
    }
}

