/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Map;
import org.springframework.integration.support.json.AbstractJacksonJsonObjectMapper;
import org.springframework.util.Assert;

public class Jackson2JsonObjectMapper
extends AbstractJacksonJsonObjectMapper<JsonNode, JsonParser, JavaType> {
    private final ObjectMapper objectMapper;

    public Jackson2JsonObjectMapper() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public Jackson2JsonObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, (String)"objectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    @Override
    public String toJson(Object value) throws Exception {
        return this.objectMapper.writeValueAsString(value);
    }

    @Override
    public void toJson(Object value, Writer writer) throws Exception {
        this.objectMapper.writeValue(writer, value);
    }

    @Override
    public JsonNode toJsonNode(Object value) throws Exception {
        return this.objectMapper.valueToTree(value);
    }

    @Override
    protected <T> T fromJson(Object json, JavaType type) throws Exception {
        if (json instanceof String) {
            return (T)this.objectMapper.readValue((String)json, type);
        }
        if (json instanceof byte[]) {
            return (T)this.objectMapper.readValue((byte[])json, type);
        }
        if (json instanceof File) {
            return (T)this.objectMapper.readValue((File)json, type);
        }
        if (json instanceof URL) {
            return (T)this.objectMapper.readValue((URL)json, type);
        }
        if (json instanceof InputStream) {
            return (T)this.objectMapper.readValue((InputStream)json, type);
        }
        if (json instanceof Reader) {
            return (T)this.objectMapper.readValue((Reader)json, type);
        }
        throw new IllegalArgumentException("'json' argument must be an instance of: " + supportedJsonTypes + " , but gotten: " + json.getClass());
    }

    @Override
    public <T> T fromJson(JsonParser parser, Type valueType) throws Exception {
        return (T)this.objectMapper.readValue(parser, this.constructType(valueType));
    }

    @Override
    protected JavaType extractJavaType(Map<String, Object> javaTypes) throws Exception {
        JavaType classType = (JavaType)this.createJavaType(javaTypes, "json__TypeId__");
        if (!classType.isContainerType() || classType.isArrayType()) {
            return classType;
        }
        JavaType contentClassType = (JavaType)this.createJavaType(javaTypes, "json__ContentTypeId__");
        if (classType.getKeyType() == null) {
            return this.objectMapper.getTypeFactory().constructCollectionType(classType.getRawClass(), contentClassType);
        }
        JavaType keyClassType = (JavaType)this.createJavaType(javaTypes, "json__KeyTypeId__");
        return this.objectMapper.getTypeFactory().constructMapType(classType.getRawClass(), keyClassType, contentClassType);
    }

    @Override
    protected JavaType constructType(Type type) {
        return this.objectMapper.constructType(type);
    }
}

