/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.history;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.integration.support.management.TrackableComponent;
import org.springframework.jmx.export.annotation.ManagedAttribute;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.util.Assert;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

@ManagedResource
@IntegrationManagedResource
public class MessageHistoryConfigurer
implements SmartLifecycle,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile String[] componentNamePatterns = new String[]{"*"};
    private volatile boolean componentNamePatternsExplicitlySet;
    private final Set<String> currentlyTrackedComponentNames = new HashSet<String>();
    private volatile BeanFactory beanFactory;
    private volatile boolean running;
    private volatile boolean autoStartup = true;
    private final int phase = Integer.MIN_VALUE;
    private final Object lifecycleMonitor = new Object();

    public void setComponentNamePatterns(String[] componentNamePatterns) {
        Assert.notEmpty((Object[])componentNamePatterns, (String)"componentNamePatterns must not be empty");
        Assert.state((!this.running ? 1 : 0) != 0, (String)"'componentNamePatterns' cannot be changed without invoking stop() first");
        Object[] trimmedAndSortedComponentNamePatterns = (String[])componentNamePatterns.clone();
        for (int i = 0; i < componentNamePatterns.length; ++i) {
            trimmedAndSortedComponentNamePatterns[i] = ((String)trimmedAndSortedComponentNamePatterns[i]).trim();
        }
        Arrays.sort(trimmedAndSortedComponentNamePatterns);
        Assert.isTrue((!this.componentNamePatternsExplicitlySet || Arrays.equals(this.componentNamePatterns, trimmedAndSortedComponentNamePatterns) ? 1 : 0) != 0, (String)"When more than one message history definition (@EnableMessageHistory or <message-history>) is found in the context, they all must have the same 'componentNamePatterns'");
        this.componentNamePatterns = trimmedAndSortedComponentNamePatterns;
        this.componentNamePatternsExplicitlySet = true;
    }

    @ManagedAttribute(description="comma-delimited list of patterns; must invoke stop() before changing.")
    public void setComponentNamePatternsString(String componentNamePatterns) {
        this.setComponentNamePatterns(StringUtils.delimitedListToStringArray((String)componentNamePatterns, (String)",", (String)" "));
    }

    @ManagedAttribute
    public String getComponentNamePatternsString() {
        return StringUtils.arrayToCommaDelimitedString((Object[])this.componentNamePatterns);
    }

    public void setComponentNamePatternsSet(Set<String> componentNamePatternsSet) {
        Assert.notNull(componentNamePatternsSet, (String)"'componentNamePatternsSet' must not be null");
        Assert.state((!this.running ? 1 : 0) != 0, (String)"'componentNamePatternsSet' cannot be changed without invoking stop() first");
        for (String s : componentNamePatternsSet) {
            Object[] componentNamePatterns = StringUtils.delimitedListToStringArray((String)s, (String)",", (String)" ");
            Arrays.sort(componentNamePatterns);
            if (this.componentNamePatternsExplicitlySet && !Arrays.equals(this.componentNamePatterns, componentNamePatterns)) {
                throw new BeanDefinitionValidationException("When more than one message history definition (@EnableMessageHistory or <message-history>) is found in the context, they all must have the same 'componentNamePatterns'");
            }
            this.componentNamePatterns = componentNamePatterns;
            this.componentNamePatternsExplicitlySet = true;
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    private static Collection<TrackableComponent> getTrackableComponents(ListableBeanFactory beanFactory) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)beanFactory, TrackableComponent.class).values();
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.running && this.beanFactory instanceof ListableBeanFactory) {
                for (TrackableComponent component : MessageHistoryConfigurer.getTrackableComponents((ListableBeanFactory)this.beanFactory)) {
                    String componentName = component.getComponentName();
                    boolean shouldTrack = PatternMatchUtils.simpleMatch((String[])this.componentNamePatterns, (String)componentName);
                    component.setShouldTrack(shouldTrack);
                    if (!shouldTrack) continue;
                    this.currentlyTrackedComponentNames.add(componentName);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info((Object)("Enabling MessageHistory tracking for component '" + componentName + "'"));
                }
                this.running = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running && this.beanFactory instanceof ListableBeanFactory) {
                for (TrackableComponent component : MessageHistoryConfigurer.getTrackableComponents((ListableBeanFactory)this.beanFactory)) {
                    String componentName = component.getComponentName();
                    if (!this.currentlyTrackedComponentNames.contains(componentName)) continue;
                    component.setShouldTrack(false);
                    if (!this.logger.isInfoEnabled()) continue;
                    this.logger.info((Object)("Disabling MessageHistory tracking for component '" + componentName + "'"));
                }
                this.currentlyTrackedComponentNames.clear();
                this.running = false;
                this.componentNamePatternsExplicitlySet = false;
            }
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }
}

