/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.integration.aggregator.MethodInvokingReleaseStrategy;
import org.springframework.integration.aggregator.SequenceSizeReleaseStrategy;
import org.springframework.integration.annotation.ReleaseStrategy;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.util.StringUtils;

public class ReleaseStrategyFactoryBean
implements FactoryBean<org.springframework.integration.aggregator.ReleaseStrategy>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(ReleaseStrategyFactoryBean.class);
    private Object target;
    private String methodName;
    private org.springframework.integration.aggregator.ReleaseStrategy strategy = new SequenceSizeReleaseStrategy();

    public ReleaseStrategyFactoryBean() {
    }

    @Deprecated
    public ReleaseStrategyFactoryBean(Object target) {
        this.target = target;
    }

    @Deprecated
    public ReleaseStrategyFactoryBean(Object target, String methodName) {
        this.target = target;
        this.methodName = methodName;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.target instanceof org.springframework.integration.aggregator.ReleaseStrategy && !StringUtils.hasText((String)this.methodName)) {
            this.strategy = (org.springframework.integration.aggregator.ReleaseStrategy)this.target;
            return;
        }
        if (this.target != null) {
            if (StringUtils.hasText((String)this.methodName)) {
                this.strategy = new MethodInvokingReleaseStrategy(this.target, this.methodName);
            } else {
                Method method = MessagingAnnotationUtils.findAnnotatedMethod(this.target, ReleaseStrategy.class);
                if (method != null) {
                    this.strategy = new MethodInvokingReleaseStrategy(this.target, method);
                } else if (logger.isWarnEnabled()) {
                    logger.warn((Object)("No ReleaseStrategy annotated method found on " + this.target.getClass().getSimpleName() + "; falling back to SequenceSizeReleaseStrategy, target:" + this.target + ", methodName:" + this.methodName));
                }
            }
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)"No target supplied; falling back to SequenceSizeReleaseStrategy");
        }
    }

    public org.springframework.integration.aggregator.ReleaseStrategy getObject() throws Exception {
        return this.strategy;
    }

    public Class<?> getObjectType() {
        return org.springframework.integration.aggregator.ReleaseStrategy.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

