/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.integration.channel.MessagePublishingErrorHandler;
import org.springframework.integration.channel.NullChannel;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.config.ConsumerEndpointFactoryBean;
import org.springframework.integration.context.IntegrationProperties;
import org.springframework.integration.handler.LoggingHandler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

class DefaultConfiguringBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    private static final String ERROR_LOGGER_BEAN_NAME = "_org.springframework.integration.errorLogger";
    private final Log logger = LogFactory.getLog(this.getClass());

    DefaultConfiguringBeanFactoryPostProcessor() {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            this.registerNullChannel(registry);
            if (!beanFactory.containsBean("errorChannel")) {
                this.registerErrorChannel(registry);
            }
            if (!beanFactory.containsBean("taskScheduler")) {
                this.registerTaskScheduler(registry);
            }
            this.registerIdGeneratorConfigurer(registry);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"BeanFactory is not a BeanDefinitionRegistry. The default 'errorChannel' and 'taskScheduler' cannot be configured. Also, any custom IdGenerator implementation configured in this BeanFactory will not be recognized.");
        }
    }

    private void registerInfrastructureBean(BeanDefinitionRegistry registry, String className) {
        String[] definitionNames;
        for (String definitionName : definitionNames = registry.getBeanDefinitionNames()) {
            BeanDefinition definition = registry.getBeanDefinition(definitionName);
            if (!className.equals(definition.getBeanClassName())) continue;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)(className + " is already registered and will be used"));
            }
            return;
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition(className);
        beanDefinition.setRole(2);
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)beanDefinition, (BeanDefinitionRegistry)registry);
    }

    private void registerIdGeneratorConfigurer(BeanDefinitionRegistry registry) {
        this.registerInfrastructureBean(registry, "org.springframework.integration.config.IdGeneratorConfigurer");
    }

    private void registerNullChannel(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition("nullChannel")) {
            BeanDefinition nullChannelDefinition = registry.getBeanDefinition("nullChannel");
            if (NullChannel.class.getName().equals(nullChannelDefinition.getBeanClassName())) {
                return;
            }
            throw new IllegalStateException("The bean name 'nullChannel' is reserved.");
        }
        RootBeanDefinition nullChannelDef = new RootBeanDefinition();
        nullChannelDef.setBeanClassName("org.springframework.integration.channel.NullChannel");
        BeanDefinitionHolder nullChannelHolder = new BeanDefinitionHolder((BeanDefinition)nullChannelDef, "nullChannel");
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)nullChannelHolder, (BeanDefinitionRegistry)registry);
    }

    private void registerErrorChannel(BeanDefinitionRegistry registry) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"No bean named 'errorChannel' has been explicitly defined. Therefore, a default PublishSubscribeChannel will be created.");
        }
        registry.registerBeanDefinition("errorChannel", (BeanDefinition)new RootBeanDefinition(PublishSubscribeChannel.class));
        AbstractBeanDefinition loggingHandler = BeanDefinitionBuilder.genericBeanDefinition(LoggingHandler.class).addConstructorArgValue((Object)"ERROR").getBeanDefinition();
        String errorLoggerBeanName = "_org.springframework.integration.errorLogger.handler";
        registry.registerBeanDefinition(errorLoggerBeanName, (BeanDefinition)loggingHandler);
        BeanDefinitionBuilder loggingEndpointBuilder = BeanDefinitionBuilder.genericBeanDefinition(ConsumerEndpointFactoryBean.class).addPropertyReference("handler", errorLoggerBeanName).addPropertyValue("inputChannelName", (Object)"errorChannel");
        BeanComponentDefinition componentDefinition = new BeanComponentDefinition((BeanDefinition)loggingEndpointBuilder.getBeanDefinition(), ERROR_LOGGER_BEAN_NAME);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)componentDefinition, (BeanDefinitionRegistry)registry);
    }

    private void registerTaskScheduler(BeanDefinitionRegistry registry) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"No bean named 'taskScheduler' has been explicitly defined. Therefore, a default ThreadPoolTaskScheduler will be created.");
        }
        AbstractBeanDefinition scheduler = BeanDefinitionBuilder.genericBeanDefinition(ThreadPoolTaskScheduler.class).addPropertyValue("poolSize", (Object)IntegrationProperties.getExpressionFor("spring.integration.taskScheduler.poolSize")).addPropertyValue("threadNamePrefix", (Object)"task-scheduler-").addPropertyValue("rejectedExecutionHandler", (Object)new ThreadPoolExecutor.CallerRunsPolicy()).addPropertyValue("errorHandler", (Object)new RootBeanDefinition(MessagePublishingErrorHandler.class)).getBeanDefinition();
        registry.registerBeanDefinition("taskScheduler", (BeanDefinition)scheduler);
    }
}

