/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel.interceptor;

import java.util.Arrays;
import java.util.List;
import org.springframework.integration.core.MessageSelector;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.support.ChannelInterceptorAdapter;

public class MessageSelectingInterceptor
extends ChannelInterceptorAdapter {
    private final List<MessageSelector> selectors;

    public MessageSelectingInterceptor(MessageSelector ... selectors) {
        this.selectors = Arrays.asList(selectors);
    }

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        for (MessageSelector selector : this.selectors) {
            if (selector.accept(message)) continue;
            throw new MessageDeliveryException(message, "selector '" + selector + "' did not accept message");
        }
        return message;
    }
}

