/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public class MessagePublishingErrorHandler
implements ErrorHandler,
BeanFactoryAware {
    private final Log logger = LogFactory.getLog(this.getClass());
    private volatile DestinationResolver<MessageChannel> channelResolver;
    private volatile MessageChannel defaultErrorChannel;
    private volatile String defaultErrorChannelName;
    private volatile long sendTimeout = 1000L;

    public MessagePublishingErrorHandler() {
    }

    public MessagePublishingErrorHandler(DestinationResolver<MessageChannel> channelResolver) {
        Assert.notNull(channelResolver, (String)"channelResolver must not be null");
        this.channelResolver = channelResolver;
    }

    public void setDefaultErrorChannel(MessageChannel defaultErrorChannel) {
        this.defaultErrorChannel = defaultErrorChannel;
    }

    public MessageChannel getDefaultErrorChannel() {
        String defaultErrorChannelName = this.defaultErrorChannelName;
        if (defaultErrorChannelName != null && this.channelResolver != null) {
            this.defaultErrorChannel = (MessageChannel)this.channelResolver.resolveDestination(defaultErrorChannelName);
            this.defaultErrorChannelName = null;
        }
        return this.defaultErrorChannel;
    }

    public void setDefaultErrorChannelName(String defaultErrorChannelName) {
        this.defaultErrorChannelName = defaultErrorChannelName;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"beanFactory must not be null");
        if (this.channelResolver == null) {
            this.channelResolver = new BeanFactoryChannelResolver(beanFactory);
        }
    }

    public final void handleError(Throwable t) {
        boolean sent;
        block7: {
            MessageChannel errorChannel = this.resolveErrorChannel(t);
            sent = false;
            if (errorChannel != null) {
                try {
                    sent = this.sendTimeout >= 0L ? errorChannel.send((Message)new ErrorMessage(t), this.sendTimeout) : errorChannel.send((Message)new ErrorMessage(t));
                }
                catch (Throwable errorDeliveryError) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)"Error message was not delivered.", errorDeliveryError);
                    }
                    if (!(errorDeliveryError instanceof Error)) break block7;
                    throw (Error)errorDeliveryError;
                }
            }
        }
        if (!sent && this.logger.isErrorEnabled()) {
            Message failedMessage;
            Message message = failedMessage = t instanceof MessagingException ? ((MessagingException)t).getFailedMessage() : null;
            if (failedMessage != null) {
                this.logger.error((Object)("failure occurred in messaging task with message: " + failedMessage), t);
            } else {
                this.logger.error((Object)"failure occurred in messaging task", t);
            }
        }
    }

    private MessageChannel resolveErrorChannel(Throwable t) {
        Message failedMessage;
        Message message = failedMessage = t instanceof MessagingException ? ((MessagingException)t).getFailedMessage() : null;
        if (this.getDefaultErrorChannel() == null && this.channelResolver != null) {
            this.defaultErrorChannel = (MessageChannel)this.channelResolver.resolveDestination("errorChannel");
        }
        if (failedMessage == null || failedMessage.getHeaders().getErrorChannel() == null) {
            return this.defaultErrorChannel;
        }
        Object errorChannelHeader = failedMessage.getHeaders().getErrorChannel();
        if (errorChannelHeader instanceof MessageChannel) {
            return (MessageChannel)errorChannelHeader;
        }
        Assert.isInstanceOf(String.class, (Object)errorChannelHeader, (String)("Unsupported error channel header type. Expected MessageChannel or String, but actual type is [" + errorChannelHeader.getClass() + "]"));
        return (MessageChannel)this.channelResolver.resolveDestination((String)errorChannelHeader);
    }
}

