/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class IntegrationMessageHeaderAccessor
extends MessageHeaderAccessor {
    public static final String CORRELATION_ID = "correlationId";
    public static final String EXPIRATION_DATE = "expirationDate";
    public static final String PRIORITY = "priority";
    public static final String SEQUENCE_NUMBER = "sequenceNumber";
    public static final String SEQUENCE_SIZE = "sequenceSize";
    public static final String SEQUENCE_DETAILS = "sequenceDetails";
    public static final String ROUTING_SLIP = "routingSlip";
    public static final String DUPLICATE_MESSAGE = "duplicateMessage";
    public static final String CLOSEABLE_RESOURCE = "closableResource";
    private Set<String> readOnlyHeaders = new HashSet<String>();

    public IntegrationMessageHeaderAccessor(Message<?> message) {
        super(message);
    }

    public void setReadOnlyHeaders(String ... readOnlyHeaders) {
        Assert.noNullElements((Object[])readOnlyHeaders, (String)"'readOnlyHeaders' must not be contain null items.");
        if (!ObjectUtils.isEmpty((Object[])readOnlyHeaders)) {
            this.readOnlyHeaders = new HashSet<String>(Arrays.asList(readOnlyHeaders));
        }
    }

    public Long getExpirationDate() {
        return this.getHeader(EXPIRATION_DATE, Long.class);
    }

    public Object getCorrelationId() {
        return this.getHeader(CORRELATION_ID);
    }

    public Integer getSequenceNumber() {
        Integer sequenceNumber = this.getHeader(SEQUENCE_NUMBER, Integer.class);
        return sequenceNumber != null ? sequenceNumber : 0;
    }

    public Integer getSequenceSize() {
        Integer sequenceSize = this.getHeader(SEQUENCE_SIZE, Integer.class);
        return sequenceSize != null ? sequenceSize : 0;
    }

    public Integer getPriority() {
        return this.getHeader(PRIORITY, Integer.class);
    }

    public Closeable getCloseableResource() {
        return this.getHeader(CLOSEABLE_RESOURCE, Closeable.class);
    }

    public <T> T getHeader(String key, Class<T> type) {
        Object value = this.getHeader(key);
        if (value == null) {
            return null;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Incorrect type specified for header '" + key + "'. Expected [" + type + "] but actual type is [" + value.getClass() + "]");
        }
        return (T)value;
    }

    protected void verifyType(String headerName, Object headerValue) {
        if (headerName != null && headerValue != null) {
            super.verifyType(headerName, headerValue);
            if (EXPIRATION_DATE.equals(headerName)) {
                Assert.isTrue((headerValue instanceof Date || headerValue instanceof Long ? 1 : 0) != 0, (String)("The '" + headerName + "' header value must be a Date or Long."));
            } else if (SEQUENCE_NUMBER.equals(headerName) || SEQUENCE_SIZE.equals(headerName) || PRIORITY.equals(headerName)) {
                Assert.isTrue((boolean)Integer.class.isAssignableFrom(headerValue.getClass()), (String)("The '" + headerName + "' header value must be an Integer."));
            } else if (ROUTING_SLIP.equals(headerName)) {
                Assert.isTrue((boolean)Map.class.isAssignableFrom(headerValue.getClass()), (String)("The '" + headerName + "' header value must be a Map."));
            } else if (DUPLICATE_MESSAGE.equals(headerName)) {
                Assert.isTrue((boolean)Boolean.class.isAssignableFrom(headerValue.getClass()), (String)("The '" + headerName + "' header value must be an Boolean."));
            }
        }
    }

    protected boolean isReadOnly(String headerName) {
        return super.isReadOnly(headerName) || this.readOnlyHeaders.contains(headerName);
    }
}

