/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.util;

import org.spockframework.util.IMatcher;

public class Matchers {
    @SafeVarargs
    public static <T> IMatcher<T> and(final IMatcher<? super T> ... matchers) {
        return new IMatcher<T>(){

            @Override
            public boolean matches(T item) {
                for (IMatcher matcher : matchers) {
                    if (matcher.matches(item)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @SafeVarargs
    public static <T> IMatcher<T> or(final IMatcher<? super T> ... matchers) {
        return new IMatcher<T>(){

            @Override
            public boolean matches(T item) {
                for (IMatcher matcher : matchers) {
                    if (!matcher.matches(item)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T> IMatcher<T> not(final IMatcher<T> matcher) {
        return new IMatcher<T>(){

            @Override
            public boolean matches(T item) {
                return !matcher.matches(item);
            }
        };
    }
}

