/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.concurrent.atomic.AtomicBoolean;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.IMethodInvocation;
import org.spockframework.runtime.extension.builtin.PendingFeatureBaseInterceptor;

class PendingFeatureIterationInterceptor
extends PendingFeatureBaseInterceptor
implements IMethodInterceptor {
    public PendingFeatureIterationInterceptor(Class<? extends Throwable>[] expectedExceptions, String reason) {
        super(expectedExceptions, reason);
    }

    @Override
    public void intercept(IMethodInvocation invocation) throws Throwable {
        AtomicBoolean pass = new AtomicBoolean(false);
        invocation.getFeature().getFeatureMethod().addInterceptor(new InnerIterationInterceptor(pass, this.expectedExceptions, this.reason));
        invocation.proceed();
        if (pass.get()) {
            throw this.assumptionViolation();
        }
        throw this.featurePassedUnexpectedly();
    }

    private static class InnerIterationInterceptor
    extends PendingFeatureBaseInterceptor
    implements IMethodInterceptor {
        private final AtomicBoolean pass;

        public InnerIterationInterceptor(AtomicBoolean pass, Class<? extends Throwable>[] expectedExceptions, String reason) {
            super(expectedExceptions, reason);
            this.pass = pass;
        }

        @Override
        public void intercept(IMethodInvocation invocation) throws Throwable {
            try {
                invocation.proceed();
            }
            catch (AssertionError e) {
                this.pass.set(true);
            }
            catch (Throwable e) {
                if (this.isExpected(e)) {
                    this.pass.set(true);
                }
                throw e;
            }
        }
    }
}

