/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.constraint;

import groovy.lang.Closure;
import org.junit.runners.model.MultipleFailureException;
import org.spockframework.mock.IArgumentConstraint;
import org.spockframework.runtime.GroovyRuntimeUtil;

public class CodeArgumentConstraint
implements IArgumentConstraint {
    private final Closure code;

    public CodeArgumentConstraint(Closure code) {
        this.code = code;
    }

    @Override
    public boolean isSatisfiedBy(Object argument) {
        try {
            GroovyRuntimeUtil.invokeClosure(this.code, argument);
            return true;
        }
        catch (AssertionError ignore) {
            return false;
        }
        catch (Exception e) {
            if (e instanceof MultipleFailureException) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public String describeMismatch(Object argument) {
        try {
            GroovyRuntimeUtil.invokeClosure(this.code, argument);
        }
        catch (AssertionError ae) {
            return ((Throwable)((Object)ae)).getMessage();
        }
        catch (Exception e) {
            if (e instanceof MultipleFailureException) {
                return e.getMessage();
            }
            throw e;
        }
        return "<Code argument did not match>";
    }
}

