/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock;

import java.io.IOException;
import java.io.ObjectOutputStream;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockInvocation;
import org.spockframework.mock.InteractionNotSatisfiedError;

public class WrongInvocationOrderError
extends InteractionNotSatisfiedError {
    private static final long serialVersionUID = 1L;
    private final transient IMockInteraction interaction;
    private final transient IMockInvocation lastInvocation;
    private String message;

    public WrongInvocationOrderError(IMockInteraction interaction, IMockInvocation lastInvocation) {
        this.interaction = interaction;
        this.lastInvocation = lastInvocation;
    }

    public IMockInteraction getInteraction() {
        return this.interaction;
    }

    public IMockInvocation getLastInvocation() {
        return this.lastInvocation;
    }

    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Wrong invocation order for:\n\n");
        builder.append(this.interaction);
        builder.append("\n\n");
        builder.append("Last invocation: ");
        builder.append(this.lastInvocation);
        builder.append("\n");
        this.message = builder.toString();
        return this.message;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.getMessage();
        out.defaultWriteObject();
    }
}

