/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Double$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.matching.Regex;
import spire.algebra.AdditiveMonoid;
import spire.algebra.AdditiveSemigroup;
import spire.algebra.Eq;
import spire.algebra.MappedEq;
import spire.algebra.Monoid;
import spire.algebra.MultiplicativeSemigroup;
import spire.algebra.Order;
import spire.algebra.Ring;
import spire.algebra.Semigroup;
import spire.algebra.Semiring;
import spire.math.Above;
import spire.math.Above$;
import spire.math.All;
import spire.math.All$;
import spire.math.Below;
import spire.math.Below$;
import spire.math.Bounded;
import spire.math.Bounded$;
import spire.math.Empty;
import spire.math.Empty$;
import spire.math.Interval;
import spire.math.Point;
import spire.math.Point$;
import spire.math.Rational;
import spire.math.Rational$;
import spire.math.interval.Bound;
import spire.math.interval.Closed;
import spire.math.interval.EmptyBound;
import spire.math.interval.Open;
import spire.math.interval.Unbound;

public final class Interval$
implements Serializable {
    public static Interval$ MODULE$;
    private final Regex NullRe;
    private final Regex SingleRe;
    private final Regex PairRe;

    static {
        new Interval$();
    }

    public <A> Interval<A> withFlags(A lower, A upper, int flags, Order<A> evidence$8) {
        if (evidence$8.lt(lower, upper)) {
            if (Bounded$.MODULE$ == null) {
                throw null;
            }
            return new Bounded<A>(lower, upper, flags, evidence$8);
        }
        if (evidence$8.eqv(lower, upper) && flags == 0) {
            if (Point$.MODULE$ == null) {
                throw null;
            }
            return new Point<A>(lower, evidence$8);
        }
        if (Empty$.MODULE$ == null) {
            throw null;
        }
        return new Empty<A>(evidence$8);
    }

    public <A> Interval<A> empty(Order<A> o) {
        if (Empty$.MODULE$ == null) {
            throw null;
        }
        return new Empty<A>(o);
    }

    public <A> Interval<A> point(A a, Order<A> evidence$9) {
        if (Point$.MODULE$ == null) {
            throw null;
        }
        return new Point<A>(a, evidence$9);
    }

    /*
     * WARNING - void declaration
     */
    public <A> Interval<A> zero(Order<A> o, Semiring<A> r) {
        void apply_value;
        Object a = r.zero();
        if (Point$.MODULE$ == null) {
            throw null;
        }
        return new Point<void>(apply_value, o);
    }

    public <A> Interval<A> all(Order<A> evidence$10) {
        if (All$.MODULE$ == null) {
            throw null;
        }
        return new All<A>(evidence$10);
    }

    /*
     * WARNING - void declaration
     */
    public <A> Interval<A> apply(A lower, A upper, Order<A> evidence$11) {
        int closed_c = evidence$11.compare(lower, upper);
        if (closed_c < 0) {
            void closed_apply_flags;
            boolean bl = false;
            if (Bounded$.MODULE$ == null) {
                throw null;
            }
            return new Bounded<A>(lower, upper, (int)closed_apply_flags, evidence$11);
        }
        if (closed_c == 0) {
            if (Point$.MODULE$ == null) {
                throw null;
            }
            return new Point<A>(lower, evidence$11);
        }
        if (Empty$.MODULE$ == null) {
            throw null;
        }
        return new Empty<A>(evidence$11);
    }

    public Interval<Rational> errorBounds(double d) {
        if (d == Double.POSITIVE_INFINITY) {
            return this.above(Rational$.MODULE$.apply((double)Double.MAX_VALUE), Rational$.MODULE$.RationalAlgebra());
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return this.below(Rational$.MODULE$.apply(Double$.MODULE$.MinValue()), Rational$.MODULE$.RationalAlgebra());
        }
        if (Double.isNaN(d)) {
            return this.empty(Rational$.MODULE$.RationalAlgebra());
        }
        Rational n0 = Rational$.MODULE$.apply(Math.nextAfter(d, -1.0));
        Rational n1 = Rational$.MODULE$.apply(d);
        Rational n2 = Rational$.MODULE$.apply(Math.nextUp(d));
        return this.apply(n1.$minus(n0).$div(Rational$.MODULE$.apply(2)).$plus(n0), n2.$minus(n1).$div(Rational$.MODULE$.apply(2)).$plus(n1), Rational$.MODULE$.RationalAlgebra());
    }

    public final int closedLowerFlags() {
        return 0;
    }

    public final int openLowerFlags() {
        return 1;
    }

    public final int closedUpperFlags() {
        return 0;
    }

    public final int openUpperFlags() {
        return 2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public <A> Interval<A> fromOrderedBounds(Bound<A> lower, Bound<A> upper, Order<A> evidence$12) {
        void var4_15;
        Tuple2 tuple2 = new Tuple2(lower, upper);
        if (lower instanceof EmptyBound && upper instanceof EmptyBound) {
            if (Empty$.MODULE$ == null) {
                throw null;
            }
            Empty<A> empty = new Empty<A>(evidence$12);
            return var4_15;
        }
        if (lower instanceof Closed) {
            Closed closed = (Closed)lower;
            if (upper instanceof Closed) {
                void apply_flags;
                void apply_upper;
                void apply_lower;
                Closed closed2 = (Closed)upper;
                boolean bl = false | false;
                Object a = closed2.a();
                Object a2 = closed.a();
                if (Bounded$.MODULE$ == null) {
                    throw null;
                }
                Bounded<void> bounded = new Bounded<void>(apply_lower, apply_upper, (int)apply_flags, evidence$12);
                return var4_15;
            }
        }
        if (lower instanceof Open) {
            Open open = (Open)lower;
            if (upper instanceof Open) {
                void apply_flags;
                void apply_upper;
                void apply_lower;
                Open open2 = (Open)upper;
                int n = 1 | 2;
                Object a = open2.a();
                Object a3 = open.a();
                if (Bounded$.MODULE$ == null) {
                    throw null;
                }
                Bounded<void> bounded = new Bounded<void>(apply_lower, apply_upper, (int)apply_flags, evidence$12);
                return var4_15;
            }
        }
        if (lower instanceof Unbound && upper instanceof Open) {
            void below_apply_flags;
            Object below_a = ((Open)upper).a();
            int n = 2;
            if (Below$.MODULE$ == null) {
                throw null;
            }
            Below below = new Below(below_a, (int)below_apply_flags, evidence$12);
            return var4_15;
        }
        if (lower instanceof Open) {
            Open open = (Open)lower;
            if (upper instanceof Unbound) {
                void above_apply_flags;
                Object above_a = open.a();
                boolean bl = true;
                if (Above$.MODULE$ == null) {
                    throw null;
                }
                Above above = new Above(above_a, (int)above_apply_flags, evidence$12);
                return var4_15;
            }
        }
        if (lower instanceof Unbound && upper instanceof Closed) {
            void atOrBelow_apply_flags;
            Object atOrBelow_a = ((Closed)upper).a();
            boolean bl = false;
            if (Below$.MODULE$ == null) {
                throw null;
            }
            Below below = new Below(atOrBelow_a, (int)atOrBelow_apply_flags, evidence$12);
            return var4_15;
        }
        if (lower instanceof Closed) {
            Closed closed = (Closed)lower;
            if (upper instanceof Unbound) {
                void atOrAbove_apply_flags;
                Object atOrAbove_a = closed.a();
                boolean bl = false;
                if (Above$.MODULE$ == null) {
                    throw null;
                }
                Above above = new Above(atOrAbove_a, (int)atOrAbove_apply_flags, evidence$12);
                return var4_15;
            }
        }
        if (lower instanceof Closed) {
            Closed closed = (Closed)lower;
            if (upper instanceof Open) {
                void apply_flags;
                void apply_upper;
                void apply_lower;
                Open open = (Open)upper;
                int n = 0 | 2;
                Object a = open.a();
                Object a4 = closed.a();
                if (Bounded$.MODULE$ == null) {
                    throw null;
                }
                Bounded<void> bounded = new Bounded<void>(apply_lower, apply_upper, (int)apply_flags, evidence$12);
                return var4_15;
            }
        }
        if (lower instanceof Open) {
            Open open = (Open)lower;
            if (upper instanceof Closed) {
                void apply_flags;
                void apply_upper;
                void apply_lower;
                Closed closed = (Closed)upper;
                boolean bl = true | false;
                Object a = closed.a();
                Object a5 = open.a();
                if (Bounded$.MODULE$ == null) {
                    throw null;
                }
                Bounded<void> bounded = new Bounded<void>(apply_lower, apply_upper, (int)apply_flags, evidence$12);
                return var4_15;
            }
        }
        if (lower instanceof Unbound && upper instanceof Unbound) {
            if (All$.MODULE$ == null) {
                throw null;
            }
            All<A> all = new All<A>(evidence$12);
            return var4_15;
        }
        boolean bl = lower instanceof EmptyBound ? true : upper instanceof EmptyBound;
        if (!bl) throw new MatchError((Object)tuple2);
        throw new IllegalArgumentException("invalid empty bound");
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public <A> Interval<A> fromBounds(Bound<A> lower, Bound<A> upper, Order<A> evidence$13) {
        void var4_15;
        Tuple2 tuple2 = new Tuple2(lower, upper);
        if (lower instanceof EmptyBound && upper instanceof EmptyBound) {
            if (Empty$.MODULE$ == null) {
                throw null;
            }
            Empty<void> empty = new Empty<void>(evidence$13);
            return var4_15;
        }
        if (lower instanceof Closed) {
            Closed closed = (Closed)lower;
            if (upper instanceof Closed) {
                Interval interval;
                void closed_upper;
                Closed closed2 = (Closed)upper;
                Object a = closed2.a();
                Object closed_lower = closed.a();
                int closed_c = evidence$13.compare((void)closed_lower, closed_upper);
                if (closed_c < 0) {
                    void closed_apply_flags;
                    boolean bl = false;
                    if (Bounded$.MODULE$ == null) {
                        throw null;
                    }
                    interval = new Bounded<void>((void)closed_lower, closed_upper, (int)closed_apply_flags, evidence$13);
                } else if (closed_c == 0) {
                    if (Point$.MODULE$ == null) {
                        throw null;
                    }
                    interval = new Point<void>((void)closed_lower, evidence$13);
                } else {
                    if (Empty$.MODULE$ == null) {
                        throw null;
                    }
                    interval = new Empty<void>(evidence$13);
                }
                Interval interval2 = interval;
                return var4_15;
            }
        }
        if (lower instanceof Open) {
            Open open = (Open)lower;
            if (upper instanceof Open) {
                Interval interval;
                void open_upper;
                Open open2 = (Open)upper;
                Object a = open2.a();
                Object open_lower = open.a();
                if (evidence$13.lt((void)open_lower, open_upper)) {
                    void open_apply_flags;
                    int n = 3;
                    if (Bounded$.MODULE$ == null) {
                        throw null;
                    }
                    interval = new Bounded<void>((void)open_lower, open_upper, (int)open_apply_flags, evidence$13);
                } else {
                    if (Empty$.MODULE$ == null) {
                        throw null;
                    }
                    interval = new Empty<void>(evidence$13);
                }
                Interval interval3 = interval;
                return var4_15;
            }
        }
        if (lower instanceof Unbound && upper instanceof Open) {
            void below_apply_flags;
            Object below_a = ((Open)upper).a();
            int n = 2;
            if (Below$.MODULE$ == null) {
                throw null;
            }
            Below<void> below = new Below<void>((void)below_a, (int)below_apply_flags, evidence$13);
            return var4_15;
        }
        if (lower instanceof Open) {
            Open open = (Open)lower;
            if (upper instanceof Unbound) {
                void above_apply_flags;
                Object above_a = open.a();
                boolean bl = true;
                if (Above$.MODULE$ == null) {
                    throw null;
                }
                Above<void> above = new Above<void>((void)above_a, (int)above_apply_flags, evidence$13);
                return var4_15;
            }
        }
        if (lower instanceof Unbound && upper instanceof Closed) {
            void atOrBelow_apply_flags;
            Object atOrBelow_a = ((Closed)upper).a();
            boolean bl = false;
            if (Below$.MODULE$ == null) {
                throw null;
            }
            Below<void> below = new Below<void>((void)atOrBelow_a, (int)atOrBelow_apply_flags, evidence$13);
            return var4_15;
        }
        if (lower instanceof Closed) {
            Closed closed = (Closed)lower;
            if (upper instanceof Unbound) {
                void atOrAbove_apply_flags;
                Object atOrAbove_a = closed.a();
                boolean bl = false;
                if (Above$.MODULE$ == null) {
                    throw null;
                }
                Above<void> above = new Above<void>((void)atOrAbove_a, (int)atOrAbove_apply_flags, evidence$13);
                return var4_15;
            }
        }
        if (lower instanceof Closed) {
            Closed closed = (Closed)lower;
            if (upper instanceof Open) {
                Interval interval;
                void openUpper_upper;
                Open open = (Open)upper;
                Object a = open.a();
                Object openUpper_lower = closed.a();
                if (evidence$13.lt((void)openUpper_lower, openUpper_upper)) {
                    void openUpper_apply_flags;
                    int n = 2;
                    if (Bounded$.MODULE$ == null) {
                        throw null;
                    }
                    interval = new Bounded<void>((void)openUpper_lower, openUpper_upper, (int)openUpper_apply_flags, evidence$13);
                } else {
                    if (Empty$.MODULE$ == null) {
                        throw null;
                    }
                    interval = new Empty<void>(evidence$13);
                }
                Interval interval4 = interval;
                return var4_15;
            }
        }
        if (lower instanceof Open) {
            Open open = (Open)lower;
            if (upper instanceof Closed) {
                Interval interval;
                void openLower_upper;
                Closed closed = (Closed)upper;
                Object a = closed.a();
                Object openLower_lower = open.a();
                if (evidence$13.lt((void)openLower_lower, openLower_upper)) {
                    void openLower_apply_flags;
                    boolean bl = true;
                    if (Bounded$.MODULE$ == null) {
                        throw null;
                    }
                    interval = new Bounded<void>((void)openLower_lower, openLower_upper, (int)openLower_apply_flags, evidence$13);
                } else {
                    if (Empty$.MODULE$ == null) {
                        throw null;
                    }
                    interval = new Empty<void>(evidence$13);
                }
                Interval interval5 = interval;
                return var4_15;
            }
        }
        if (lower instanceof Unbound && upper instanceof Unbound) {
            if (All$.MODULE$ == null) {
                throw null;
            }
            All<void> all = new All<void>(evidence$13);
            return var4_15;
        }
        boolean bl = lower instanceof EmptyBound ? true : upper instanceof EmptyBound;
        if (!bl) throw new MatchError((Object)tuple2);
        throw new IllegalArgumentException("invalid empty bound");
    }

    /*
     * WARNING - void declaration
     */
    public <A> Interval<A> closed(A lower, A upper, Order<A> evidence$14) {
        int c = evidence$14.compare(lower, upper);
        if (c < 0) {
            void apply_flags;
            boolean bl = false;
            if (Bounded$.MODULE$ == null) {
                throw null;
            }
            return new Bounded<A>(lower, upper, (int)apply_flags, evidence$14);
        }
        if (c == 0) {
            if (Point$.MODULE$ == null) {
                throw null;
            }
            return new Point<A>(lower, evidence$14);
        }
        if (Empty$.MODULE$ == null) {
            throw null;
        }
        return new Empty<A>(evidence$14);
    }

    /*
     * WARNING - void declaration
     */
    public <A> Interval<A> open(A lower, A upper, Order<A> evidence$15) {
        if (evidence$15.lt(lower, upper)) {
            void apply_flags;
            int n = 3;
            if (Bounded$.MODULE$ == null) {
                throw null;
            }
            return new Bounded<A>(lower, upper, (int)apply_flags, evidence$15);
        }
        if (Empty$.MODULE$ == null) {
            throw null;
        }
        return new Empty<A>(evidence$15);
    }

    /*
     * WARNING - void declaration
     */
    public <A> Interval<A> openLower(A lower, A upper, Order<A> evidence$16) {
        if (evidence$16.lt(lower, upper)) {
            void apply_flags;
            boolean bl = true;
            if (Bounded$.MODULE$ == null) {
                throw null;
            }
            return new Bounded<A>(lower, upper, (int)apply_flags, evidence$16);
        }
        if (Empty$.MODULE$ == null) {
            throw null;
        }
        return new Empty<A>(evidence$16);
    }

    /*
     * WARNING - void declaration
     */
    public <A> Interval<A> openUpper(A lower, A upper, Order<A> evidence$17) {
        if (evidence$17.lt(lower, upper)) {
            void apply_flags;
            int n = 2;
            if (Bounded$.MODULE$ == null) {
                throw null;
            }
            return new Bounded<A>(lower, upper, (int)apply_flags, evidence$17);
        }
        if (Empty$.MODULE$ == null) {
            throw null;
        }
        return new Empty<A>(evidence$17);
    }

    /*
     * WARNING - void declaration
     */
    public <A> Interval<A> above(A a, Order<A> evidence$18) {
        void apply_flags;
        boolean bl = true;
        if (Above$.MODULE$ == null) {
            throw null;
        }
        return new Above<A>(a, (int)apply_flags, evidence$18);
    }

    /*
     * WARNING - void declaration
     */
    public <A> Interval<A> below(A a, Order<A> evidence$19) {
        void apply_flags;
        int n = 2;
        if (Below$.MODULE$ == null) {
            throw null;
        }
        return new Below<A>(a, (int)apply_flags, evidence$19);
    }

    /*
     * WARNING - void declaration
     */
    public <A> Interval<A> atOrAbove(A a, Order<A> evidence$20) {
        void apply_flags;
        boolean bl = false;
        if (Above$.MODULE$ == null) {
            throw null;
        }
        return new Above<A>(a, (int)apply_flags, evidence$20);
    }

    /*
     * WARNING - void declaration
     */
    public <A> Interval<A> atOrBelow(A a, Order<A> evidence$21) {
        void apply_flags;
        boolean bl = false;
        if (Below$.MODULE$ == null) {
            throw null;
        }
        return new Below<A>(a, (int)apply_flags, evidence$21);
    }

    private Regex NullRe() {
        return this.NullRe;
    }

    private Regex SingleRe() {
        return this.SingleRe;
    }

    private Regex PairRe() {
        return this.PairRe;
    }

    public Interval<Rational> apply(String s) {
        Interval<Rational> interval;
        Option option = this.NullRe().unapplySeq((CharSequence)s);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(0) == 0) {
            interval = this.empty(Rational$.MODULE$.RationalAlgebra());
        } else {
            Option option2 = this.SingleRe().unapplySeq((CharSequence)s);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String x = (String)((LinearSeqOptimized)option2.get()).apply(0);
                interval = this.point(Rational$.MODULE$.apply(x), Rational$.MODULE$.RationalAlgebra());
            } else {
                Option option3 = this.PairRe().unapplySeq((CharSequence)s);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(4) == 0) {
                    Interval<Rational> interval2;
                    String left = (String)((LinearSeqOptimized)option3.get()).apply(0);
                    String x = (String)((LinearSeqOptimized)option3.get()).apply(1);
                    String y = (String)((LinearSeqOptimized)option3.get()).apply(2);
                    String right = (String)((LinearSeqOptimized)option3.get()).apply(3);
                    if ("(".equals(left) && "-\u221e".equals(x) && "\u221e".equals(y) && ")".equals(right)) {
                        interval2 = this.all(Rational$.MODULE$.RationalAlgebra());
                    } else if ("(".equals(left) && "-\u221e".equals(x) && ")".equals(right)) {
                        interval2 = this.below(Rational$.MODULE$.apply(y), Rational$.MODULE$.RationalAlgebra());
                    } else if ("(".equals(left) && "-\u221e".equals(x) && "]".equals(right)) {
                        interval2 = this.atOrBelow(Rational$.MODULE$.apply(y), Rational$.MODULE$.RationalAlgebra());
                    } else if ("(".equals(left) && "\u221e".equals(y) && ")".equals(right)) {
                        interval2 = this.above(Rational$.MODULE$.apply(x), Rational$.MODULE$.RationalAlgebra());
                    } else if ("[".equals(left) && "\u221e".equals(y) && ")".equals(right)) {
                        interval2 = this.atOrAbove(Rational$.MODULE$.apply(x), Rational$.MODULE$.RationalAlgebra());
                    } else if ("[".equals(left) && "]".equals(right)) {
                        interval2 = this.closed(Rational$.MODULE$.apply(x), Rational$.MODULE$.apply(y), Rational$.MODULE$.RationalAlgebra());
                    } else if ("(".equals(left) && ")".equals(right)) {
                        interval2 = this.open(Rational$.MODULE$.apply(x), Rational$.MODULE$.apply(y), Rational$.MODULE$.RationalAlgebra());
                    } else if ("[".equals(left) && ")".equals(right)) {
                        interval2 = this.openUpper(Rational$.MODULE$.apply(x), Rational$.MODULE$.apply(y), Rational$.MODULE$.RationalAlgebra());
                    } else if ("(".equals(left) && "]".equals(right)) {
                        interval2 = this.openLower(Rational$.MODULE$.apply(x), Rational$.MODULE$.apply(y), Rational$.MODULE$.RationalAlgebra());
                    } else {
                        throw new NumberFormatException("Impossible: " + s);
                    }
                    interval = interval2;
                } else {
                    throw new NumberFormatException("For input string: " + s);
                }
            }
        }
        return interval;
    }

    public <A> Eq<Interval<A>> eq(Eq<A> evidence$22) {
        return new Eq<Interval<A>>(){

            public boolean eqv$mcZ$sp(boolean x, boolean y) {
                return this.eqv(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public boolean eqv$mcB$sp(byte x, byte y) {
                return this.eqv(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public boolean eqv$mcC$sp(char x, char y) {
                return this.eqv(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public boolean eqv$mcD$sp(double x, double y) {
                return this.eqv(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public boolean eqv$mcF$sp(float x, float y) {
                return this.eqv(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public boolean eqv$mcI$sp(int x, int y) {
                return this.eqv(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public boolean eqv$mcJ$sp(long x, long y) {
                return this.eqv(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public boolean eqv$mcS$sp(short x, short y) {
                return this.eqv(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public boolean eqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.eqv(x, y);
            }

            public boolean neqv(Object x, Object y) {
                return !this.eqv(x, y);
            }

            public boolean neqv$mcZ$sp(boolean x, boolean y) {
                return this.neqv(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y));
            }

            public boolean neqv$mcB$sp(byte x, byte y) {
                return this.neqv(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y));
            }

            public boolean neqv$mcC$sp(char x, char y) {
                return this.neqv(BoxesRunTime.boxToCharacter((char)x), BoxesRunTime.boxToCharacter((char)y));
            }

            public boolean neqv$mcD$sp(double x, double y) {
                return this.neqv(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y));
            }

            public boolean neqv$mcF$sp(float x, float y) {
                return this.neqv(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y));
            }

            public boolean neqv$mcI$sp(int x, int y) {
                return this.neqv(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y));
            }

            public boolean neqv$mcJ$sp(long x, long y) {
                return this.neqv(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y));
            }

            public boolean neqv$mcS$sp(short x, short y) {
                return this.neqv(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y));
            }

            public boolean neqv$mcV$sp(BoxedUnit x, BoxedUnit y) {
                return this.neqv(x, y);
            }

            public <B> Eq<B> on(Function1<B, Interval<A>> f) {
                return new MappedEq<B, Interval<A>>(this, f);
            }

            public <B> Eq<B> on$mcZ$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Eq<B> on$mcB$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Eq<B> on$mcC$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Eq<B> on$mcD$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Eq<B> on$mcF$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Eq<B> on$mcI$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Eq<B> on$mcJ$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Eq<B> on$mcS$sp(Function1<B, Object> f) {
                return this.on(f);
            }

            public <B> Eq<B> on$mcV$sp(Function1<B, BoxedUnit> f) {
                return this.on(f);
            }

            public Eq<Object> on$mZc$sp(Function1<Object, Interval<A>> f) {
                return new MappedEq<Object, Interval<A>>(this, f);
            }

            public Eq<Object> on$mZcZ$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Eq<Object> on$mZcB$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Eq<Object> on$mZcC$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Eq<Object> on$mZcD$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Eq<Object> on$mZcF$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Eq<Object> on$mZcI$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Eq<Object> on$mZcJ$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Eq<Object> on$mZcS$sp(Function1<Object, Object> f) {
                return this.on$mZc$sp(f);
            }

            public Eq<Object> on$mZcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mZc$sp(f);
            }

            public Eq<Object> on$mBc$sp(Function1<Object, Interval<A>> f) {
                return new MappedEq<Object, Interval<A>>(this, f);
            }

            public Eq<Object> on$mBcZ$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Eq<Object> on$mBcB$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Eq<Object> on$mBcC$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Eq<Object> on$mBcD$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Eq<Object> on$mBcF$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Eq<Object> on$mBcI$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Eq<Object> on$mBcJ$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Eq<Object> on$mBcS$sp(Function1<Object, Object> f) {
                return this.on$mBc$sp(f);
            }

            public Eq<Object> on$mBcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mBc$sp(f);
            }

            public Eq<Object> on$mCc$sp(Function1<Object, Interval<A>> f) {
                return new MappedEq<Object, Interval<A>>(this, f);
            }

            public Eq<Object> on$mCcZ$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Eq<Object> on$mCcB$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Eq<Object> on$mCcC$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Eq<Object> on$mCcD$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Eq<Object> on$mCcF$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Eq<Object> on$mCcI$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Eq<Object> on$mCcJ$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Eq<Object> on$mCcS$sp(Function1<Object, Object> f) {
                return this.on$mCc$sp(f);
            }

            public Eq<Object> on$mCcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mCc$sp(f);
            }

            public Eq<Object> on$mDc$sp(Function1<Object, Interval<A>> f) {
                return new MappedEq<Object, Interval<A>>(this, f);
            }

            public Eq<Object> on$mDcZ$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Eq<Object> on$mDcB$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Eq<Object> on$mDcC$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Eq<Object> on$mDcD$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Eq<Object> on$mDcF$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Eq<Object> on$mDcI$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Eq<Object> on$mDcJ$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Eq<Object> on$mDcS$sp(Function1<Object, Object> f) {
                return this.on$mDc$sp(f);
            }

            public Eq<Object> on$mDcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mDc$sp(f);
            }

            public Eq<Object> on$mFc$sp(Function1<Object, Interval<A>> f) {
                return new MappedEq<Object, Interval<A>>(this, f);
            }

            public Eq<Object> on$mFcZ$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Eq<Object> on$mFcB$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Eq<Object> on$mFcC$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Eq<Object> on$mFcD$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Eq<Object> on$mFcF$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Eq<Object> on$mFcI$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Eq<Object> on$mFcJ$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Eq<Object> on$mFcS$sp(Function1<Object, Object> f) {
                return this.on$mFc$sp(f);
            }

            public Eq<Object> on$mFcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mFc$sp(f);
            }

            public Eq<Object> on$mIc$sp(Function1<Object, Interval<A>> f) {
                return new MappedEq<Object, Interval<A>>(this, f);
            }

            public Eq<Object> on$mIcZ$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Eq<Object> on$mIcB$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Eq<Object> on$mIcC$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Eq<Object> on$mIcD$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Eq<Object> on$mIcF$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Eq<Object> on$mIcI$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Eq<Object> on$mIcJ$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Eq<Object> on$mIcS$sp(Function1<Object, Object> f) {
                return this.on$mIc$sp(f);
            }

            public Eq<Object> on$mIcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mIc$sp(f);
            }

            public Eq<Object> on$mJc$sp(Function1<Object, Interval<A>> f) {
                return new MappedEq<Object, Interval<A>>(this, f);
            }

            public Eq<Object> on$mJcZ$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Eq<Object> on$mJcB$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Eq<Object> on$mJcC$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Eq<Object> on$mJcD$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Eq<Object> on$mJcF$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Eq<Object> on$mJcI$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Eq<Object> on$mJcJ$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Eq<Object> on$mJcS$sp(Function1<Object, Object> f) {
                return this.on$mJc$sp(f);
            }

            public Eq<Object> on$mJcV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mJc$sp(f);
            }

            public Eq<Object> on$mSc$sp(Function1<Object, Interval<A>> f) {
                return new MappedEq<Object, Interval<A>>(this, f);
            }

            public Eq<Object> on$mScZ$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Eq<Object> on$mScB$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Eq<Object> on$mScC$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Eq<Object> on$mScD$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Eq<Object> on$mScF$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Eq<Object> on$mScI$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Eq<Object> on$mScJ$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Eq<Object> on$mScS$sp(Function1<Object, Object> f) {
                return this.on$mSc$sp(f);
            }

            public Eq<Object> on$mScV$sp(Function1<Object, BoxedUnit> f) {
                return this.on$mSc$sp(f);
            }

            public Eq<BoxedUnit> on$mVc$sp(Function1<BoxedUnit, Interval<A>> f) {
                return new MappedEq<BoxedUnit, Interval<A>>(this, f);
            }

            public Eq<BoxedUnit> on$mVcZ$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Eq<BoxedUnit> on$mVcB$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Eq<BoxedUnit> on$mVcC$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Eq<BoxedUnit> on$mVcD$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Eq<BoxedUnit> on$mVcF$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Eq<BoxedUnit> on$mVcI$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Eq<BoxedUnit> on$mVcJ$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Eq<BoxedUnit> on$mVcS$sp(Function1<BoxedUnit, Object> f) {
                return this.on$mVc$sp(f);
            }

            public Eq<BoxedUnit> on$mVcV$sp(Function1<BoxedUnit, BoxedUnit> f) {
                return this.on$mVc$sp(f);
            }

            public boolean eqv(Interval<A> x, Interval<A> y) {
                Interval<A> interval = x;
                return !(interval != null ? !interval.equals(y) : y != null);
            }
        };
    }

    public <A> Semiring<Interval<A>> semiring(Ring<A> ev, Order<A> o) {
        return new Semiring<Interval<A>>(ev, o){
            private final Ring ev$1;
            private final Order o$1;

            public byte pow$mcB$sp(byte a, int n) {
                return Semiring.pow$mcB$sp$(this, a, n);
            }

            public double pow$mcD$sp(double a, int n) {
                return Semiring.pow$mcD$sp$(this, a, n);
            }

            public float pow$mcF$sp(float a, int n) {
                return Semiring.pow$mcF$sp$(this, a, n);
            }

            public int pow$mcI$sp(int a, int n) {
                return Semiring.pow$mcI$sp$(this, a, n);
            }

            public long pow$mcJ$sp(long a, int n) {
                return Semiring.pow$mcJ$sp$(this, a, n);
            }

            public short pow$mcS$sp(short a, int n) {
                return Semiring.pow$mcS$sp$(this, a, n);
            }

            public Semigroup<Interval<A>> multiplicative() {
                return new Semigroup<A>(this){
                    private final /* synthetic */ MultiplicativeSemigroup $outer;

                    public boolean op$mcZ$sp(boolean x, boolean y) {
                        return BoxesRunTime.unboxToBoolean((Object)this.op(BoxesRunTime.boxToBoolean((boolean)x), BoxesRunTime.boxToBoolean((boolean)y)));
                    }

                    public byte op$mcB$sp(byte x, byte y) {
                        return BoxesRunTime.unboxToByte((Object)this.op(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y)));
                    }

                    public double op$mcD$sp(double x, double y) {
                        return BoxesRunTime.unboxToDouble((Object)this.op(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y)));
                    }

                    public float op$mcF$sp(float x, float y) {
                        return BoxesRunTime.unboxToFloat((Object)this.op(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y)));
                    }

                    public int op$mcI$sp(int x, int y) {
                        return BoxesRunTime.unboxToInt((Object)this.op(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y)));
                    }

                    public long op$mcJ$sp(long x, long y) {
                        return BoxesRunTime.unboxToLong((Object)this.op(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y)));
                    }

                    public short op$mcS$sp(short x, short y) {
                        return BoxesRunTime.unboxToShort((Object)this.op(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y)));
                    }

                    public A combinen(A a, int n) {
                        if (n <= 0) {
                            throw new IllegalArgumentException("Repeated combination for semigroups must have repetitions > 0");
                        }
                        if (n == 1) {
                            return a;
                        }
                        return this.combinenAboveOne(a, n);
                    }

                    public boolean combinen$mcZ$sp(boolean a, int n) {
                        return BoxesRunTime.unboxToBoolean((Object)this.combinen(BoxesRunTime.boxToBoolean((boolean)a), n));
                    }

                    public byte combinen$mcB$sp(byte a, int n) {
                        return BoxesRunTime.unboxToByte((Object)this.combinen(BoxesRunTime.boxToByte((byte)a), n));
                    }

                    public double combinen$mcD$sp(double a, int n) {
                        return BoxesRunTime.unboxToDouble((Object)this.combinen(BoxesRunTime.boxToDouble((double)a), n));
                    }

                    public float combinen$mcF$sp(float a, int n) {
                        return BoxesRunTime.unboxToFloat((Object)this.combinen(BoxesRunTime.boxToFloat((float)a), n));
                    }

                    public int combinen$mcI$sp(int a, int n) {
                        return BoxesRunTime.unboxToInt((Object)this.combinen(BoxesRunTime.boxToInteger((int)a), n));
                    }

                    public long combinen$mcJ$sp(long a, int n) {
                        return BoxesRunTime.unboxToLong((Object)this.combinen(BoxesRunTime.boxToLong((long)a), n));
                    }

                    public short combinen$mcS$sp(short a, int n) {
                        return BoxesRunTime.unboxToShort((Object)this.combinen(BoxesRunTime.boxToShort((short)a), n));
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public A combinenAboveOne(A a, int n) {
                        A a2 = a;
                        int n2 = n - 1;
                        A combinenAboveOne$_combinenAboveOne_loop$1_b = a;
                        void combinenAboveOne$_combinenAboveOne_loop$1_extra;
                        void combinenAboveOne$_combinenAboveOne_loop$1_k;
                        while (combinenAboveOne$_combinenAboveOne_loop$1_k != true) {
                            void combinenAboveOne$_combinenAboveOne_loop$1_x;
                            combinenAboveOne$_combinenAboveOne_loop$1_extra = combinenAboveOne$_combinenAboveOne_loop$1_x = (combinenAboveOne$_combinenAboveOne_loop$1_k & 1) == 1 ? this.op(combinenAboveOne$_combinenAboveOne_loop$1_b, combinenAboveOne$_combinenAboveOne_loop$1_extra) : combinenAboveOne$_combinenAboveOne_loop$1_extra;
                            combinenAboveOne$_combinenAboveOne_loop$1_k >>>= 1;
                            combinenAboveOne$_combinenAboveOne_loop$1_b = this.op(combinenAboveOne$_combinenAboveOne_loop$1_b, combinenAboveOne$_combinenAboveOne_loop$1_b);
                        }
                        return this.op(combinenAboveOne$_combinenAboveOne_loop$1_b, combinenAboveOne$_combinenAboveOne_loop$1_extra);
                    }

                    public boolean combinenAboveOne$mcZ$sp(boolean a, int n) {
                        return BoxesRunTime.unboxToBoolean((Object)this.combinenAboveOne(BoxesRunTime.boxToBoolean((boolean)a), n));
                    }

                    public byte combinenAboveOne$mcB$sp(byte a, int n) {
                        return BoxesRunTime.unboxToByte((Object)this.combinenAboveOne(BoxesRunTime.boxToByte((byte)a), n));
                    }

                    public double combinenAboveOne$mcD$sp(double a, int n) {
                        return BoxesRunTime.unboxToDouble((Object)this.combinenAboveOne(BoxesRunTime.boxToDouble((double)a), n));
                    }

                    public float combinenAboveOne$mcF$sp(float a, int n) {
                        return BoxesRunTime.unboxToFloat((Object)this.combinenAboveOne(BoxesRunTime.boxToFloat((float)a), n));
                    }

                    public int combinenAboveOne$mcI$sp(int a, int n) {
                        return BoxesRunTime.unboxToInt((Object)this.combinenAboveOne(BoxesRunTime.boxToInteger((int)a), n));
                    }

                    public long combinenAboveOne$mcJ$sp(long a, int n) {
                        return BoxesRunTime.unboxToLong((Object)this.combinenAboveOne(BoxesRunTime.boxToLong((long)a), n));
                    }

                    public short combinenAboveOne$mcS$sp(short a, int n) {
                        return BoxesRunTime.unboxToShort((Object)this.combinenAboveOne(BoxesRunTime.boxToShort((short)a), n));
                    }

                    public Option<A> combineOption(TraversableOnce<A> as) {
                        return as.reduceOption((arg_0, arg_1) -> Semigroup.$anonfun$combineOption$1(this, arg_0, arg_1));
                    }

                    public A op(A x, A y) {
                        return this.$outer.times(x, y);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$combineOption$1(spire.algebra.Semigroup java.lang.Object java.lang.Object )}, serializedLambda);
                    }
                };
            }

            public Semigroup<Object> multiplicative$mcB$sp() {
                return this.multiplicative();
            }

            public Semigroup<Object> multiplicative$mcD$sp() {
                return this.multiplicative();
            }

            public Semigroup<Object> multiplicative$mcF$sp() {
                return this.multiplicative();
            }

            public Semigroup<Object> multiplicative$mcI$sp() {
                return this.multiplicative();
            }

            public Semigroup<Object> multiplicative$mcJ$sp() {
                return this.multiplicative();
            }

            public Semigroup<Object> multiplicative$mcS$sp() {
                return this.multiplicative();
            }

            public byte times$mcB$sp(byte x, byte y) {
                return BoxesRunTime.unboxToByte((Object)this.times(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y)));
            }

            public double times$mcD$sp(double x, double y) {
                return BoxesRunTime.unboxToDouble((Object)this.times(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y)));
            }

            public float times$mcF$sp(float x, float y) {
                return BoxesRunTime.unboxToFloat((Object)this.times(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y)));
            }

            public int times$mcI$sp(int x, int y) {
                return BoxesRunTime.unboxToInt((Object)this.times(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y)));
            }

            public long times$mcJ$sp(long x, long y) {
                return BoxesRunTime.unboxToLong((Object)this.times(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y)));
            }

            public short times$mcS$sp(short x, short y) {
                return BoxesRunTime.unboxToShort((Object)this.times(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y)));
            }

            public Object prodn(Object a, int n) {
                if (n <= 0) {
                    throw new IllegalArgumentException("Repeated multiplication for semigroups must have reptitions > 0");
                }
                if (n == 1) {
                    return a;
                }
                return this.prodnAboveOne(a, n);
            }

            public byte prodn$mcB$sp(byte a, int n) {
                return BoxesRunTime.unboxToByte((Object)this.prodn(BoxesRunTime.boxToByte((byte)a), n));
            }

            public double prodn$mcD$sp(double a, int n) {
                return BoxesRunTime.unboxToDouble((Object)this.prodn(BoxesRunTime.boxToDouble((double)a), n));
            }

            public float prodn$mcF$sp(float a, int n) {
                return BoxesRunTime.unboxToFloat((Object)this.prodn(BoxesRunTime.boxToFloat((float)a), n));
            }

            public int prodn$mcI$sp(int a, int n) {
                return BoxesRunTime.unboxToInt((Object)this.prodn(BoxesRunTime.boxToInteger((int)a), n));
            }

            public long prodn$mcJ$sp(long a, int n) {
                return BoxesRunTime.unboxToLong((Object)this.prodn(BoxesRunTime.boxToLong((long)a), n));
            }

            public short prodn$mcS$sp(short a, int n) {
                return BoxesRunTime.unboxToShort((Object)this.prodn(BoxesRunTime.boxToShort((short)a), n));
            }

            /*
             * WARNING - void declaration
             */
            public Object prodnAboveOne(Object a, int n) {
                Object object = a;
                int n2 = n - 1;
                Object prodnAboveOne$_prodnAboveOne_loop$1_b = a;
                void prodnAboveOne$_prodnAboveOne_loop$1_extra;
                void prodnAboveOne$_prodnAboveOne_loop$1_k;
                while (prodnAboveOne$_prodnAboveOne_loop$1_k != true) {
                    void prodnAboveOne$_prodnAboveOne_loop$1_x;
                    prodnAboveOne$_prodnAboveOne_loop$1_extra = prodnAboveOne$_prodnAboveOne_loop$1_x = (prodnAboveOne$_prodnAboveOne_loop$1_k & 1) == 1 ? this.times(prodnAboveOne$_prodnAboveOne_loop$1_b, prodnAboveOne$_prodnAboveOne_loop$1_extra) : prodnAboveOne$_prodnAboveOne_loop$1_extra;
                    prodnAboveOne$_prodnAboveOne_loop$1_k >>>= 1;
                    prodnAboveOne$_prodnAboveOne_loop$1_b = this.times(prodnAboveOne$_prodnAboveOne_loop$1_b, prodnAboveOne$_prodnAboveOne_loop$1_b);
                }
                return this.times(prodnAboveOne$_prodnAboveOne_loop$1_b, prodnAboveOne$_prodnAboveOne_loop$1_extra);
            }

            public byte prodnAboveOne$mcB$sp(byte a, int n) {
                return BoxesRunTime.unboxToByte((Object)this.prodnAboveOne(BoxesRunTime.boxToByte((byte)a), n));
            }

            public double prodnAboveOne$mcD$sp(double a, int n) {
                return BoxesRunTime.unboxToDouble((Object)this.prodnAboveOne(BoxesRunTime.boxToDouble((double)a), n));
            }

            public float prodnAboveOne$mcF$sp(float a, int n) {
                return BoxesRunTime.unboxToFloat((Object)this.prodnAboveOne(BoxesRunTime.boxToFloat((float)a), n));
            }

            public int prodnAboveOne$mcI$sp(int a, int n) {
                return BoxesRunTime.unboxToInt((Object)this.prodnAboveOne(BoxesRunTime.boxToInteger((int)a), n));
            }

            public long prodnAboveOne$mcJ$sp(long a, int n) {
                return BoxesRunTime.unboxToLong((Object)this.prodnAboveOne(BoxesRunTime.boxToLong((long)a), n));
            }

            public short prodnAboveOne$mcS$sp(short a, int n) {
                return BoxesRunTime.unboxToShort((Object)this.prodnAboveOne(BoxesRunTime.boxToShort((short)a), n));
            }

            public Option<Interval<A>> prodOption(TraversableOnce<Interval<A>> as) {
                return as.reduceOption((arg_0, arg_1) -> MultiplicativeSemigroup.$anonfun$prodOption$1(this, arg_0, arg_1));
            }

            public Monoid<Interval<A>> additive() {
                return AdditiveMonoid.additive$(this);
            }

            public Monoid<Object> additive$mcB$sp() {
                return AdditiveMonoid.additive$mcB$sp$(this);
            }

            public Monoid<Object> additive$mcD$sp() {
                return AdditiveMonoid.additive$mcD$sp$(this);
            }

            public Monoid<Object> additive$mcF$sp() {
                return AdditiveMonoid.additive$mcF$sp$(this);
            }

            public Monoid<Object> additive$mcI$sp() {
                return AdditiveMonoid.additive$mcI$sp$(this);
            }

            public Monoid<Object> additive$mcJ$sp() {
                return AdditiveMonoid.additive$mcJ$sp$(this);
            }

            public Monoid<Object> additive$mcS$sp() {
                return AdditiveMonoid.additive$mcS$sp$(this);
            }

            public byte zero$mcB$sp() {
                return AdditiveMonoid.zero$mcB$sp$(this);
            }

            public double zero$mcD$sp() {
                return AdditiveMonoid.zero$mcD$sp$(this);
            }

            public float zero$mcF$sp() {
                return AdditiveMonoid.zero$mcF$sp$(this);
            }

            public int zero$mcI$sp() {
                return AdditiveMonoid.zero$mcI$sp$(this);
            }

            public long zero$mcJ$sp() {
                return AdditiveMonoid.zero$mcJ$sp$(this);
            }

            public short zero$mcS$sp() {
                return AdditiveMonoid.zero$mcS$sp$(this);
            }

            public boolean isZero(Object a, Eq ev) {
                return ev.eqv(a, this.zero());
            }

            public boolean isZero$mcB$sp(byte a, Eq<Object> ev) {
                return this.isZero(BoxesRunTime.boxToByte((byte)a), ev);
            }

            public boolean isZero$mcD$sp(double a, Eq<Object> ev) {
                return this.isZero(BoxesRunTime.boxToDouble((double)a), ev);
            }

            public boolean isZero$mcF$sp(float a, Eq<Object> ev) {
                return this.isZero(BoxesRunTime.boxToFloat((float)a), ev);
            }

            public boolean isZero$mcI$sp(int a, Eq<Object> ev) {
                return this.isZero(BoxesRunTime.boxToInteger((int)a), ev);
            }

            public boolean isZero$mcJ$sp(long a, Eq<Object> ev) {
                return this.isZero(BoxesRunTime.boxToLong((long)a), ev);
            }

            public boolean isZero$mcS$sp(short a, Eq<Object> ev) {
                return this.isZero(BoxesRunTime.boxToShort((short)a), ev);
            }

            public Object sumn(Object a, int n) {
                return AdditiveMonoid.sumn$(this, a, n);
            }

            public byte sumn$mcB$sp(byte a, int n) {
                return AdditiveMonoid.sumn$mcB$sp$(this, a, n);
            }

            public double sumn$mcD$sp(double a, int n) {
                return AdditiveMonoid.sumn$mcD$sp$(this, a, n);
            }

            public float sumn$mcF$sp(float a, int n) {
                return AdditiveMonoid.sumn$mcF$sp$(this, a, n);
            }

            public int sumn$mcI$sp(int a, int n) {
                return AdditiveMonoid.sumn$mcI$sp$(this, a, n);
            }

            public long sumn$mcJ$sp(long a, int n) {
                return AdditiveMonoid.sumn$mcJ$sp$(this, a, n);
            }

            public short sumn$mcS$sp(short a, int n) {
                return AdditiveMonoid.sumn$mcS$sp$(this, a, n);
            }

            public Object sum(TraversableOnce as) {
                return AdditiveMonoid.sum$(this, as);
            }

            public byte sum$mcB$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcB$sp$(this, as);
            }

            public double sum$mcD$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcD$sp$(this, as);
            }

            public float sum$mcF$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcF$sp$(this, as);
            }

            public int sum$mcI$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcI$sp$(this, as);
            }

            public long sum$mcJ$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcJ$sp$(this, as);
            }

            public short sum$mcS$sp(TraversableOnce<Object> as) {
                return AdditiveMonoid.sum$mcS$sp$(this, as);
            }

            public byte plus$mcB$sp(byte x, byte y) {
                return BoxesRunTime.unboxToByte((Object)this.plus(BoxesRunTime.boxToByte((byte)x), BoxesRunTime.boxToByte((byte)y)));
            }

            public double plus$mcD$sp(double x, double y) {
                return BoxesRunTime.unboxToDouble((Object)this.plus(BoxesRunTime.boxToDouble((double)x), BoxesRunTime.boxToDouble((double)y)));
            }

            public float plus$mcF$sp(float x, float y) {
                return BoxesRunTime.unboxToFloat((Object)this.plus(BoxesRunTime.boxToFloat((float)x), BoxesRunTime.boxToFloat((float)y)));
            }

            public int plus$mcI$sp(int x, int y) {
                return BoxesRunTime.unboxToInt((Object)this.plus(BoxesRunTime.boxToInteger((int)x), BoxesRunTime.boxToInteger((int)y)));
            }

            public long plus$mcJ$sp(long x, long y) {
                return BoxesRunTime.unboxToLong((Object)this.plus(BoxesRunTime.boxToLong((long)x), BoxesRunTime.boxToLong((long)y)));
            }

            public short plus$mcS$sp(short x, short y) {
                return BoxesRunTime.unboxToShort((Object)this.plus(BoxesRunTime.boxToShort((short)x), BoxesRunTime.boxToShort((short)y)));
            }

            /*
             * WARNING - void declaration
             */
            public Object sumnAboveOne(Object a, int n) {
                Object object = a;
                int n2 = n - 1;
                Object sumnAboveOne$_sumnAboveOne_loop$1_b = a;
                void sumnAboveOne$_sumnAboveOne_loop$1_extra;
                void sumnAboveOne$_sumnAboveOne_loop$1_k;
                while (sumnAboveOne$_sumnAboveOne_loop$1_k != true) {
                    void sumnAboveOne$_sumnAboveOne_loop$1_x;
                    sumnAboveOne$_sumnAboveOne_loop$1_extra = sumnAboveOne$_sumnAboveOne_loop$1_x = (sumnAboveOne$_sumnAboveOne_loop$1_k & 1) == 1 ? this.plus(sumnAboveOne$_sumnAboveOne_loop$1_b, sumnAboveOne$_sumnAboveOne_loop$1_extra) : sumnAboveOne$_sumnAboveOne_loop$1_extra;
                    sumnAboveOne$_sumnAboveOne_loop$1_k >>>= 1;
                    sumnAboveOne$_sumnAboveOne_loop$1_b = this.plus(sumnAboveOne$_sumnAboveOne_loop$1_b, sumnAboveOne$_sumnAboveOne_loop$1_b);
                }
                return this.plus(sumnAboveOne$_sumnAboveOne_loop$1_b, sumnAboveOne$_sumnAboveOne_loop$1_extra);
            }

            public byte sumnAboveOne$mcB$sp(byte a, int n) {
                return BoxesRunTime.unboxToByte((Object)this.sumnAboveOne(BoxesRunTime.boxToByte((byte)a), n));
            }

            public double sumnAboveOne$mcD$sp(double a, int n) {
                return BoxesRunTime.unboxToDouble((Object)this.sumnAboveOne(BoxesRunTime.boxToDouble((double)a), n));
            }

            public float sumnAboveOne$mcF$sp(float a, int n) {
                return BoxesRunTime.unboxToFloat((Object)this.sumnAboveOne(BoxesRunTime.boxToFloat((float)a), n));
            }

            public int sumnAboveOne$mcI$sp(int a, int n) {
                return BoxesRunTime.unboxToInt((Object)this.sumnAboveOne(BoxesRunTime.boxToInteger((int)a), n));
            }

            public long sumnAboveOne$mcJ$sp(long a, int n) {
                return BoxesRunTime.unboxToLong((Object)this.sumnAboveOne(BoxesRunTime.boxToLong((long)a), n));
            }

            public short sumnAboveOne$mcS$sp(short a, int n) {
                return BoxesRunTime.unboxToShort((Object)this.sumnAboveOne(BoxesRunTime.boxToShort((short)a), n));
            }

            public Option<Interval<A>> sumOption(TraversableOnce<Interval<A>> as) {
                return as.reduceOption((arg_0, arg_1) -> AdditiveSemigroup.$anonfun$sumOption$1(this, arg_0, arg_1));
            }

            public Interval<A> zero() {
                return Interval$.MODULE$.point(this.ev$1.zero(), this.o$1);
            }

            public Interval<A> plus(Interval<A> x, Interval<A> y) {
                return x.$plus(y, (AdditiveSemigroup<Interval<A>>)this.ev$1);
            }

            public Interval<A> times(Interval<A> x, Interval<A> y) {
                return x.$times(y, (Semiring<Interval<A>>)this.ev$1);
            }

            public Interval<A> pow(Interval<A> x, int k) {
                return x.pow(k, this.ev$1);
            }
            {
                this.ev$1 = ev$1;
                this.o$1 = o$1;
                AdditiveMonoid.$init$(this);
                Semiring.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$prodOption$1(spire.algebra.MultiplicativeSemigroup java.lang.Object java.lang.Object ), $anonfun$sumOption$1(spire.algebra.AdditiveSemigroup java.lang.Object java.lang.Object )}, serializedLambda);
            }
        };
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Interval$() {
        MODULE$ = this;
        String string = "^ *\\( *\u00d8 *\\) *$";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.NullRe = new StringOps(string).r();
        String string2 = "^ *\\[ *([^,]+) *\\] *$";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.SingleRe = new StringOps(string2).r();
        String string3 = "^ *(\\[|\\() *(.+?) *, *(.+?) *(\\]|\\)) *$";
        if (Predef$.MODULE$ == null) {
            throw null;
        }
        this.PairRe = new StringOps(string3).r();
    }
}

