/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.api.cvss;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvssMetric {
    private static final Logger log = LoggerFactory.getLogger(CvssMetric.class);
    public static final String UNKNOWN_GROUP = "unknown";
    public static final String BASE_GROUP = "Base";
    public static final String TEMPORAL_GROUP = "Temporal";
    public static final String ENVIRONMENTAL_GROUP = "Environmental";
    private final String code;
    private final String group;
    private final String title;
    private final Map<String, String> meanings;

    public CvssMetric(String code, String group, String title, Map<String, String> meanings) {
        this.code = (String)Preconditions.checkNotNull((Object)code);
        this.group = (String)Preconditions.checkNotNull((Object)group);
        this.title = (String)Preconditions.checkNotNull((Object)title);
        this.meanings = Collections.unmodifiableMap((Map)Preconditions.checkNotNull(meanings));
    }

    public String getCode() {
        return this.code;
    }

    public String getGroup() {
        return this.group;
    }

    public String getTitle() {
        return this.title;
    }

    public Map<String, String> getMeanings() {
        return this.meanings;
    }

    @Nullable
    public String getMeaning(String value) {
        return this.meanings.get(value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("code", (Object)this.code).add("group", (Object)this.group).add("title", (Object)this.title).toString();
    }

    public static class Builder {
        private String code;
        private String group;
        private String title;
        private Map<String, String> meanings = new HashMap<String, String>();

        public Builder from(CvssMetric metric) {
            this.code = metric.code;
            this.group = metric.group;
            this.title = metric.title;
            this.meanings.putAll(metric.meanings);
            return this;
        }

        public Builder code(String code) {
            this.code = code;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder meaning(String code, String value) {
            String prev = this.meanings.put(code, value);
            if (prev != null) {
                log.warn("Replacing metric meaning code: {} with: {}; was: {}", new Object[]{code, value, prev});
            }
            return this;
        }

        public CvssMetric build() {
            return new CvssMetric(this.code, this.group, this.title, this.meanings);
        }
    }
}

