/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.utils;

import java.io.File;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.central.publisher.plugin.utils.MojoUtils;

@Component(role=MojoUtils.class)
public class MojoUtilsImpl
extends AbstractLogEnabled
implements MojoUtils {
    @Override
    public boolean isThisLastProjectWithThisMojoInExecution(MavenSession mavenSession, MojoExecution mojoExecution, String pluginGroupId, String pluginArtifactId, boolean failOnBuildFailure) {
        boolean result = Objects.equals(mojoExecution.getExecutionId(), "default-cli") ? this.isCurrentTheLastProjectInExecution(mavenSession) : this.isCurrentTheLastProjectWithMojoInExecution(mavenSession, pluginGroupId, pluginArtifactId, mojoExecution.getGoal());
        if (result) {
            if (mavenSession.isParallel()) {
                this.waitForOtherProjectsIfNeeded(mavenSession);
            }
            if (mavenSession.getResult().hasExceptions()) {
                if (failOnBuildFailure) {
                    this.getLogger().info("Earlier build failures detected. Central publishing will not continue.");
                    return false;
                }
                this.getLogger().warn("Earlier build failures detected. Central publishing is configured to not detect build failures, continuing...");
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isThisFirstProjectWithThisMojoInExecution(MavenSession mavenSession, MojoExecution mojoExecution, String pluginGroupId, String pluginArtifactId) {
        MavenProject firstProject;
        MavenProject currentProject = mavenSession.getCurrentProject();
        return currentProject == (firstProject = this.getFirstProjectWithThisPluginDefined(mavenSession, pluginGroupId, pluginArtifactId, null));
    }

    @Override
    public File getWorkDirectoryRoot(String relativePath, MavenSession mavenSession, String pluginGroupId, String pluginArtifactId, String goal) {
        MavenProject firstWithThisMojo = this.getFirstProjectWithThisPluginDefined(mavenSession, pluginGroupId, pluginArtifactId, goal);
        if (firstWithThisMojo != null) {
            File firstWithThisMojoBuildDir = firstWithThisMojo.getBuild() != null && firstWithThisMojo.getBuild().getDirectory() != null ? new File(firstWithThisMojo.getBuild().getDirectory()).getAbsoluteFile() : new File(firstWithThisMojo.getBasedir().getAbsoluteFile(), "target");
            return new File(firstWithThisMojoBuildDir, relativePath);
        }
        return FileSystems.getDefault().getPath(mavenSession.getExecutionRootDirectory(), "target", relativePath).toFile();
    }

    private MavenProject getFirstProjectWithThisPluginDefined(MavenSession mavenSession, String pluginGroupId, String pluginArtifactId, String goal) {
        return mavenSession.getProjects().stream().filter(mavenProject -> this.findPlugin((PluginContainer)mavenProject.getBuild(), pluginGroupId, pluginArtifactId, goal) != null).findFirst().orElse(null);
    }

    private boolean isCurrentTheLastProjectInExecution(MavenSession mavenSession) {
        MavenProject lastProject;
        MavenProject currentProject = mavenSession.getCurrentProject();
        return currentProject == (lastProject = (MavenProject)mavenSession.getProjects().get(mavenSession.getProjects().size() - 1));
    }

    private boolean isCurrentTheLastProjectWithMojoInExecution(MavenSession mavenSession, String pluginGroupId, String pluginArtifactId, String goal) {
        return mavenSession.getCurrentProject() == this.getLastProjectWithMojoInExecution(mavenSession, pluginGroupId, pluginArtifactId, goal);
    }

    private MavenProject getLastProjectWithMojoInExecution(MavenSession mavenSession, String pluginGroupId, String pluginArtifactId, String goal) {
        ArrayList projects = new ArrayList(mavenSession.getProjects());
        Collections.reverse(projects);
        return projects.stream().filter(project -> this.findPlugin((PluginContainer)project.getBuild(), pluginGroupId, pluginArtifactId, goal) != null).findFirst().orElse(null);
    }

    private Plugin findPlugin(PluginContainer container, String pluginGroupId, String pluginArtifactId, String goal) {
        if (container != null) {
            return container.getPlugins().stream().filter(plugin -> this.pluginMatches((Plugin)plugin, pluginGroupId, pluginArtifactId, goal)).findFirst().orElse(null);
        }
        return null;
    }

    private boolean pluginMatches(Plugin plugin, String expectedPluginGroupId, String expectedPluginArtifactId, String expectedPluginGoal) {
        if (expectedPluginGroupId.equals(plugin.getGroupId()) && expectedPluginArtifactId.equals(plugin.getArtifactId())) {
            if (expectedPluginGoal != null) {
                return plugin.getExecutions().stream().anyMatch(pluginExecution -> pluginExecution.getGoals().contains(expectedPluginGoal));
            }
            return true;
        }
        return false;
    }

    private void waitForOtherProjectsIfNeeded(MavenSession mavenSession) {
        MavenProject currentProject = mavenSession.getCurrentProject();
        while (true) {
            boolean done = true;
            for (MavenProject project : mavenSession.getProjects()) {
                if (currentProject != project && mavenSession.getResult().getBuildSummary(project) == null) {
                    done = false;
                    break;
                }
                if (currentProject != project) continue;
                break;
            }
            if (done) break;
            this.getLogger().info("Waiting for other projects build to finish...");
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

