/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;

public class DirectoryUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasFiles(File directory) {
        try {
            if (!directory.exists()) return false;
            Path path = directory.toPath();
            if (!Files.exists(path, new LinkOption[0])) return false;
            if (!Files.isDirectory(path, new LinkOption[0])) return false;
            try (Stream<Path> paths = Files.list(path);){
                boolean bl = paths.findFirst().isPresent();
                return bl;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

