/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.utils;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.central.publisher.plugin.model.ArtifactWithFile;
import org.sonatype.central.publisher.plugin.model.ChecksumRequest;
import org.sonatype.central.publisher.plugin.utils.HashAlgorithm;
import org.sonatype.central.publisher.plugin.utils.HashUtils;
import org.sonatype.central.publisher.plugin.utils.ProjectUtils;

@Component(role=ProjectUtils.class)
public class ProjectUtilsImpl
extends AbstractLogEnabled
implements ProjectUtils {
    public static final String MAVEN_METADATA_CENTRAL_STAGING_XML = "maven-metadata-central-staging.xml";
    @Requirement
    private HashUtils hashUtils;

    @Override
    public List<ArtifactWithFile> getArtifacts(MavenProject mavenProject, ArtifactFactory artifactFactory) throws MojoExecutionException {
        ArrayList<ArtifactWithFile> artifactWithFiles = new ArrayList<ArtifactWithFile>();
        if (Objects.equals(mavenProject.getPackaging(), "pom")) {
            artifactWithFiles.addAll(this.getArtifactsFromPomProject(mavenProject));
        } else {
            artifactWithFiles.addAll(this.getArtifactsFromNonPomProject(mavenProject, artifactFactory));
        }
        return artifactWithFiles;
    }

    @Override
    public void deleteGroupArtifactMavenMetadataCentralStagingXml(MavenProject project, Path sourceDir) {
        if (project.getParent() != null) {
            this.deleteGroupArtifactMavenMetadataCentralStagingXml(project.getParent(), sourceDir);
        }
        this.deleteMavenMetadataCentralStagingXml(project, sourceDir);
    }

    @Override
    public void createChecksumFiles(MavenProject project, Path sourceDir, ChecksumRequest checksumRequest) {
        Path path = this.getProjectGroupArtifactVersionPath(project);
        this.getLogger().info("Generate checksums for dir: " + path.toString());
        File gavDirectory = sourceDir.resolve(path).toFile();
        if (!gavDirectory.exists() || !gavDirectory.isDirectory()) {
            return;
        }
        File[] files = gavDirectory.listFiles((dir, name) -> !name.equalsIgnoreCase(MAVEN_METADATA_CENTRAL_STAGING_XML));
        if (files != null) {
            block4: for (File file : files) {
                if (this.hashUtils.isChecksumFile(file) || this.hashUtils.isSignatureFile(file)) continue;
                switch (checksumRequest) {
                    case ALL: {
                        this.hashUtils.createChecksumFile(file, HashAlgorithm.SHA256);
                        this.hashUtils.createChecksumFile(file, HashAlgorithm.SHA512);
                    }
                    case REQUIRED: {
                        this.hashUtils.createChecksumFile(file, HashAlgorithm.MD5);
                        this.hashUtils.createChecksumFile(file, HashAlgorithm.SHA1);
                        continue block4;
                    }
                }
            }
        }
    }

    public Path getProjectGroupPath(MavenProject project) {
        String[] groupPathParts = project.getGroupId().split("\\.");
        Path path = FileSystems.getDefault().getPath("", new String[0]);
        for (String groupPathPart : groupPathParts) {
            path = path.resolve(groupPathPart);
        }
        return path;
    }

    public Path getProjectGroupArtifactPath(MavenProject project) {
        return this.getProjectGroupPath(project).resolve(project.getArtifactId());
    }

    public Path getProjectGroupArtifactVersionPath(MavenProject project) {
        return this.getProjectGroupPath(project).resolve(project.getArtifactId()).resolve(project.getVersion());
    }

    private List<ArtifactWithFile> getArtifactsFromPomProject(MavenProject mavenProject) {
        ArrayList<ArtifactWithFile> artifactWithFiles = new ArrayList<ArtifactWithFile>();
        artifactWithFiles.add(new ArtifactWithFile(mavenProject.getFile(), mavenProject.getArtifact()));
        artifactWithFiles.addAll(this.getAttachedArtifacts(mavenProject));
        return artifactWithFiles;
    }

    private List<ArtifactWithFile> getArtifactsFromNonPomProject(MavenProject mavenProject, ArtifactFactory artifactFactory) throws MojoExecutionException {
        Artifact artifact = mavenProject.getArtifact();
        List attachedArtifacts = mavenProject.getAttachedArtifacts();
        ArrayList<ArtifactWithFile> artifactWithFiles = new ArrayList<ArtifactWithFile>();
        artifact.addMetadata((ArtifactMetadata)new ProjectArtifactMetadata(artifact, mavenProject.getFile()));
        File file = artifact.getFile();
        if (file != null && file.isFile()) {
            artifactWithFiles.add(new ArtifactWithFile(file, artifact));
        } else if (!attachedArtifacts.isEmpty()) {
            this.getLogger().info("No primary artifact to deploy, deploying attached artifacts instead.");
            Artifact pomArtifact = artifactFactory.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
            pomArtifact.setFile(mavenProject.getFile());
            artifactWithFiles.add(new ArtifactWithFile(pomArtifact.getFile(), pomArtifact));
            artifact.setResolvedVersion(pomArtifact.getVersion());
        } else {
            throw new MojoExecutionException("The packaging for this project did not assign a file to the build artifact");
        }
        artifactWithFiles.addAll(this.getAttachedArtifacts(mavenProject));
        return artifactWithFiles;
    }

    private List<ArtifactWithFile> getAttachedArtifacts(MavenProject mavenProject) {
        return mavenProject.getAttachedArtifacts().stream().map(artifact -> new ArtifactWithFile(artifact.getFile(), (Artifact)artifact)).collect(Collectors.toList());
    }

    private void deleteMavenMetadataCentralStagingXml(MavenProject project, Path sourceDir) {
        this.deleteMavenMetadataCentralStagingXml(sourceDir, this.getProjectGroupPath(project));
        this.deleteMavenMetadataCentralStagingXml(sourceDir, this.getProjectGroupArtifactPath(project));
        this.deleteMavenMetadataCentralStagingXml(sourceDir, this.getProjectGroupArtifactVersionPath(project));
    }

    private void deleteMavenMetadataCentralStagingXml(Path sourceDir, Path path) {
        File file = sourceDir.resolve(path).resolve(MAVEN_METADATA_CENTRAL_STAGING_XML).toFile();
        this.getLogger().debug("Pre Bundling - deleting " + file.getPath());
        if (!file.exists()) {
            this.getLogger().debug("Pre Bundling - does not exist " + file.getPath());
            return;
        }
        if (file.delete()) {
            this.getLogger().info(String.format("Pre Bundling - deleted %s", file.getPath()));
        } else {
            this.getLogger().error(String.format("Pre Bundling - failed to delete %s", file.getPath()));
        }
    }
}

