/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.stager;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.central.publisher.plugin.model.ArtifactWithFile;
import org.sonatype.central.publisher.plugin.model.StageArtifactRequest;
import org.sonatype.central.publisher.plugin.stager.ArtifactStager;

@Component(role=ArtifactStager.class)
public class ArtifactStagerImpl
extends AbstractLogEnabled
implements ArtifactStager {
    private static final Object parallelLock = new Object();
    @Requirement
    private ArtifactInstaller artifactInstaller;
    @Requirement
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Requirement
    private ArtifactRepositoryLayout artifactRepositoryLayout;

    @Override
    public void stageArtifact(StageArtifactRequest stageArtifactRequest) throws MojoExecutionException, ArtifactInstallationException {
        if (!stageArtifactRequest.getArtifactWithFiles().isEmpty()) {
            this.getLogger().info("Staging " + stageArtifactRequest.getArtifactWithFiles().size() + " files");
            File stagingDirectory = stageArtifactRequest.getStagingDirectory();
            ArtifactRepository stagingRepository = this.getStagingArtifactRepository(stagingDirectory);
            for (ArtifactWithFile artifactWithFile : stageArtifactRequest.getArtifactWithFiles()) {
                this.install(artifactWithFile.getFile(), artifactWithFile.getArtifact(), stagingRepository);
            }
        } else {
            this.getLogger().info("No files to stage!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void install(File source, Artifact artifact, ArtifactRepository stagingRepository) throws ArtifactInstallationException {
        Object object = parallelLock;
        synchronized (object) {
            this.getLogger().info("Staging " + source.getAbsolutePath());
            this.artifactInstaller.install(source, artifact, stagingRepository);
        }
    }

    protected ArtifactRepository getStagingArtifactRepository(File stagingDirectory) throws MojoExecutionException {
        if (stagingDirectory == null) {
            throw new MojoExecutionException("Staging failed: staging directory is null!");
        }
        try {
            Files.createDirectories(stagingDirectory.toPath(), new FileAttribute[0]);
            String url = stagingDirectory.getCanonicalFile().toURI().toURL().toExternalForm();
            return this.createStagingArtifactRepository(url);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Staging failed: could not create ArtifactRepository in staging directory " + stagingDirectory, (Exception)e);
        }
    }

    protected ArtifactRepository createStagingArtifactRepository(String url) {
        return this.artifactRepositoryFactory.createDeploymentArtifactRepository("central-staging", url, this.artifactRepositoryLayout, true);
    }
}

