/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin.bundler;

import java.io.File;
import java.nio.file.Path;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.central.publisher.client.PublisherClientFactory;
import org.sonatype.central.publisher.client.httpclient.utils.PublisherBundle;
import org.sonatype.central.publisher.plugin.bundler.ArtifactBundler;
import org.sonatype.central.publisher.plugin.model.BundleArtifactRequest;
import org.sonatype.central.publisher.plugin.model.ChecksumRequest;
import org.sonatype.central.publisher.plugin.utils.ProjectUtils;

@Component(role=ArtifactBundler.class)
public class ArtifactBundlerImpl
extends AbstractLogEnabled
implements ArtifactBundler {
    @Requirement
    private ProjectUtils projectUtils;

    @Override
    public Path bundle(BundleArtifactRequest bundleArtifactRequest) {
        File bundleFile = new File(bundleArtifactRequest.getOutputDirectory(), bundleArtifactRequest.getOutputFilename());
        this.getLogger().info("Going to create " + bundleFile.getAbsolutePath() + " by bundling content at " + bundleArtifactRequest.getStagingDirectory().getAbsolutePath());
        Path sourceDir = bundleArtifactRequest.getStagingDirectory().toPath();
        Path destDir = bundleArtifactRequest.getOutputDirectory().toPath();
        PublisherBundle publisherBundle = PublisherClientFactory.createPublisherClient().compose(sourceDir, destDir, bundleArtifactRequest.getOutputFilename());
        this.getLogger().info("Created bundle successfully " + new File(bundleArtifactRequest.getStagingDirectory(), bundleArtifactRequest.getOutputFilename()).getAbsolutePath());
        return publisherBundle.getPath();
    }

    @Override
    public void preBundle(MavenProject project, Path sourceDir, ChecksumRequest checksumRequest) {
        this.projectUtils.deleteGroupArtifactMavenMetadataCentralStagingXml(project, sourceDir);
        this.projectUtils.createChecksumFiles(project, sourceDir, checksumRequest);
    }
}

