/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.central.publisher.plugin;

import java.util.Collection;
import java.util.List;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="org.sonatype.central.publisher.plugin.DeployLifecycleParticipant")
public class DeployLifecycleParticipant
extends AbstractMavenLifecycleParticipant
implements LogEnabled {
    protected Logger logger;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        try {
            this.logger.info("Inspecting build with total of " + session.getProjects().size() + " modules");
            long publishGoalsFoundInModules = this.getCentralPublishingPluginExecutions(session.getProjects());
            if (publishGoalsFoundInModules > 0L) {
                this.logger.info("Not installing Central Publishing features. Preexisting publish related goal bindings found in " + publishGoalsFoundInModules + " modules.");
                return;
            }
            this.logger.info("Installing Central Publishing features");
            for (MavenProject project : session.getProjects()) {
                Plugin centralPublishingPlugin = this.getCentralPublishingPlugin(project.getModel());
                if (centralPublishingPlugin == null) continue;
                this.maybeSkipMavenDeployPlugin(project.getModel(), centralPublishingPlugin);
                this.maybeSkipNexusStagingPlugin(project.getModel(), centralPublishingPlugin);
            }
        }
        catch (IllegalStateException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    private long getCentralPublishingPluginExecutions(List<MavenProject> projects) {
        return projects.stream().map(project -> this.getCentralPublishingPlugin(project.getModel())).filter(this::existsWithExecutions).map(Plugin::getExecutions).flatMap(Collection::stream).map(PluginExecution::getGoals).filter(goal -> goal.contains("publish")).count();
    }

    private boolean existsWithExecutions(Plugin plugin) {
        return plugin != null && !plugin.getExecutions().isEmpty();
    }

    private void maybeSkipMavenDeployPlugin(Model model, Plugin centralPublishingPlugin) {
        Plugin mavenDeployPlugin = this.getMavenDeployPlugin(model);
        if (mavenDeployPlugin != null) {
            mavenDeployPlugin.getExecutions().clear();
            this.setUpCentralPublishingExecution(centralPublishingPlugin);
        }
    }

    private void maybeSkipNexusStagingPlugin(Model model, Plugin centralPublishingPlugin) {
        Plugin nexusStagingPlugin = this.getNexusStagingPlugin(model);
        if (nexusStagingPlugin != null) {
            nexusStagingPlugin.getExecutions().clear();
            this.setUpCentralPublishingExecution(centralPublishingPlugin);
        }
    }

    private void setUpCentralPublishingExecution(Plugin centralPublishingPlugin) {
        PluginExecution execution = new PluginExecution();
        execution.setId("injected-central-publishing");
        execution.getGoals().add("publish");
        execution.setPhase("deploy");
        execution.setConfiguration(centralPublishingPlugin.getConfiguration());
        if (centralPublishingPlugin.getExecutions().stream().noneMatch(item -> execution.getId().equals(item.getId()))) {
            centralPublishingPlugin.getExecutions().add(execution);
        }
    }

    private Plugin getNexusStagingPlugin(Model model) {
        if (model.getBuild() != null) {
            return this.getPluginByCoordinatesFromContainer("org.sonatype.plugins", "nexus-staging-maven-plugin", (PluginContainer)model.getBuild());
        }
        return null;
    }

    private Plugin getMavenDeployPlugin(Model model) {
        if (model.getBuild() != null) {
            return this.getPluginByCoordinatesFromContainer("org.apache.maven.plugins", "maven-deploy-plugin", (PluginContainer)model.getBuild());
        }
        return null;
    }

    private Plugin getCentralPublishingPlugin(Model model) {
        if (model.getBuild() != null) {
            return this.getPluginByCoordinatesFromContainer("org.sonatype.central", "central-publishing-maven-plugin", (PluginContainer)model.getBuild());
        }
        return null;
    }

    private Plugin getPluginByCoordinatesFromContainer(String groupId, String artifactId, PluginContainer pluginContainer) {
        Plugin result = null;
        for (Plugin plugin : pluginContainer.getPlugins()) {
            if (!this.nullToEmpty(groupId).equals(this.nullToEmpty(plugin.getGroupId())) || !this.nullToEmpty(artifactId).equals(this.nullToEmpty(plugin.getArtifactId()))) continue;
            if (result != null) {
                throw new IllegalStateException("The build contains multiple versions of plugin " + groupId + ":" + artifactId);
            }
            result = plugin;
        }
        return result;
    }

    private String nullToEmpty(String value) {
        if (value == null || value.trim().length() == 0) {
            return "";
        }
        return value;
    }
}

