/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web.page;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.web.page.Page;

public class PageTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Page.Builder underTest = Page.builder((String)"governance/project_dump").setName("Project Dump");

    @Test
    public void full_test() {
        Page result = this.underTest.setComponentQualifiers(new Page.Qualifier[]{Page.Qualifier.PROJECT, Page.Qualifier.MODULE}).setScope(Page.Scope.COMPONENT).setAdmin(true).build();
        Assertions.assertThat((String)result.getKey()).isEqualTo((Object)"governance/project_dump");
        Assertions.assertThat((String)result.getName()).isEqualTo((Object)"Project Dump");
        Assertions.assertThat((Iterable)result.getComponentQualifiers()).containsOnly((Object[])new Page.Qualifier[]{Page.Qualifier.PROJECT, Page.Qualifier.MODULE});
        Assertions.assertThat((Comparable)result.getScope()).isEqualTo((Object)Page.Scope.COMPONENT);
        Assertions.assertThat((boolean)result.isAdmin()).isTrue();
    }

    @Test
    public void qualifiers_map_to_key() {
        Assertions.assertThat((String)Page.Qualifier.PROJECT.getKey()).isEqualTo((Object)"TRK");
        Assertions.assertThat((String)Page.Qualifier.MODULE.getKey()).isEqualTo((Object)"BRC");
        Assertions.assertThat((String)Page.Qualifier.VIEW.getKey()).isEqualTo((Object)"VW");
        Assertions.assertThat((String)Page.Qualifier.SUB_VIEW.getKey()).isEqualTo((Object)"SVW");
    }

    @Test
    public void authorized_qualifiers() {
        Object[] qualifiers = Page.Qualifier.values();
        Assertions.assertThat((Object[])qualifiers).hasSize(4).containsOnly((Object[])new Page.Qualifier[]{Page.Qualifier.PROJECT, Page.Qualifier.MODULE, Page.Qualifier.VIEW, Page.Qualifier.SUB_VIEW});
    }

    @Test
    public void default_values() {
        Page result = this.underTest.build();
        Assertions.assertThat((Iterable)result.getComponentQualifiers()).isEmpty();
        Assertions.assertThat((Comparable)result.getScope()).isEqualTo((Object)Page.Scope.GLOBAL);
        Assertions.assertThat((boolean)result.isAdmin()).isFalse();
    }

    @Test
    public void all_qualifiers_when_component_page() {
        Page result = this.underTest.setScope(Page.Scope.COMPONENT).build();
        Assertions.assertThat((Iterable)result.getComponentQualifiers()).containsOnly((Object[])Page.Qualifier.values());
    }

    @Test
    public void qualifiers_from_key() {
        Assertions.assertThat((Comparable)Page.Qualifier.fromKey((String)"TRK")).isEqualTo((Object)Page.Qualifier.PROJECT);
        Assertions.assertThat((Comparable)Page.Qualifier.fromKey((String)"42")).isNull();
    }

    @Test
    public void fail_if_no_qualifier() {
        this.expectedException.expect(NullPointerException.class);
        this.underTest.setComponentQualifiers(null).build();
    }

    @Test
    public void fail_if_a_page_has_a_null_key() {
        this.expectedException.expect(NullPointerException.class);
        Page.builder(null).setName("Say my name").build();
    }

    @Test
    public void fail_if_a_page_has_an_empty_key() {
        this.expectedException.expect(IllegalArgumentException.class);
        Page.builder((String)"").setName("Say my name").build();
    }

    @Test
    public void fail_if_a_page_has_a_null_name() {
        this.expectedException.expect(IllegalArgumentException.class);
        Page.builder((String)"governance/project_dump").build();
    }

    @Test
    public void fail_if_a_page_has_an_empty_name() {
        this.expectedException.expect(IllegalArgumentException.class);
        Page.builder((String)"governance/project_dump").setName("").build();
    }

    @Test
    public void fail_if_qualifiers_without_scope() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.underTest.setComponentQualifiers(new Page.Qualifier[]{Page.Qualifier.PROJECT}).build();
    }
}

