/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web.page;

import java.util.Collection;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.web.page.Context;
import org.sonar.api.web.page.Page;

public class ContextTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Context underTest = new Context();
    private Page page = Page.builder((String)"governance/project_export").setName("Project Export").build();

    @Test
    public void no_pages_with_the_same_path() {
        this.underTest.addPage(this.page);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Page 'Project Export' cannot be loaded. Another page with key 'governance/project_export' already exists.");
        this.underTest.addPage(this.page);
    }

    @Test
    public void ordered_by_name() {
        this.underTest.addPage(Page.builder((String)"K1").setName("N2").build()).addPage(Page.builder((String)"K2").setName("N3").build()).addPage(Page.builder((String)"K3").setName("N1").build());
        Collection result = this.underTest.getPages();
        Assertions.assertThat((Iterable)result).extracting(new Function[]{Page::getKey, Page::getName}).containsOnly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"K3", "N1"}), Assertions.tuple((Object[])new Object[]{"K1", "N2"}), Assertions.tuple((Object[])new Object[]{"K2", "N3"})});
    }

    @Test
    public void empty_pages_by_default() {
        Collection result = this.underTest.getPages();
        Assertions.assertThat((Iterable)result).isEmpty();
    }
}

