/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.web.ServletFilter;

public class ServletFilterTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void include_all() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.create((String)"/*");
        Assertions.assertThat((boolean)pattern.matches("/")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo/ooo")).isTrue();
        Assertions.assertThat((Iterable)pattern.getInclusions()).containsOnly((Object[])new String[]{"/*"});
        Assertions.assertThat((Iterable)pattern.getExclusions()).isEmpty();
    }

    @Test
    public void include_end_of_url() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.create((String)"*foo");
        Assertions.assertThat((boolean)pattern.matches("/")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/hello/foo")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/hello/bar")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo2")).isFalse();
    }

    @Test
    public void include_beginning_of_url() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.create((String)"/foo/*");
        Assertions.assertThat((boolean)pattern.matches("/")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo/bar")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/bar")).isFalse();
    }

    @Test
    public void include_exact_url() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.create((String)"/foo");
        Assertions.assertThat((boolean)pattern.matches("/")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo/")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/bar")).isFalse();
    }

    @Test
    public void exclude_all() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.builder().excludes(new String[]{"/*"}).build();
        Assertions.assertThat((boolean)pattern.matches("/")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo/ooo")).isFalse();
    }

    @Test
    public void exclude_end_of_url() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.builder().excludes(new String[]{"*foo"}).build();
        Assertions.assertThat((boolean)pattern.matches("/")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/hello/foo")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/hello/bar")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo2")).isTrue();
    }

    @Test
    public void exclude_beginning_of_url() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.builder().excludes(new String[]{"/foo/*"}).build();
        Assertions.assertThat((boolean)pattern.matches("/")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo/bar")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/bar")).isTrue();
    }

    @Test
    public void exclude_exact_url() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.builder().excludes(new String[]{"/foo"}).build();
        Assertions.assertThat((boolean)pattern.matches("/")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo/")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/bar")).isTrue();
    }

    @Test
    public void use_multiple_include_patterns() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.builder().includes(new String[]{"/foo", "/foo2"}).build();
        Assertions.assertThat((boolean)pattern.matches("/")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo2")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo/")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/bar")).isFalse();
    }

    @Test
    public void use_multiple_exclude_patterns() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.builder().excludes(new String[]{"/foo", "/foo2"}).build();
        Assertions.assertThat((boolean)pattern.matches("/")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo2")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo/")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/bar")).isTrue();
    }

    @Test
    public void use_include_and_exclude_patterns() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.builder().includes(new String[]{"/foo/*", "/foo/lo*"}).excludes(new String[]{"/foo/login", "/foo/logout", "/foo/list"}).build();
        Assertions.assertThat((boolean)pattern.matches("/")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo/login")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo/logout")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo/list")).isFalse();
        Assertions.assertThat((boolean)pattern.matches("/foo/locale")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo/index")).isTrue();
    }

    @Test
    public void exclude_pattern_has_higher_priority_than_include_pattern() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.builder().includes(new String[]{"/foo"}).excludes(new String[]{"/foo"}).build();
        Assertions.assertThat((boolean)pattern.matches("/foo")).isFalse();
    }

    @Test
    public void accept_empty_patterns() {
        ServletFilter.UrlPattern pattern = ServletFilter.UrlPattern.builder().excludes(new String[0]).includes(new String[0]).build();
        Assertions.assertThat((boolean)pattern.matches("/")).isTrue();
        Assertions.assertThat((boolean)pattern.matches("/foo/bar")).isTrue();
    }

    @Test
    public void create_throws_IAE_if_empty_url() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("URL pattern must start with slash '/': ");
        ServletFilter.UrlPattern.create((String)"");
    }

    @Test
    public void filter_should_return_url_pattern() {
        FakeFilter filter = new FakeFilter();
        Assertions.assertThat((Object)filter.doGetPattern()).isNotNull();
    }

    @Test
    public void filter_should_apply_to_all_urls_by_default() {
        DefaultFilter filter = new DefaultFilter();
        Assertions.assertThat((boolean)filter.doGetPattern().matches("/")).isTrue();
        Assertions.assertThat((boolean)filter.doGetPattern().matches("/foo/bar")).isTrue();
    }

    @Test
    public void getUrl_returns_single_inclusion() {
        Assertions.assertThat((String)ServletFilter.UrlPattern.create((String)"/*").getUrl()).isEqualTo((Object)"/*");
        Assertions.assertThat((String)ServletFilter.UrlPattern.create((String)"/foo/bar").getUrl()).isEqualTo((Object)"/foo/bar");
    }

    @Test
    public void getUrl_throws_ISE_if_many_urls() {
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("this method is deprecated and should not be used anymore");
        ServletFilter.UrlPattern.builder().includes(new String[]{"/foo/*", "/foo/lo*"}).excludes(new String[]{"/foo/login", "/foo/logout", "/foo/list"}).build().getUrl();
    }

    @Test
    public void test_staticResourcePatterns() {
        Assertions.assertThat((Iterable)ServletFilter.UrlPattern.Builder.staticResourcePatterns()).containsOnly((Object[])new String[]{"/css/*", "/fonts/*", "/images/*", "/js/*", "/static/*", "/robots.txt", "/favicon.ico", "/apple-touch-icon*", "/mstile*"});
    }

    private static class DefaultFilter
    extends ServletFilter {
        private DefaultFilter() {
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        }

        public void destroy() {
        }
    }

    private static class FakeFilter
    extends ServletFilter {
        private FakeFilter() {
        }

        public ServletFilter.UrlPattern doGetPattern() {
            return ServletFilter.UrlPattern.create((String)"/fake");
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        }

        public void destroy() {
        }
    }
}

