/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.web.Dashboard;
import org.sonar.api.web.DashboardLayout;

public class DashboardTest {
    @Test
    public void shouldCreateDashboard() {
        Dashboard dashboard = Dashboard.create();
        Assert.assertThat((Object)dashboard.getLayout(), (Matcher)Matchers.is((Object)DashboardLayout.TWO_COLUMNS));
        Assert.assertThat((Object)dashboard.getDescription(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)dashboard.getWidgets().size(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void shouldAddWidgets() {
        Dashboard dashboard = Dashboard.create();
        Dashboard.Widget mostViolatedRules = dashboard.addWidget("most_violated_rules", 1);
        Assert.assertThat((Object)mostViolatedRules.getId(), (Matcher)Matchers.is((Object)"most_violated_rules"));
        Assert.assertThat((Object)dashboard.getWidgets().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dashboard.getWidgetsOfColumn(1).size(), (Matcher)Matchers.is((Object)1));
        dashboard.addWidget("hotspots", 1);
        Assert.assertThat((Object)dashboard.getWidgets().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)dashboard.getWidgetsOfColumn(1).size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)((Dashboard.Widget)dashboard.getWidgetsOfColumn(1).get(1)).getId(), (Matcher)Matchers.is((Object)"hotspots"));
    }

    @Test
    public void shouldAddWidgetsOnDifferentColumns() {
        Dashboard dashboard = Dashboard.create();
        dashboard.addWidget("most_violated_rules", 1);
        Assert.assertThat((Object)dashboard.getWidgets().size(), (Matcher)Matchers.is((Object)1));
        Assert.assertThat((Object)dashboard.getWidgetsOfColumn(1).size(), (Matcher)Matchers.is((Object)1));
        dashboard.addWidget("hotspots", 2);
        Assert.assertThat((Object)dashboard.getWidgets().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)dashboard.getWidgetsOfColumn(2).size(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void shouldAddSeveralTimesTheSameWidget() {
        Dashboard dashboard = Dashboard.create();
        dashboard.addWidget("most_violated_rules", 1);
        dashboard.addWidget("most_violated_rules", 1).setProperty("foo", "bar");
        Assert.assertThat((Object)dashboard.getWidgets().size(), (Matcher)Matchers.is((Object)2));
        Assert.assertThat((Object)((Dashboard.Widget)dashboard.getWidgetsOfColumn(1).get(0)).getProperties().size(), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)((Dashboard.Widget)dashboard.getWidgetsOfColumn(1).get(1)).getProperty("foo"), (Matcher)Matchers.is((Object)"bar"));
    }

    @Test
    public void shouldSetWidgetProperty() {
        Dashboard dashboard = Dashboard.create();
        Dashboard.Widget widget = dashboard.addWidget("fake-widget", 1);
        widget.setProperty("foo", "bar");
        Assert.assertThat(widget.getProperties().get("foo"), (Matcher)Matchers.is((Object)"bar"));
    }
}

