/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.web;

import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.utils.SonarException;
import org.sonar.api.web.AbstractRubyTemplate;

public class AbstractRubyTemplateTest {
    @Test
    public void useCacheWhenTemplateIsInClassloader() {
        AbstractRubyTemplate template = new AbstractRubyTemplate(){

            protected String getTemplatePath() {
                return "/org/sonar/api/web/AbstractRubyTemplateTest/template.erb";
            }
        };
        Assert.assertThat((Object)template.loadTemplateFromCache(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)template.getTemplate(), (Matcher)Matchers.is((Object)"ok"));
        Assert.assertThat((Object)template.loadTemplateFromCache(), (Matcher)Matchers.is((Object)"ok"));
    }

    @Test
    public void doNotCacheWhenAbsolutePath() {
        AbstractRubyTemplate template = new AbstractRubyTemplate(){

            protected String getTemplatePath() {
                URL url = AbstractRubyTemplateTest.class.getResource("/org/sonar/api/web/AbstractRubyTemplateTest/template.erb");
                return url.getPath();
            }
        };
        Assert.assertThat((Object)template.loadTemplateFromCache(), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)template.getTemplate(), (Matcher)Matchers.is((Object)"ok"));
        Assert.assertThat((Object)template.loadTemplateFromCache(), (Matcher)Matchers.nullValue());
    }

    @Test(expected=SonarException.class)
    public void failIfTemplateNotFound() {
        AbstractRubyTemplate template = new AbstractRubyTemplate(){

            protected String getTemplatePath() {
                return "/unknown.erb";
            }
        };
        template.getTemplate();
    }
}

