/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.text;

import java.io.StringWriter;
import java.io.Writer;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.utils.text.WriterException;
import org.sonar.api.utils.text.XmlWriter;

public class XmlWriterTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    StringWriter xml = new StringWriter();
    XmlWriter writer = XmlWriter.of((Writer)this.xml);

    private void expect(String s) {
        Assertions.assertThat((String)this.xml.toString()).isEqualTo((Object)s);
    }

    @Test
    public void declaration() {
        this.writer.declaration().begin("foo").end().close();
        this.expect("<?xml version='1.0' encoding='UTF-8'?><foo/>");
    }

    @Test
    public void end_with_unused_parameter() {
        this.writer.begin("foo").end("foo").close();
        this.expect("<foo/>");
    }

    @Test
    public void only_root() {
        this.writer.begin("foo").end().close();
        this.expect("<foo/>");
    }

    @Test
    public void escape_value() {
        this.writer.prop("foo", "1<2 & 2>=2").close();
        this.expect("<foo>1&lt;2 &amp; 2>=2</foo>");
    }

    @Test
    public void only_root_with_value() {
        this.writer.prop("foo", "bar").close();
        this.expect("<foo>bar</foo>");
    }

    @Test
    public void ignore_null_values() {
        this.writer.begin("root").prop("nullNumber", (Number)null).prop("nullString", (String)null).end().close();
        this.expect("<root/>");
    }

    @Test
    public void fail_on_NaN_value() {
        this.thrown.expect(WriterException.class);
        this.thrown.expectMessage("Fail to write XML. Double value is not valid: NaN");
        this.writer.begin("root").prop("foo", Double.NaN).end().close();
    }
}

