/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.text;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.api.utils.text.WriterException;

public class JsonWriterTest {
    private static final String EMPTY_STRING = "";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private StringWriter json = new StringWriter();
    private JsonWriter writer = JsonWriter.of((Writer)this.json);

    private void expect(String s) {
        Assertions.assertThat((String)this.json.toString()).isEqualTo((Object)s);
    }

    @Test
    public void empty_object() {
        this.writer.beginObject().endObject().close();
        this.expect("{}");
    }

    @Test
    public void empty_array() {
        this.writer.beginArray().endArray().close();
        this.expect("[]");
    }

    @Test
    public void stop_while_streaming() {
        this.writer.beginObject().name("foo").value("bar");
        this.expect("{\"foo\":\"bar\"");
    }

    @Test
    public void objects_and_arrays() {
        this.writer.beginObject().name("issues").beginArray().beginObject().prop("key", "ABC").endObject().beginObject().prop("key", "DEF").endObject().endArray().endObject().close();
        this.expect("{\"issues\":[{\"key\":\"ABC\"},{\"key\":\"DEF\"}]}");
    }

    @Test
    public void array_values() {
        this.writer.beginArray().values(Arrays.asList("foo", "bar", "baz")).endArray().close();
        this.expect("[\"foo\",\"bar\",\"baz\"]");
    }

    @Test
    public void type_of_values() {
        Date date = DateUtils.parseDateTime((String)"2010-05-18T15:50:45+0100");
        this.writer.beginObject().prop("aBoolean", true).prop("aInt", 123L).prop("aLong", 1000L).prop("aDouble", 3.14).prop("aNumber", (Number)new AtomicInteger(123456789)).prop("aString", "bar").propDate("aDate", date).endObject().close();
        this.expect("{\"aBoolean\":true,\"aInt\":123,\"aLong\":1000,\"aDouble\":3.14,\"aNumber\":123456789,\"aString\":\"bar\",\"aDate\":\"2010-05-18\"}");
    }

    @Test
    public void ignore_null_values_by_default() {
        this.writer.beginObject().prop("nullNumber", (Number)null).prop("nullString", (String)null).name("nullNumber").value((Number)null).name("nullString").value((String)null).name("nullDate").valueDate(null).name("nullDateTime").valueDate(null).endObject().close();
        this.expect("{}");
    }

    @Test
    public void serialize_null_values() {
        this.writer.setSerializeNulls(true);
        this.writer.beginObject().prop("nullNumber", (Number)null).prop("nullString", (String)null).name("nullNumber").value((Number)null).name("nullString").value((String)null).name("nullDate").valueDate(null).name("nullDateTime").valueDate(null).endObject().close();
        this.expect("{\"nullNumber\":null,\"nullString\":null,\"nullNumber\":null,\"nullString\":null,\"nullDate\":null,\"nullDateTime\":null}");
    }

    @Test
    public void serialize_empty_strings_by_default() {
        this.writer.beginObject().prop("emptyString", EMPTY_STRING).name("emptyStringAsObject").valueObject((Object)EMPTY_STRING).endObject().close();
        this.expect("{\"emptyString\":\"\",\"emptyStringAsObject\":\"\"}");
    }

    @Test
    public void ignore_empty_strings_when_requested() {
        this.writer.setSerializeEmptys(false).beginObject().prop("emptyString", EMPTY_STRING).name("emptyStringAsObject").valueObject((Object)EMPTY_STRING).endObject().close();
        this.expect("{}");
    }

    @Test
    public void escape_values() {
        this.writer.beginObject().prop("foo", "<hello \"world\">").endObject().close();
        this.expect("{\"foo\":\"<hello \\\"world\\\">\"}");
    }

    @Test
    public void valueObject() {
        this.writer.beginObject().name("aString").valueObject((Object)"stringValue").name("aBoolean").valueObject((Object)true).name("aInt").valueObject((Object)42).name("aFloat").valueObject((Object)3.14).name("aLong").valueObject((Object)42L).name("aList").valueObject(Arrays.asList("one", 2, "three")).name("anEnum").valueObject((Object)ColorEnum.GREEN).name("aMap").valueObject((Object)ImmutableMap.of((Object)"hello", (Object)"world", (Object)"good", (Object)"bye")).endObject().close();
        this.expect("{\"aString\":\"stringValue\",\"aBoolean\":true,\"aInt\":42,\"aFloat\":3.14,\"aLong\":42,\"aList\":[\"one\",2,\"three\"],\"anEnum\":\"GREEN\",\"aMap\":{\"hello\":\"world\",\"good\":\"bye\"}}");
    }

    @Test
    public void valueObject_recursive() {
        ImmutableMap map = ImmutableMap.of((Object)"a", (Object)ImmutableMap.of((Object)"b", (Object)"c"));
        this.writer.valueObject((Object)map).close();
        this.expect("{\"a\":{\"b\":\"c\"}}");
    }

    @Test
    public void valueObject_unsupported_type() {
        try {
            this.writer.beginObject().valueObject((Object)new StringWriter()).endObject().close();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("class org.sonar.api.utils.text.JsonWriter does not support encoding of type: class java.io.StringWriter");
        }
    }

    @Test
    public void fail_on_NaN_value() {
        this.thrown.expect(WriterException.class);
        this.writer.beginObject().prop("foo", Double.NaN).endObject().close();
    }

    @Test
    public void fail_if_not_valid() {
        this.thrown.expect(WriterException.class);
        this.writer.beginObject().endArray().close();
    }

    @Test
    public void fail_to_begin_array() throws Exception {
        com.google.gson.stream.JsonWriter gson = (com.google.gson.stream.JsonWriter)Mockito.mock(com.google.gson.stream.JsonWriter.class);
        Mockito.when((Object)gson.beginArray()).thenThrow(new Throwable[]{new IOException("the reason")});
        this.thrown.expect(WriterException.class);
        this.thrown.expectMessage("Fail to write JSON");
        new JsonWriter(gson).beginArray();
    }

    private static enum ColorEnum {
        RED,
        GREEN;

    }
}

