/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.sonar.api.utils.text.CsvWriter;
import org.sonar.api.utils.text.WriterException;

public class CsvWriterTest {
    @Test
    public void write_csv() throws Exception {
        StringWriter output = new StringWriter();
        CsvWriter writer = CsvWriter.of((Writer)output);
        writer.values(new String[]{"France", "Paris"});
        writer.values(new String[]{"Sweden", "Stockholm"});
        writer.close();
        BufferedReader reader = new BufferedReader(new StringReader(output.toString()));
        String line1 = reader.readLine();
        Assertions.assertThat((String)line1).isEqualTo((Object)"France,Paris");
        String line2 = reader.readLine();
        Assertions.assertThat((String)line2).isEqualTo((Object)"Sweden,Stockholm");
        Assertions.assertThat((String)reader.readLine()).isNull();
    }

    @Test
    public void escape_value() throws Exception {
        StringWriter output = new StringWriter();
        CsvWriter writer = CsvWriter.of((Writer)output);
        writer.values(new String[]{"no double-quotes", "contains \"double-quotes\"", "contains , commas"});
        writer.close();
        BufferedReader reader = new BufferedReader(new StringReader(output.toString()));
        Assertions.assertThat((String)reader.readLine()).isEqualTo((Object)"no double-quotes,\"contains \"\"double-quotes\"\"\",\"contains , commas\"");
        Assertions.assertThat((String)reader.readLine()).isNull();
    }

    @Test
    public void fail_to_write_to_stream() throws Exception {
        Writer output = (Writer)Mockito.mock(Writer.class);
        IOException cause = new IOException("bad");
        ((Writer)Mockito.doThrow((Throwable)cause).when((Object)output)).append(Matchers.anyString());
        CsvWriter writer = CsvWriter.of((Writer)output);
        try {
            writer.values(new String[]{"foo"});
            Assert.fail();
        }
        catch (WriterException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Fail to generate CSV with value: foo");
            Assertions.assertThat((Throwable)e.getCause()).isSameAs((Object)cause);
        }
    }

    @Test
    public void fail_to_close_stream() throws Exception {
        Writer output = (Writer)Mockito.mock(Writer.class);
        IOException cause = new IOException("bad");
        ((Writer)Mockito.doThrow((Throwable)cause).when((Object)output)).close();
        CsvWriter writer = CsvWriter.of((Writer)output);
        writer.values(new String[]{"foo"});
        try {
            writer.close();
            Assert.fail();
        }
        catch (WriterException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Fail to close CSV output");
            Assertions.assertThat((Throwable)e.getCause()).isSameAs((Object)cause);
        }
    }
}

