/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.sonar.api.utils.log.DefaultProfiler;
import org.sonar.api.utils.log.LogTester;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.NullProfiler;
import org.sonar.api.utils.log.Profiler;

public class ProfilerTest {
    @Rule
    public LogTester tester = new LogTester();

    @Test
    public void create() {
        Profiler profiler = Profiler.create((Logger)Loggers.get((String)"foo"));
        Assertions.assertThat((Object)profiler).isInstanceOf(DefaultProfiler.class);
    }

    @Test
    public void create_null_profiler_if_trace_level_is_disabled() {
        this.tester.setLevel(LoggerLevel.TRACE);
        Profiler profiler = Profiler.createIfTrace((Logger)Loggers.get((String)"foo"));
        Assertions.assertThat((Object)profiler).isInstanceOf(DefaultProfiler.class);
        this.tester.setLevel(LoggerLevel.DEBUG);
        profiler = Profiler.createIfTrace((Logger)Loggers.get((String)"foo"));
        Assertions.assertThat((Object)profiler).isInstanceOf(NullProfiler.class);
    }

    @Test
    public void create_null_profiler_if_debug_level_is_disabled() {
        this.tester.setLevel(LoggerLevel.TRACE);
        Profiler profiler = Profiler.createIfDebug((Logger)Loggers.get((String)"foo"));
        Assertions.assertThat((Object)profiler).isInstanceOf(DefaultProfiler.class);
        this.tester.setLevel(LoggerLevel.INFO);
        profiler = Profiler.createIfDebug((Logger)Loggers.get((String)"foo"));
        Assertions.assertThat((Object)profiler).isInstanceOf(NullProfiler.class);
    }
}

