/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import org.sonar.api.utils.log.LogTester;
import org.sonar.api.utils.log.LogbackLogger;
import org.sonar.api.utils.log.LoggerLevel;

public class LogbackLoggerTest {
    LogbackLogger underTest = new LogbackLogger((Logger)LoggerFactory.getLogger(this.getClass()));
    @Rule
    public LogTester tester = new LogTester();

    @Test
    public void log() {
        this.underTest.trace("message");
        this.underTest.trace("message {}", (Object)"foo");
        this.underTest.trace("message {} {}", (Object)"foo", (Object)"bar");
        this.underTest.trace("message {} {} {}", new Object[]{"foo", "bar", "baz"});
        this.underTest.debug("message");
        this.underTest.debug("message {}", (Object)"foo");
        this.underTest.debug("message {} {}", (Object)"foo", (Object)"bar");
        this.underTest.debug("message {} {} {}", new Object[]{"foo", "bar", "baz"});
        this.underTest.info("message");
        this.underTest.info("message {}", (Object)"foo");
        this.underTest.info("message {} {}", (Object)"foo", (Object)"bar");
        this.underTest.info("message {} {} {}", new Object[]{"foo", "bar", "baz"});
        this.underTest.warn("message");
        this.underTest.warn("message {}", (Object)"foo");
        this.underTest.warn("message {} {}", (Object)"foo", (Object)"bar");
        this.underTest.warn("message {} {} {}", new Object[]{"foo", "bar", "baz"});
        this.underTest.warn("message", (Throwable)new NullPointerException("boom!"));
        this.underTest.error("message");
        this.underTest.error("message {}", (Object)"foo");
        this.underTest.error("message {} {}", (Object)"foo", (Object)"bar");
        this.underTest.error("message {} {} {}", new Object[]{"foo", "bar", "baz"});
        this.underTest.error("message", (Throwable)new IllegalArgumentException(""));
    }

    @Test
    public void change_level() {
        Assertions.assertThat((boolean)this.underTest.setLevel(LoggerLevel.INFO)).isTrue();
        Assertions.assertThat((Object)this.underTest.logbackLogger().getLevel()).isEqualTo((Object)Level.INFO);
        Assertions.assertThat((boolean)this.underTest.isDebugEnabled()).isFalse();
        Assertions.assertThat((boolean)this.underTest.isTraceEnabled()).isFalse();
        Assertions.assertThat((boolean)this.underTest.setLevel(LoggerLevel.DEBUG)).isTrue();
        Assertions.assertThat((boolean)this.underTest.isDebugEnabled()).isTrue();
        Assertions.assertThat((boolean)this.underTest.isTraceEnabled()).isFalse();
        Assertions.assertThat((Object)this.underTest.logbackLogger().getLevel()).isEqualTo((Object)Level.DEBUG);
        Assertions.assertThat((boolean)this.underTest.setLevel(LoggerLevel.TRACE)).isTrue();
        Assertions.assertThat((boolean)this.underTest.isDebugEnabled()).isTrue();
        Assertions.assertThat((boolean)this.underTest.isTraceEnabled()).isTrue();
        Assertions.assertThat((Object)this.underTest.logbackLogger().getLevel()).isEqualTo((Object)Level.TRACE);
    }

    @Test
    public void info_level_can_not_be_disabled() {
        try {
            this.underTest.setLevel(LoggerLevel.ERROR);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Only TRACE, DEBUG and INFO logging levels are supported. Got: ERROR");
        }
    }
}

