/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.utils.log.LogInterceptors;
import org.sonar.api.utils.log.LogTester;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.NullInterceptor;

public class LogTesterTest {
    LogTester underTest = new LogTester();

    @Test
    public void info_level_by_default() throws Throwable {
        this.underTest.before();
        Assertions.assertThat((Comparable)this.underTest.getLevel()).isEqualTo((Object)LoggerLevel.INFO);
        Assertions.assertThat((Comparable)Loggers.getFactory().getLevel()).isEqualTo((Object)LoggerLevel.INFO);
        this.underTest.setLevel(LoggerLevel.DEBUG);
        Assertions.assertThat((Comparable)this.underTest.getLevel()).isEqualTo((Object)LoggerLevel.DEBUG);
        Assertions.assertThat((Comparable)Loggers.getFactory().getLevel()).isEqualTo((Object)LoggerLevel.DEBUG);
        this.underTest.after();
        Assertions.assertThat((Comparable)this.underTest.getLevel()).isEqualTo((Object)LoggerLevel.INFO);
        Assertions.assertThat((Comparable)Loggers.getFactory().getLevel()).isEqualTo((Object)LoggerLevel.INFO);
    }

    @Test
    public void intercept_logs() throws Throwable {
        this.underTest.before();
        Loggers.get((String)"logger1").info("an information");
        Loggers.get((String)"logger2").warn("warning: {}", (Object)42);
        Assertions.assertThat((List)this.underTest.logs()).containsExactly((Object[])new String[]{"an information", "warning: 42"});
        Assertions.assertThat((List)this.underTest.logs(LoggerLevel.ERROR)).isEmpty();
        Assertions.assertThat((List)this.underTest.logs(LoggerLevel.INFO)).containsOnly((Object[])new String[]{"an information"});
        Assertions.assertThat((List)this.underTest.logs(LoggerLevel.WARN)).containsOnly((Object[])new String[]{"warning: 42"});
        this.underTest.clear();
        Assertions.assertThat((List)this.underTest.logs()).isEmpty();
        Assertions.assertThat((List)this.underTest.logs(LoggerLevel.INFO)).isEmpty();
        this.underTest.after();
        Assertions.assertThat((Object)LogInterceptors.get()).isSameAs((Object)NullInterceptor.NULL_INSTANCE);
    }

    @Test
    public void use_suppliers() throws Throwable {
        this.underTest.before();
        AtomicBoolean touchedTrace = new AtomicBoolean();
        AtomicBoolean touchedDebug = new AtomicBoolean();
        Loggers.get((String)"logger1").trace(() -> {
            touchedTrace.set(true);
            return "a trace information";
        });
        Loggers.get((String)"logger1").debug(() -> {
            touchedDebug.set(true);
            return "a debug information";
        });
        Assertions.assertThat((List)this.underTest.logs()).isEmpty();
        Assertions.assertThat((boolean)touchedTrace.get()).isFalse();
        Assertions.assertThat((boolean)touchedDebug.get()).isFalse();
        this.underTest.setLevel(LoggerLevel.DEBUG);
        Loggers.get((String)"logger1").trace(() -> {
            touchedTrace.set(true);
            return "a trace information";
        });
        Loggers.get((String)"logger1").debug(() -> {
            touchedDebug.set(true);
            return "a debug information";
        });
        Assertions.assertThat((List)this.underTest.logs()).containsOnly((Object[])new String[]{"a debug information"});
        Assertions.assertThat((boolean)touchedTrace.get()).isFalse();
        Assertions.assertThat((boolean)touchedDebug.get()).isTrue();
        touchedDebug.set(false);
        this.underTest.logs().clear();
        this.underTest.setLevel(LoggerLevel.TRACE);
        Loggers.get((String)"logger1").trace(() -> {
            touchedTrace.set(true);
            return "a trace information";
        });
        Loggers.get((String)"logger1").debug(() -> {
            touchedDebug.set(true);
            return "a debug information";
        });
        Assertions.assertThat((List)this.underTest.logs()).containsExactly((Object[])new String[]{"a trace information", "a debug information"});
        Assertions.assertThat((boolean)touchedTrace.get()).isTrue();
        Assertions.assertThat((boolean)touchedDebug.get()).isTrue();
    }
}

