/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.sonar.api.utils.log.LogTester;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.LoggerLevel;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.log.Profiler;

public class DefaultProfilerTest {
    @Rule
    public LogTester tester = new LogTester();
    Profiler underTest = Profiler.create((Logger)Loggers.get((String)"DefaultProfilerTest"));

    @Test
    public void test_levels() throws Exception {
        Assertions.assertThat((boolean)this.underTest.isDebugEnabled()).isFalse();
        Assertions.assertThat((boolean)this.underTest.isTraceEnabled()).isFalse();
        this.tester.setLevel(LoggerLevel.DEBUG);
        Assertions.assertThat((boolean)this.underTest.isDebugEnabled()).isTrue();
        Assertions.assertThat((boolean)this.underTest.isTraceEnabled()).isFalse();
        this.tester.setLevel(LoggerLevel.TRACE);
        Assertions.assertThat((boolean)this.underTest.isDebugEnabled()).isTrue();
        Assertions.assertThat((boolean)this.underTest.isTraceEnabled()).isTrue();
    }

    @Test
    public void stop_reuses_start_message() {
        this.tester.setLevel(LoggerLevel.TRACE);
        this.underTest.startTrace("Register rules");
        Assertions.assertThat((List)this.tester.logs()).containsOnly((Object[])new String[]{"Register rules"});
        this.underTest.stopTrace();
        Assertions.assertThat((List)this.tester.logs()).hasSize(2);
        Assertions.assertThat((String)((String)this.tester.logs().get(1))).startsWith((CharSequence)"Register rules (done) | time=");
        this.tester.clear();
        this.underTest.startDebug("Register rules");
        Assertions.assertThat((List)this.tester.logs()).containsOnly((Object[])new String[]{"Register rules"});
        this.underTest.stopTrace();
        Assertions.assertThat((List)this.tester.logs()).hasSize(2);
        Assertions.assertThat((String)((String)this.tester.logs().get(1))).startsWith((CharSequence)"Register rules (done) | time=");
        this.tester.clear();
        this.underTest.startInfo("Register rules");
        Assertions.assertThat((List)this.tester.logs()).containsOnly((Object[])new String[]{"Register rules"});
        this.underTest.stopTrace();
        Assertions.assertThat((List)this.tester.logs()).hasSize(2);
        Assertions.assertThat((String)((String)this.tester.logs().get(1))).startsWith((CharSequence)"Register rules (done) | time=");
    }

    @Test
    public void different_start_and_stop_messages() {
        this.tester.setLevel(LoggerLevel.TRACE);
        this.underTest.startTrace("Register rules");
        this.underTest.stopDebug("Rules registered");
        Assertions.assertThat((List)this.tester.logs()).hasSize(2);
        Assertions.assertThat((String)((String)this.tester.logs().get(0))).contains(new CharSequence[]{"Register rules"});
        Assertions.assertThat((String)((String)this.tester.logs().get(1))).startsWith((CharSequence)"Rules registered | time=");
        this.tester.clear();
        this.underTest.startDebug("Register rules");
        this.underTest.stopInfo("Rules registered");
        Assertions.assertThat((List)this.tester.logs()).hasSize(2);
        Assertions.assertThat((String)((String)this.tester.logs().get(0))).contains(new CharSequence[]{"Register rules"});
        Assertions.assertThat((String)((String)this.tester.logs().get(1))).startsWith((CharSequence)"Rules registered | time=");
        this.tester.clear();
        this.underTest.startInfo("Register rules");
        this.underTest.stopTrace("Rules registered");
        Assertions.assertThat((List)this.tester.logs()).hasSize(2);
        Assertions.assertThat((String)((String)this.tester.logs().get(0))).contains(new CharSequence[]{"Register rules"});
        Assertions.assertThat((String)((String)this.tester.logs().get(1))).startsWith((CharSequence)"Rules registered | time=");
    }

    @Test
    public void log_on_at_stop() {
        this.tester.setLevel(LoggerLevel.TRACE);
        this.underTest.start();
        this.underTest.stopTrace("Rules registered");
        Assertions.assertThat((List)this.tester.logs()).hasSize(1);
        Assertions.assertThat((String)((String)this.tester.logs().get(0))).startsWith((CharSequence)"Rules registered | time=");
        this.tester.clear();
        this.underTest.start();
        this.underTest.stopDebug("Rules registered");
        Assertions.assertThat((List)this.tester.logs()).hasSize(1);
        Assertions.assertThat((String)((String)this.tester.logs().get(0))).startsWith((CharSequence)"Rules registered | time=");
        this.tester.clear();
        this.underTest.start();
        this.underTest.stopInfo("Rules registered");
        Assertions.assertThat((List)this.tester.logs()).hasSize(1);
        Assertions.assertThat((String)((String)this.tester.logs().get(0))).startsWith((CharSequence)"Rules registered | time=");
    }

    @Test
    public void add_context() {
        Profiler profiler = Profiler.create((Logger)Loggers.get((String)"DefaultProfilerTest"));
        profiler.addContext("a_string", (Object)"bar");
        profiler.addContext("null_value", null);
        profiler.addContext("an_int", (Object)42);
        profiler.start();
        Assertions.assertThat((List)this.tester.logs()).isEmpty();
        profiler.addContext("after_start", (Object)true);
        profiler.stopInfo("Rules registered");
        Assertions.assertThat((List)this.tester.logs()).hasSize(1);
        Assertions.assertThat((String)((String)this.tester.logs().get(0))).startsWith((CharSequence)"Rules registered | time=").endsWith((CharSequence)"ms | a_string=bar | an_int=42 | after_start=true");
    }

    @Test
    public void empty_message() {
        this.underTest.addContext("foo", (Object)"bar");
        this.underTest.startInfo("");
        Assertions.assertThat((List)this.tester.logs()).containsOnly((Object[])new String[]{"foo=bar"});
        this.underTest.addContext("after_start", (Object)true);
        this.underTest.stopInfo("");
        Assertions.assertThat((List)this.tester.logs()).hasSize(2);
        Assertions.assertThat((String)((String)this.tester.logs().get(1))).startsWith((CharSequence)"time=").endsWith((CharSequence)"ms | foo=bar | after_start=true");
    }

    @Test
    public void fail_if_stop_without_message() {
        this.underTest.start();
        try {
            this.underTest.stopInfo();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Profiler#stopXXX() can't be called without any message defined in start methods");
        }
    }

    @Test
    public void fail_if_stop_without_start() {
        try {
            this.underTest.stopDebug("foo");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Profiler must be started before being stopped");
        }
    }
}

