/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.log;

import java.io.PrintStream;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.sonar.api.utils.log.ConsoleLogger;
import org.sonar.api.utils.log.LogTester;
import org.sonar.api.utils.log.LoggerLevel;

public class ConsoleLoggerTest {
    private PrintStream stream = (PrintStream)Mockito.mock(PrintStream.class);
    private ConsoleLogger underTest = new ConsoleLogger(this.stream);
    @Rule
    public LogTester tester = new LogTester();

    @Test
    public void debug_enabled() {
        this.tester.setLevel(LoggerLevel.DEBUG);
        Assertions.assertThat((boolean)this.underTest.isDebugEnabled()).isTrue();
        Assertions.assertThat((boolean)this.underTest.isTraceEnabled()).isFalse();
        this.underTest.debug("message");
        this.underTest.debug("message {}", (Object)"foo");
        this.underTest.debug("message {} {}", (Object)"foo", (Object)"bar");
        this.underTest.debug("message {} {} {}", new Object[]{"foo", "bar", "baz"});
        ((PrintStream)Mockito.verify((Object)this.stream)).println("DEBUG message");
        ((PrintStream)Mockito.verify((Object)this.stream)).println("DEBUG message foo");
        ((PrintStream)Mockito.verify((Object)this.stream)).println("DEBUG message foo bar");
        ((PrintStream)Mockito.verify((Object)this.stream)).println("DEBUG message foo bar baz");
        Assertions.assertThat((List)this.tester.logs(LoggerLevel.DEBUG)).containsExactly((Object[])new String[]{"message", "message foo", "message foo bar", "message foo bar baz"});
    }

    @Test
    public void debug_disabled() {
        this.tester.setLevel(LoggerLevel.INFO);
        Assertions.assertThat((boolean)this.underTest.isDebugEnabled()).isFalse();
        Assertions.assertThat((boolean)this.underTest.isTraceEnabled()).isFalse();
        this.underTest.debug("message");
        this.underTest.debug("message {}", (Object)"foo");
        this.underTest.debug("message {} {}", (Object)"foo", (Object)"bar");
        this.underTest.debug("message {} {} {}", new Object[]{"foo", "bar", "baz"});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.stream});
    }

    @Test
    public void trace_enabled() {
        this.tester.setLevel(LoggerLevel.TRACE);
        Assertions.assertThat((boolean)this.underTest.isDebugEnabled()).isTrue();
        Assertions.assertThat((boolean)this.underTest.isTraceEnabled()).isTrue();
        this.underTest.trace("message");
        this.underTest.trace("message {}", (Object)"foo");
        this.underTest.trace("message {} {}", (Object)"foo", (Object)"bar");
        this.underTest.trace("message {} {} {}", new Object[]{"foo", "bar", "baz"});
        ((PrintStream)Mockito.verify((Object)this.stream, (VerificationMode)Mockito.times((int)4))).println(Mockito.anyString());
    }

    @Test
    public void trace_disabled() {
        this.tester.setLevel(LoggerLevel.DEBUG);
        Assertions.assertThat((boolean)this.underTest.isTraceEnabled()).isFalse();
        this.underTest.trace("message");
        this.underTest.trace("message {}", (Object)"foo");
        this.underTest.trace("message {} {}", (Object)"foo", (Object)"bar");
        this.underTest.trace("message {} {} {}", new Object[]{"foo", "bar", "baz"});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.stream});
    }

    @Test
    public void log_info() {
        this.underTest.info("message");
        this.underTest.info("message {}", (Object)"foo");
        this.underTest.info("message {} {}", (Object)"foo", (Object)"bar");
        this.underTest.info("message {} {} {}", new Object[]{"foo", "bar", "baz"});
        ((PrintStream)Mockito.verify((Object)this.stream)).println("INFO  message");
        ((PrintStream)Mockito.verify((Object)this.stream)).println("INFO  message foo");
        ((PrintStream)Mockito.verify((Object)this.stream)).println("INFO  message foo bar");
        ((PrintStream)Mockito.verify((Object)this.stream)).println("INFO  message foo bar baz");
        Assertions.assertThat((List)this.tester.logs(LoggerLevel.INFO)).containsExactly((Object[])new String[]{"message", "message foo", "message foo bar", "message foo bar baz"});
    }

    @Test
    public void log_warn() {
        Throwable throwable = (Throwable)Mockito.mock(Throwable.class);
        this.underTest.warn("message");
        this.underTest.warn("message {}", (Object)"foo");
        this.underTest.warn("message {} {}", (Object)"foo", (Object)"bar");
        this.underTest.warn("message {} {} {}", new Object[]{"foo", "bar", "baz"});
        this.underTest.warn("message with exception", throwable);
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((PrintStream)Mockito.verify((Object)this.stream, (VerificationMode)Mockito.times((int)5))).println((String)captor.capture());
        for (String msg : captor.getAllValues()) {
            Assertions.assertThat((String)msg).startsWith((CharSequence)"WARN ");
        }
        ((Throwable)Mockito.verify((Object)throwable)).printStackTrace();
        Assertions.assertThat((List)this.tester.logs(LoggerLevel.WARN)).containsExactly((Object[])new String[]{"message", "message foo", "message foo bar", "message foo bar baz", "message with exception"});
    }

    @Test
    public void log_error() {
        this.underTest.error("message");
        this.underTest.error("message {}", (Object)"foo");
        this.underTest.error("message {} {}", (Object)"foo", (Object)"bar");
        this.underTest.error("message {} {} {}", new Object[]{"foo", "bar", "baz"});
        this.underTest.error("message with exception", (Throwable)new IllegalArgumentException());
        ((PrintStream)Mockito.verify((Object)this.stream, (VerificationMode)Mockito.times((int)5))).println(Mockito.startsWith((String)"ERROR "));
        Assertions.assertThat((List)this.tester.logs(LoggerLevel.ERROR)).containsExactly((Object[])new String[]{"message", "message foo", "message foo bar", "message foo bar baz", "message with exception"});
    }

    @Test
    public void level_change_not_implemented_yet() {
        Assertions.assertThat((boolean)this.underTest.setLevel(LoggerLevel.DEBUG)).isFalse();
    }
}

