/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.internal;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.utils.internal.WorkDuration;

public class WorkDurationTest {
    static final int HOURS_IN_DAY = 8;
    static final Long ONE_MINUTE = 1L;
    static final Long ONE_HOUR_IN_MINUTES = ONE_MINUTE * 60L;
    static final Long ONE_DAY_IN_MINUTES = ONE_HOUR_IN_MINUTES * 8L;

    @Test
    public void create_from_days_hours_minutes() {
        WorkDuration workDuration = WorkDuration.create((int)1, (int)1, (int)1, (int)8);
        Assertions.assertThat((int)workDuration.days()).isEqualTo(1);
        Assertions.assertThat((int)workDuration.hours()).isEqualTo(1);
        Assertions.assertThat((int)workDuration.minutes()).isEqualTo(1);
        Assertions.assertThat((long)workDuration.toMinutes()).isEqualTo(ONE_DAY_IN_MINUTES + ONE_HOUR_IN_MINUTES + ONE_MINUTE);
        Assertions.assertThat((int)workDuration.hoursInDay()).isEqualTo(8);
    }

    @Test
    public void create_from_value_and_unit() {
        WorkDuration result = WorkDuration.createFromValueAndUnit((int)1, (WorkDuration.UNIT)WorkDuration.UNIT.DAYS, (int)8);
        Assertions.assertThat((int)result.days()).isEqualTo(1);
        Assertions.assertThat((int)result.hours()).isEqualTo(0);
        Assertions.assertThat((int)result.minutes()).isEqualTo(0);
        Assertions.assertThat((int)result.hoursInDay()).isEqualTo(8);
        Assertions.assertThat((long)result.toMinutes()).isEqualTo((Object)ONE_DAY_IN_MINUTES);
        Assertions.assertThat((long)WorkDuration.createFromValueAndUnit((int)1, (WorkDuration.UNIT)WorkDuration.UNIT.DAYS, (int)8).toMinutes()).isEqualTo((Object)ONE_DAY_IN_MINUTES);
        Assertions.assertThat((long)WorkDuration.createFromValueAndUnit((int)1, (WorkDuration.UNIT)WorkDuration.UNIT.HOURS, (int)8).toMinutes()).isEqualTo((Object)ONE_HOUR_IN_MINUTES);
        Assertions.assertThat((long)WorkDuration.createFromValueAndUnit((int)1, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8).toMinutes()).isEqualTo((Object)ONE_MINUTE);
    }

    @Test
    public void create_from_minutes() {
        WorkDuration workDuration = WorkDuration.createFromMinutes((long)ONE_MINUTE, (int)8);
        Assertions.assertThat((int)workDuration.days()).isEqualTo(0);
        Assertions.assertThat((int)workDuration.hours()).isEqualTo(0);
        Assertions.assertThat((int)workDuration.minutes()).isEqualTo(1);
        workDuration = WorkDuration.createFromMinutes((long)ONE_HOUR_IN_MINUTES, (int)8);
        Assertions.assertThat((int)workDuration.days()).isEqualTo(0);
        Assertions.assertThat((int)workDuration.hours()).isEqualTo(1);
        Assertions.assertThat((int)workDuration.minutes()).isEqualTo(0);
        workDuration = WorkDuration.createFromMinutes((long)ONE_DAY_IN_MINUTES, (int)8);
        Assertions.assertThat((int)workDuration.days()).isEqualTo(1);
        Assertions.assertThat((int)workDuration.hours()).isEqualTo(0);
        Assertions.assertThat((int)workDuration.minutes()).isEqualTo(0);
    }

    @Test
    public void create_from_working_long() {
        WorkDuration workDuration = WorkDuration.createFromLong((long)1L, (int)8);
        Assertions.assertThat((int)workDuration.days()).isEqualTo(0);
        Assertions.assertThat((int)workDuration.hours()).isEqualTo(0);
        Assertions.assertThat((int)workDuration.minutes()).isEqualTo(1);
        workDuration = WorkDuration.createFromLong((long)100L, (int)8);
        Assertions.assertThat((int)workDuration.days()).isEqualTo(0);
        Assertions.assertThat((int)workDuration.hours()).isEqualTo(1);
        Assertions.assertThat((int)workDuration.minutes()).isEqualTo(0);
        workDuration = WorkDuration.createFromLong((long)10000L, (int)8);
        Assertions.assertThat((int)workDuration.days()).isEqualTo(1);
        Assertions.assertThat((int)workDuration.hours()).isEqualTo(0);
        Assertions.assertThat((int)workDuration.minutes()).isEqualTo(0);
    }

    @Test
    public void convert_to_seconds() {
        Assertions.assertThat((long)WorkDuration.createFromValueAndUnit((int)2, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8).toMinutes()).isEqualTo(2L * ONE_MINUTE);
        Assertions.assertThat((long)WorkDuration.createFromValueAndUnit((int)2, (WorkDuration.UNIT)WorkDuration.UNIT.HOURS, (int)8).toMinutes()).isEqualTo(2L * ONE_HOUR_IN_MINUTES);
        Assertions.assertThat((long)WorkDuration.createFromValueAndUnit((int)2, (WorkDuration.UNIT)WorkDuration.UNIT.DAYS, (int)8).toMinutes()).isEqualTo(2L * ONE_DAY_IN_MINUTES);
    }

    @Test
    public void convert_to_working_days() {
        Assertions.assertThat((double)WorkDuration.createFromValueAndUnit((int)2, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8).toWorkingDays()).isEqualTo(0.004166666666666667);
        Assertions.assertThat((double)WorkDuration.createFromValueAndUnit((int)240, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8).toWorkingDays()).isEqualTo(0.5);
        Assertions.assertThat((double)WorkDuration.createFromValueAndUnit((int)4, (WorkDuration.UNIT)WorkDuration.UNIT.HOURS, (int)8).toWorkingDays()).isEqualTo(0.5);
        Assertions.assertThat((double)WorkDuration.createFromValueAndUnit((int)8, (WorkDuration.UNIT)WorkDuration.UNIT.HOURS, (int)8).toWorkingDays()).isEqualTo(1.0);
        Assertions.assertThat((double)WorkDuration.createFromValueAndUnit((int)16, (WorkDuration.UNIT)WorkDuration.UNIT.HOURS, (int)8).toWorkingDays()).isEqualTo(2.0);
        Assertions.assertThat((double)WorkDuration.createFromValueAndUnit((int)2, (WorkDuration.UNIT)WorkDuration.UNIT.DAYS, (int)8).toWorkingDays()).isEqualTo(2.0);
    }

    @Test
    public void convert_to_working_long() {
        Assertions.assertThat((long)WorkDuration.createFromValueAndUnit((int)2, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8).toLong()).isEqualTo(2L);
        Assertions.assertThat((long)WorkDuration.createFromValueAndUnit((int)4, (WorkDuration.UNIT)WorkDuration.UNIT.HOURS, (int)8).toLong()).isEqualTo(400L);
        Assertions.assertThat((long)WorkDuration.createFromValueAndUnit((int)10, (WorkDuration.UNIT)WorkDuration.UNIT.HOURS, (int)8).toLong()).isEqualTo(10200L);
        Assertions.assertThat((long)WorkDuration.createFromValueAndUnit((int)8, (WorkDuration.UNIT)WorkDuration.UNIT.HOURS, (int)8).toLong()).isEqualTo(10000L);
        Assertions.assertThat((long)WorkDuration.createFromValueAndUnit((int)2, (WorkDuration.UNIT)WorkDuration.UNIT.DAYS, (int)8).toLong()).isEqualTo(20000L);
    }

    @Test
    public void add() {
        WorkDuration result = WorkDuration.createFromValueAndUnit((int)4, (WorkDuration.UNIT)WorkDuration.UNIT.HOURS, (int)8).add(WorkDuration.createFromValueAndUnit((int)5, (WorkDuration.UNIT)WorkDuration.UNIT.HOURS, (int)8));
        Assertions.assertThat((int)result.days()).isEqualTo(1);
        Assertions.assertThat((int)result.hours()).isEqualTo(1);
        Assertions.assertThat((int)result.minutes()).isEqualTo(0);
        Assertions.assertThat((int)result.hoursInDay()).isEqualTo(8);
        result = WorkDuration.createFromValueAndUnit((int)40, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8).add(WorkDuration.createFromValueAndUnit((int)30, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8));
        Assertions.assertThat((int)result.days()).isEqualTo(0);
        Assertions.assertThat((int)result.hours()).isEqualTo(1);
        Assertions.assertThat((int)result.minutes()).isEqualTo(10);
        Assertions.assertThat((int)result.hoursInDay()).isEqualTo(8);
        Assertions.assertThat((int)WorkDuration.createFromValueAndUnit((int)10, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8).add(WorkDuration.createFromValueAndUnit((int)20, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8)).minutes()).isEqualTo(30);
        Assertions.assertThat((int)WorkDuration.createFromValueAndUnit((int)10, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8).add(null).minutes()).isEqualTo(10);
    }

    @Test
    public void subtract() {
        WorkDuration result = WorkDuration.create((int)1, (int)1, (int)0, (int)8).subtract(WorkDuration.createFromValueAndUnit((int)5, (WorkDuration.UNIT)WorkDuration.UNIT.HOURS, (int)8));
        Assertions.assertThat((int)result.days()).isEqualTo(0);
        Assertions.assertThat((int)result.hours()).isEqualTo(4);
        Assertions.assertThat((int)result.minutes()).isEqualTo(0);
        Assertions.assertThat((int)result.hoursInDay()).isEqualTo(8);
        result = WorkDuration.create((int)0, (int)1, (int)10, (int)8).subtract(WorkDuration.createFromValueAndUnit((int)30, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8));
        Assertions.assertThat((int)result.days()).isEqualTo(0);
        Assertions.assertThat((int)result.hours()).isEqualTo(0);
        Assertions.assertThat((int)result.minutes()).isEqualTo(40);
        Assertions.assertThat((int)result.hoursInDay()).isEqualTo(8);
        Assertions.assertThat((int)WorkDuration.createFromValueAndUnit((int)30, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8).subtract(WorkDuration.createFromValueAndUnit((int)20, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8)).minutes()).isEqualTo(10);
        Assertions.assertThat((int)WorkDuration.createFromValueAndUnit((int)10, (WorkDuration.UNIT)WorkDuration.UNIT.MINUTES, (int)8).subtract(null).minutes()).isEqualTo(10);
    }

    @Test
    public void multiply() {
        WorkDuration result = WorkDuration.createFromValueAndUnit((int)5, (WorkDuration.UNIT)WorkDuration.UNIT.HOURS, (int)8).multiply(2);
        Assertions.assertThat((int)result.days()).isEqualTo(1);
        Assertions.assertThat((int)result.hours()).isEqualTo(2);
        Assertions.assertThat((int)result.minutes()).isEqualTo(0);
        Assertions.assertThat((int)result.hoursInDay()).isEqualTo(8);
    }

    @Test
    public void test_equals_and_hashcode() throws Exception {
        WorkDuration duration = WorkDuration.createFromLong((long)28800L, (int)8);
        WorkDuration durationWithSameValue = WorkDuration.createFromLong((long)28800L, (int)8);
        WorkDuration durationWithDifferentValue = WorkDuration.createFromLong((long)14400L, (int)8);
        Assertions.assertThat((Object)duration).isEqualTo((Object)duration);
        Assertions.assertThat((Object)durationWithSameValue).isEqualTo((Object)duration);
        Assertions.assertThat((Object)durationWithDifferentValue).isNotEqualTo((Object)duration);
        Assertions.assertThat((Object)duration).isNotEqualTo(null);
        Assertions.assertThat((int)duration.hashCode()).isEqualTo(duration.hashCode());
        Assertions.assertThat((int)durationWithSameValue.hashCode()).isEqualTo(duration.hashCode());
        Assertions.assertThat((int)durationWithDifferentValue.hashCode()).isNotEqualTo(duration.hashCode());
    }

    @Test
    public void test_toString() throws Exception {
        Assertions.assertThat((String)WorkDuration.createFromLong((long)28800L, (int)8).toString()).isNotNull();
    }
}

