/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.internal;

import java.io.File;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.sonar.api.utils.TempFolder;
import org.sonar.api.utils.internal.DefaultTempFolder;
import org.sonar.api.utils.internal.TempFolderCleaner;

public class DefaultTempFolderTest {
    @Rule
    public ExpectedException throwable = ExpectedException.none();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void createTempFolderAndFile() throws Exception {
        File rootTempFolder = this.temp.newFolder();
        DefaultTempFolder tempFolder = new DefaultTempFolder(rootTempFolder);
        File dir = tempFolder.newDir();
        Assertions.assertThat((File)dir).exists().isDirectory();
        File file = tempFolder.newFile();
        Assertions.assertThat((File)file).exists().isFile();
        new TempFolderCleaner((TempFolder)tempFolder).stop();
        Assertions.assertThat((File)rootTempFolder).doesNotExist();
    }

    @Test
    public void createTempFolderWithName() throws Exception {
        File rootTempFolder = this.temp.newFolder();
        DefaultTempFolder tempFolder = new DefaultTempFolder(rootTempFolder);
        File dir = tempFolder.newDir("sample");
        Assertions.assertThat((File)dir).exists().isDirectory();
        Assertions.assertThat((File)new File(rootTempFolder, "sample")).isEqualTo((Object)dir);
        new TempFolderCleaner((TempFolder)tempFolder).stop();
        Assertions.assertThat((File)rootTempFolder).doesNotExist();
    }

    @Test
    public void createTempFolderWithInvalidName() throws Exception {
        File rootTempFolder = this.temp.newFolder();
        DefaultTempFolder tempFolder = new DefaultTempFolder(rootTempFolder);
        String tooLong = "tooooolong";
        for (int i = 0; i < 50; ++i) {
            tooLong = tooLong + "tooooolong";
        }
        this.throwable.expect(IllegalStateException.class);
        this.throwable.expectMessage("Failed to create temp directory");
        tempFolder.newDir(tooLong);
    }

    @Test
    public void createNewFileWithInvalidName() throws Exception {
        File rootTempFolder = this.temp.newFolder();
        DefaultTempFolder tempFolder = new DefaultTempFolder(rootTempFolder);
        String tooLong = "tooooolong";
        for (int i = 0; i < 50; ++i) {
            tooLong = tooLong + "tooooolong";
        }
        this.throwable.expect(IllegalStateException.class);
        this.throwable.expectMessage("Failed to create temp file");
        tempFolder.newFile(tooLong, ".txt");
    }
}

