/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.internal;

import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.utils.internal.AlwaysIncreasingSystem2;

public class AlwaysIncreasingSystem2Test {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void default_constructor_makes_now_start_with_random_number_and_increase_returned_value_by_100_with_each_call() {
        AlwaysIncreasingSystem2 underTest = new AlwaysIncreasingSystem2();
        this.verifyValuesReturnedByNow(underTest, null, 100);
    }

    @Test
    public void constructor_with_increment_makes_now_start_with_random_number_and_increase_returned_value_by_specified_value_with_each_call() {
        AlwaysIncreasingSystem2 underTest = new AlwaysIncreasingSystem2(663L);
        this.verifyValuesReturnedByNow(underTest, null, 663);
    }

    @Test
    public void constructor_with_initial_value_and_increment_makes_now_start_with_specified_value_and_increase_returned_value_by_specified_value_with_each_call() {
        AlwaysIncreasingSystem2 underTest = new AlwaysIncreasingSystem2(777777L, 96);
        this.verifyValuesReturnedByNow(underTest, 777777L, 96);
    }

    @Test
    public void constructor_with_initial_value_and_increment_throws_IAE_if_initial_value_is_less_than_0() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Initial value must be >= 0");
        new AlwaysIncreasingSystem2(-1L, 100);
    }

    @Test
    public void constructor_with_initial_value_and_increment_accepts_initial_value_0() {
        AlwaysIncreasingSystem2 underTest = new AlwaysIncreasingSystem2(0L, 100);
        this.verifyValuesReturnedByNow(underTest, 0L, 100);
    }

    @Test
    public void constructor_with_initial_value_and_increment_throws_IAE_if_increment_is_0() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("increment must be > 0");
        new AlwaysIncreasingSystem2(10L, 0);
    }

    @Test
    public void constructor_with_initial_value_and_increment_throws_IAE_if_increment_is_less_than_0() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("increment must be > 0");
        new AlwaysIncreasingSystem2(10L, -66);
    }

    @Test
    public void constructor_with_increment_throws_IAE_if_increment_is_0() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("increment must be > 0");
        new AlwaysIncreasingSystem2(0L);
    }

    @Test
    public void constructor_with_increment_throws_IAE_if_increment_is_less_than_0() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("increment must be > 0");
        new AlwaysIncreasingSystem2(-20L);
    }

    private void verifyValuesReturnedByNow(AlwaysIncreasingSystem2 underTest, @Nullable Long initialValue, int increment) {
        long previousValue = -1L;
        for (int i = 0; i < 333; ++i) {
            long now;
            if (previousValue == -1L) {
                now = underTest.now();
                if (initialValue != null) {
                    Assertions.assertThat((long)now).isEqualTo((Object)initialValue);
                } else {
                    Assertions.assertThat((long)now).isGreaterThan(0L);
                }
                previousValue = now;
                continue;
            }
            now = underTest.now();
            Assertions.assertThat((long)now).isEqualTo(previousValue + (long)increment);
            previousValue = now;
        }
    }
}

