/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.dag;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.utils.dag.CyclicDependenciesException;
import org.sonar.api.utils.dag.DirectAcyclicGraph;

public class DirectAcyclicGraphTest {
    @Test(expected=CyclicDependenciesException.class)
    public void shouldFailIfCyclicDependencies() {
        DirectAcyclicGraph dag = new DirectAcyclicGraph(new Object[0]);
        dag.add((Object)"m3", new Object[]{"m1"});
        dag.add((Object)"m1", new Object[]{"m3"});
        dag.sort();
    }

    @Test
    public void sortByDependencies() {
        DirectAcyclicGraph dag = new DirectAcyclicGraph(new Object[0]);
        dag.add((Object)"m1", new Object[]{"m3"});
        dag.add((Object)"m3", new Object[]{"m2"});
        dag.add((Object)"m4", new Object[0]);
        dag.add((Object)"m2", new Object[]{"m4"});
        List result = dag.sort();
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((Object)"m4", result.get(0));
        Assert.assertEquals((Object)"m2", result.get(1));
        Assert.assertEquals((Object)"m3", result.get(2));
        Assert.assertEquals((Object)"m1", result.get(3));
    }

    @Test
    public void keepInsertionOrderWhenNoDependencies() {
        DirectAcyclicGraph dag = new DirectAcyclicGraph(new Object[]{"m3", "m2", "m1"});
        List result = dag.sort();
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)"m3", result.get(0));
        Assert.assertEquals((Object)"m2", result.get(1));
        Assert.assertEquals((Object)"m1", result.get(2));
    }

    @Test
    public void complexGraph() {
        DirectAcyclicGraph dag = new DirectAcyclicGraph(new Object[0]);
        dag.add((Object)"m2", new Object[]{"m4"});
        dag.add((Object)"m1", new Object[]{"m2", "m3"});
        dag.add((Object)"m3", new Object[]{"m2"});
        List result = dag.sort();
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((Object)"m4", result.get(0));
        Assert.assertEquals((Object)"m2", result.get(1));
        Assert.assertEquals((Object)"m3", result.get(2));
        Assert.assertEquals((Object)"m1", result.get(3));
    }

    @Test
    public void aNodeShouldDependOnItself() {
        DirectAcyclicGraph graph = new DirectAcyclicGraph(new Object[0]);
        graph.add((Object)"m1", new Object[]{"m1"});
        List result = graph.sort();
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)"m1", result.get(0));
    }
}

