/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.command;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.command.Command;

public class CommandTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void fail_if_blank_executable() {
        this.thrown.expect(IllegalArgumentException.class);
        Command.create((String)"  ");
    }

    @Test
    public void fail_if_null_executable() {
        this.thrown.expect(IllegalArgumentException.class);
        Command.create(null);
    }

    @Test
    public void create_command() {
        Command command = Command.create((String)"java");
        command.addArgument("-Xmx512m");
        command.addArguments(Arrays.asList("-a", "-b"));
        command.addArguments(new String[]{"-x", "-y"});
        Assertions.assertThat((String)command.getExecutable()).isEqualTo((Object)"java");
        Assertions.assertThat((List)command.getArguments()).hasSize(5);
        Assertions.assertThat((String)command.toCommandLine()).isEqualTo((Object)"java -Xmx512m -a -b -x -y");
    }

    @Test
    public void create_command_with_masked_arguments() {
        Command command = Command.create((String)"java");
        command.addArgument("-Xmx512m");
        command.addMaskedArgument("s3cr3t");
        command.addArguments(new String[]{"-x", "-y"});
        Assertions.assertThat((String)command.getExecutable()).isEqualTo((Object)"java");
        Assertions.assertThat((List)command.getArguments()).hasSize(4);
        Assertions.assertThat((String)command.toCommandLine()).isEqualTo((Object)"java -Xmx512m s3cr3t -x -y");
        Assertions.assertThat((String)command.toString()).isEqualTo((Object)"java -Xmx512m ******** -x -y");
    }

    @Test
    public void toString_is_the_command_line() {
        Command command = Command.create((String)"java");
        command.addArgument("-Xmx512m");
        Assertions.assertThat((String)command.toString()).isEqualTo((Object)command.toCommandLine());
    }

    @Test
    public void working_directory() {
        Command command = Command.create((String)"java");
        Assertions.assertThat((File)command.getDirectory()).isNull();
        File working = new File("working");
        command = Command.create((String)"java").setDirectory(working);
        Assertions.assertThat((File)command.getDirectory()).isEqualTo((Object)working);
    }

    @Test
    public void initialize_with_current_env() {
        Command command = Command.create((String)"java");
        Assertions.assertThat((Map)command.getEnvironmentVariables()).isNotEmpty();
    }

    @Test
    public void override_env_variables() {
        System2 system = (System2)Mockito.mock(System2.class);
        Mockito.when((Object)system.envVariables()).thenReturn((Object)ImmutableMap.of((Object)"JAVA_HOME", (Object)"/default/path/to/java"));
        Command command = new Command("java", system);
        command.setEnvironmentVariable("JAVA_HOME", "/new/path/to/java");
        Assertions.assertThat((String)((String)command.getEnvironmentVariables().get("JAVA_HOME"))).isEqualTo((Object)"/new/path/to/java");
    }

    @Test
    public void should_use_cmd_for_new_shell_on_windows() {
        System2 system = (System2)Mockito.mock(System2.class);
        Mockito.when((Object)system.isOsWindows()).thenReturn((Object)true);
        Command command = new Command("foo.bat", system);
        command.setNewShell(true);
        Assertions.assertThat((String)command.toCommandLine()).isEqualTo((Object)"cmd /C call foo.bat");
        Assertions.assertThat((boolean)command.isNewShell()).isTrue();
    }

    @Test
    public void should_use_sh_for_new_shell_on_unix() {
        System2 system = (System2)Mockito.mock(System2.class);
        Mockito.when((Object)system.isOsWindows()).thenReturn((Object)false);
        Command command = new Command("foo.sh", system);
        command.setNewShell(true);
        Assertions.assertThat((String)command.toCommandLine()).isEqualTo((Object)"sh foo.sh");
        Assertions.assertThat((boolean)command.isNewShell()).isTrue();
    }

    @Test
    public void shouldnt_use_new_shell_by_default() {
        Command command = Command.create((String)"foo.sh");
        Assertions.assertThat((boolean)command.isNewShell()).isFalse();
    }
}

