/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils.command;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestName;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.command.Command;
import org.sonar.api.utils.command.CommandException;
import org.sonar.api.utils.command.CommandExecutor;
import org.sonar.api.utils.command.StreamConsumer;
import org.sonar.api.utils.command.TimeoutException;

public class CommandExecutorTest {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public TestName testName = new TestName();
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private File workDir;
    private static final StreamConsumer NOP_CONSUMER = new StreamConsumer(){

        public void consumeLine(String line) {
        }
    };
    private static final StreamConsumer BAD_CONSUMER = new StreamConsumer(){

        public void consumeLine(String line) {
            throw new RuntimeException();
        }
    };

    @Before
    public void before() throws IOException {
        this.workDir = this.tempFolder.newFolder(this.testName.getMethodName());
    }

    @Test(timeout=3000L)
    public void should_consume_StdOut_and_StdErr() throws Exception {
        if (!SystemUtils.IS_OS_WINDOWS) {
            final StringBuilder stdOutBuilder = new StringBuilder();
            StreamConsumer stdOutConsumer = new StreamConsumer(){

                public void consumeLine(String line) {
                    stdOutBuilder.append(line).append(SystemUtils.LINE_SEPARATOR);
                }
            };
            final StringBuilder stdErrBuilder = new StringBuilder();
            StreamConsumer stdErrConsumer = new StreamConsumer(){

                public void consumeLine(String line) {
                    stdErrBuilder.append(line).append(SystemUtils.LINE_SEPARATOR);
                }
            };
            Command command = Command.create((String)CommandExecutorTest.getScript("output")).setDirectory(this.workDir);
            int exitCode = CommandExecutor.create().execute(command, stdOutConsumer, stdErrConsumer, 1000L);
            Assertions.assertThat((int)exitCode).isEqualTo(0);
            String stdOut = stdOutBuilder.toString();
            String stdErr = stdErrBuilder.toString();
            Assertions.assertThat((String)stdOut).contains(new CharSequence[]{"stdOut: first line"});
            Assertions.assertThat((String)stdOut).contains(new CharSequence[]{"stdOut: second line"});
            Assertions.assertThat((String)stdErr).contains(new CharSequence[]{"stdErr: first line"});
            Assertions.assertThat((String)stdErr).contains(new CharSequence[]{"stdErr: second line"});
        }
    }

    @Test(timeout=3000L)
    public void stdOut_consumer_can_throw_exception() throws Exception {
        Command command = Command.create((String)CommandExecutorTest.getScript("output")).setDirectory(this.workDir);
        this.thrown.expect(CommandException.class);
        this.thrown.expectMessage("Error inside stdOut stream");
        CommandExecutor.create().execute(command, BAD_CONSUMER, NOP_CONSUMER, 1000L);
    }

    @Test(timeout=3000L)
    public void stdErr_consumer_can_throw_exception() throws Exception {
        Command command = Command.create((String)CommandExecutorTest.getScript("output")).setDirectory(this.workDir);
        this.thrown.expect(CommandException.class);
        this.thrown.expectMessage("Error inside stdErr stream");
        CommandExecutor.create().execute(command, NOP_CONSUMER, BAD_CONSUMER, 1500L);
    }

    @Test
    public void should_use_working_directory_to_store_argument_and_environment_variable() throws Exception {
        Command command = Command.create((String)CommandExecutorTest.getScript("echo")).setDirectory(this.workDir).addArgument("1").setEnvironmentVariable("ENVVAR", "2");
        int exitCode = CommandExecutor.create().execute(command, 1000L);
        Assertions.assertThat((int)exitCode).isEqualTo(0);
        File logFile = new File(this.workDir, "echo.log");
        Assertions.assertThat((File)logFile).exists();
        String log = FileUtils.readFileToString((File)logFile);
        Assertions.assertThat((String)log).contains(new CharSequence[]{this.workDir.getAbsolutePath()});
        Assertions.assertThat((String)log).contains(new CharSequence[]{"Parameter: 1"});
        Assertions.assertThat((String)log).contains(new CharSequence[]{"Environment variable: 2"});
    }

    @Test(timeout=6000L)
    public void should_stop_after_timeout() throws IOException {
        try {
            String executable = CommandExecutorTest.getScript("forever");
            CommandExecutor.create().execute(Command.create((String)executable).setDirectory(this.workDir), 1000L);
            Assert.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test(timeout=6000L)
    public void should_stop_after_timeout_and_new_shell() throws IOException {
        try {
            String executable = CommandExecutorTest.getScript("forever");
            CommandExecutor.create().execute(Command.create((String)executable).setNewShell(true).setDirectory(this.workDir), 1000L);
            Assert.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void should_fail_if_script_not_found() {
        this.thrown.expect(CommandException.class);
        CommandExecutor.create().execute(Command.create((String)"notfound").setDirectory(this.workDir), 1000L);
    }

    private static String getScript(String name) throws IOException {
        String filename = System2.INSTANCE.isOsWindows() ? name + ".bat" : name + ".sh";
        return new File("src/test/scripts/" + filename).getCanonicalPath();
    }
}

