/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Files;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.sonar.api.utils.ZipUtils;

public class ZipUtilsTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void zip_directory() throws IOException {
        File foo = FileUtils.toFile((URL)this.getClass().getResource("/org/sonar/api/utils/ZipUtilsTest/shouldZipDirectory/foo.txt"));
        File dir = foo.getParentFile();
        File zip = this.temp.newFile();
        ZipUtils.zipDir((File)dir, (File)zip);
        Assertions.assertThat((File)zip).exists().isFile();
        Assertions.assertThat((long)zip.length()).isGreaterThan(1L);
        UnmodifiableIterator zipEntries = Iterators.forEnumeration(new ZipFile(zip).entries());
        Assertions.assertThat((Iterator)zipEntries).hasSize(4);
        File unzipDir = this.temp.newFolder();
        ZipUtils.unzip((File)zip, (File)unzipDir);
        Assertions.assertThat((File)new File(unzipDir, "bar.txt")).exists().isFile();
        Assertions.assertThat((File)new File(unzipDir, "foo.txt")).exists().isFile();
        Assertions.assertThat((File)new File(unzipDir, "dir1/hello.properties")).exists().isFile();
    }

    @Test
    public void unzipping_creates_target_directory_if_it_does_not_exist() throws IOException {
        File zip = FileUtils.toFile((URL)this.urlToZip());
        File tempDir = this.temp.newFolder();
        Files.delete((File)tempDir);
        File subDir = new File(tempDir, "subDir");
        ZipUtils.unzip((File)zip, (File)subDir);
        Assertions.assertThat((Object[])subDir.list()).hasSize(3);
    }

    @Test
    public void unzip_file() throws IOException {
        File zip = FileUtils.toFile((URL)this.urlToZip());
        File toDir = this.temp.newFolder();
        ZipUtils.unzip((File)zip, (File)toDir);
        Assertions.assertThat((Object[])toDir.list()).hasSize(3);
    }

    @Test
    public void unzip_stream() throws Exception {
        InputStream zip = this.urlToZip().openStream();
        File toDir = this.temp.newFolder();
        ZipUtils.unzip((InputStream)zip, (File)toDir);
        Assertions.assertThat((Object[])toDir.list()).hasSize(3);
    }

    @Test
    public void unzipping_file_extracts_subset_of_files() throws IOException {
        File zip = FileUtils.toFile((URL)this.urlToZip());
        File toDir = this.temp.newFolder();
        ZipUtils.unzip((File)zip, (File)toDir, ze -> ze.getName().equals("foo.txt"));
        Assertions.assertThat((Object[])toDir.listFiles()).containsOnly((Object[])new File[]{new File(toDir, "foo.txt")});
    }

    @Test
    public void unzipping_stream_extracts_subset_of_files() throws IOException {
        InputStream zip = this.urlToZip().openStream();
        File toDir = this.temp.newFolder();
        ZipUtils.unzip((InputStream)zip, (File)toDir, ze -> ze.getName().equals("foo.txt"));
        Assertions.assertThat((Object[])toDir.listFiles()).containsOnly((Object[])new File[]{new File(toDir, "foo.txt")});
    }

    private URL urlToZip() {
        return this.getClass().getResource("/org/sonar/api/utils/ZipUtilsTest/shouldUnzipFile.zip");
    }
}

